/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleContainerEngineVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_container_engine_versions#id DataGoogleContainerEngineVersions#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_container_engine_versions#location DataGoogleContainerEngineVersions#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_container_engine_versions#project DataGoogleContainerEngineVersions#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_container_engine_versions#version_prefix DataGoogleContainerEngineVersions#version_prefix}
    */
    readonly versionPrefix?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_container_engine_versions google_container_engine_versions}
*/
export declare class DataGoogleContainerEngineVersions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_container_engine_versions";
    /**
    * Generates CDKTF code for importing a DataGoogleContainerEngineVersions resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleContainerEngineVersions to import
    * @param importFromId The id of the existing DataGoogleContainerEngineVersions that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_container_engine_versions#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleContainerEngineVersions to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_container_engine_versions google_container_engine_versions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleContainerEngineVersionsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleContainerEngineVersionsConfig);
    get defaultClusterVersion(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get latestMasterVersion(): string;
    get latestNodeVersion(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _releaseChannelDefaultVersion;
    get releaseChannelDefaultVersion(): cdktf.StringMap;
    private _releaseChannelLatestVersion;
    get releaseChannelLatestVersion(): cdktf.StringMap;
    get validMasterVersions(): string[];
    get validNodeVersions(): string[];
    private _versionPrefix?;
    get versionPrefix(): string;
    set versionPrefix(value: string);
    resetVersionPrefix(): void;
    get versionPrefixInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
