/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleDnsManagedZonesConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the project for the Google Cloud.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_dns_managed_zones#project DataGoogleDnsManagedZones#project}
    */
    readonly project?: string;
    /**
    * managed_zones block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_dns_managed_zones#managed_zones DataGoogleDnsManagedZones#managed_zones}
    */
    readonly managedZones?: DataGoogleDnsManagedZonesManagedZones[] | cdktf.IResolvable;
}
export interface DataGoogleDnsManagedZonesManagedZones {
}
export declare function dataGoogleDnsManagedZonesManagedZonesToTerraform(struct?: DataGoogleDnsManagedZonesManagedZones | cdktf.IResolvable): any;
export declare function dataGoogleDnsManagedZonesManagedZonesToHclTerraform(struct?: DataGoogleDnsManagedZonesManagedZones | cdktf.IResolvable): any;
export declare class DataGoogleDnsManagedZonesManagedZonesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDnsManagedZonesManagedZones | cdktf.IResolvable | undefined;
    set internalValue(value: DataGoogleDnsManagedZonesManagedZones | cdktf.IResolvable | undefined);
    get description(): string;
    get dnsName(): string;
    get id(): string;
    get managedZoneId(): number;
    get name(): string;
    get nameServers(): string[];
    get project(): string;
    get visibility(): string;
}
export declare class DataGoogleDnsManagedZonesManagedZonesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataGoogleDnsManagedZonesManagedZones[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDnsManagedZonesManagedZonesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_dns_managed_zones google_dns_managed_zones}
*/
export declare class DataGoogleDnsManagedZones extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_dns_managed_zones";
    /**
    * Generates CDKTF code for importing a DataGoogleDnsManagedZones resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleDnsManagedZones to import
    * @param importFromId The id of the existing DataGoogleDnsManagedZones that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_dns_managed_zones#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleDnsManagedZones to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_dns_managed_zones google_dns_managed_zones} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleDnsManagedZonesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleDnsManagedZonesConfig);
    get id(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _managedZones;
    get managedZones(): DataGoogleDnsManagedZonesManagedZonesList;
    putManagedZones(value: DataGoogleDnsManagedZonesManagedZones[] | cdktf.IResolvable): void;
    resetManagedZones(): void;
    get managedZonesInput(): cdktf.IResolvable | DataGoogleDnsManagedZonesManagedZones[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
