/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleHealthcareFhirStoreIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_healthcare_fhir_store_iam_policy#fhir_store_id DataGoogleHealthcareFhirStoreIamPolicy#fhir_store_id}
    */
    readonly fhirStoreId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_healthcare_fhir_store_iam_policy#id DataGoogleHealthcareFhirStoreIamPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_healthcare_fhir_store_iam_policy google_healthcare_fhir_store_iam_policy}
*/
export declare class DataGoogleHealthcareFhirStoreIamPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_healthcare_fhir_store_iam_policy";
    /**
    * Generates CDKTF code for importing a DataGoogleHealthcareFhirStoreIamPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleHealthcareFhirStoreIamPolicy to import
    * @param importFromId The id of the existing DataGoogleHealthcareFhirStoreIamPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_healthcare_fhir_store_iam_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleHealthcareFhirStoreIamPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_healthcare_fhir_store_iam_policy google_healthcare_fhir_store_iam_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleHealthcareFhirStoreIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleHealthcareFhirStoreIamPolicyConfig);
    get etag(): string;
    private _fhirStoreId?;
    get fhirStoreId(): string;
    set fhirStoreId(value: string);
    get fhirStoreIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get policyData(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
