/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleIamTestablePermissionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_iam_testable_permissions#custom_support_level DataGoogleIamTestablePermissions#custom_support_level}
    */
    readonly customSupportLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_iam_testable_permissions#full_resource_name DataGoogleIamTestablePermissions#full_resource_name}
    */
    readonly fullResourceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_iam_testable_permissions#id DataGoogleIamTestablePermissions#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_iam_testable_permissions#stages DataGoogleIamTestablePermissions#stages}
    */
    readonly stages?: string[];
}
export interface DataGoogleIamTestablePermissionsPermissions {
}
export declare function dataGoogleIamTestablePermissionsPermissionsToTerraform(struct?: DataGoogleIamTestablePermissionsPermissions): any;
export declare function dataGoogleIamTestablePermissionsPermissionsToHclTerraform(struct?: DataGoogleIamTestablePermissionsPermissions): any;
export declare class DataGoogleIamTestablePermissionsPermissionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleIamTestablePermissionsPermissions | undefined;
    set internalValue(value: DataGoogleIamTestablePermissionsPermissions | undefined);
    get apiDisabled(): cdktf.IResolvable;
    get customSupportLevel(): string;
    get name(): string;
    get stage(): string;
    get title(): string;
}
export declare class DataGoogleIamTestablePermissionsPermissionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleIamTestablePermissionsPermissionsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_iam_testable_permissions google_iam_testable_permissions}
*/
export declare class DataGoogleIamTestablePermissions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_iam_testable_permissions";
    /**
    * Generates CDKTF code for importing a DataGoogleIamTestablePermissions resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleIamTestablePermissions to import
    * @param importFromId The id of the existing DataGoogleIamTestablePermissions that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_iam_testable_permissions#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleIamTestablePermissions to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_iam_testable_permissions google_iam_testable_permissions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleIamTestablePermissionsConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleIamTestablePermissionsConfig);
    private _customSupportLevel?;
    get customSupportLevel(): string;
    set customSupportLevel(value: string);
    resetCustomSupportLevel(): void;
    get customSupportLevelInput(): string | undefined;
    private _fullResourceName?;
    get fullResourceName(): string;
    set fullResourceName(value: string);
    get fullResourceNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _permissions;
    get permissions(): DataGoogleIamTestablePermissionsPermissionsList;
    private _stages?;
    get stages(): string[];
    set stages(value: string[]);
    resetStages(): void;
    get stagesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
