/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleIamWorkloadIdentityPoolProviderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_iam_workload_identity_pool_provider#id DataGoogleIamWorkloadIdentityPoolProvider#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_iam_workload_identity_pool_provider#project DataGoogleIamWorkloadIdentityPoolProvider#project}
    */
    readonly project?: string;
    /**
    * The ID used for the pool, which is the final component of the pool resource name. This
    * value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
    * 'gcp-' is reserved for use by Google, and may not be specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_iam_workload_identity_pool_provider#workload_identity_pool_id DataGoogleIamWorkloadIdentityPoolProvider#workload_identity_pool_id}
    */
    readonly workloadIdentityPoolId: string;
    /**
    * The ID for the provider, which becomes the final component of the resource name. This
    * value must be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
    * 'gcp-' is reserved for use by Google, and may not be specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_iam_workload_identity_pool_provider#workload_identity_pool_provider_id DataGoogleIamWorkloadIdentityPoolProvider#workload_identity_pool_provider_id}
    */
    readonly workloadIdentityPoolProviderId: string;
}
export interface DataGoogleIamWorkloadIdentityPoolProviderAws {
}
export declare function dataGoogleIamWorkloadIdentityPoolProviderAwsToTerraform(struct?: DataGoogleIamWorkloadIdentityPoolProviderAws): any;
export declare function dataGoogleIamWorkloadIdentityPoolProviderAwsToHclTerraform(struct?: DataGoogleIamWorkloadIdentityPoolProviderAws): any;
export declare class DataGoogleIamWorkloadIdentityPoolProviderAwsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleIamWorkloadIdentityPoolProviderAws | undefined;
    set internalValue(value: DataGoogleIamWorkloadIdentityPoolProviderAws | undefined);
    get accountId(): string;
}
export declare class DataGoogleIamWorkloadIdentityPoolProviderAwsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleIamWorkloadIdentityPoolProviderAwsOutputReference;
}
export interface DataGoogleIamWorkloadIdentityPoolProviderOidc {
}
export declare function dataGoogleIamWorkloadIdentityPoolProviderOidcToTerraform(struct?: DataGoogleIamWorkloadIdentityPoolProviderOidc): any;
export declare function dataGoogleIamWorkloadIdentityPoolProviderOidcToHclTerraform(struct?: DataGoogleIamWorkloadIdentityPoolProviderOidc): any;
export declare class DataGoogleIamWorkloadIdentityPoolProviderOidcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleIamWorkloadIdentityPoolProviderOidc | undefined;
    set internalValue(value: DataGoogleIamWorkloadIdentityPoolProviderOidc | undefined);
    get allowedAudiences(): string[];
    get issuerUri(): string;
    get jwksJson(): string;
}
export declare class DataGoogleIamWorkloadIdentityPoolProviderOidcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleIamWorkloadIdentityPoolProviderOidcOutputReference;
}
export interface DataGoogleIamWorkloadIdentityPoolProviderSaml {
}
export declare function dataGoogleIamWorkloadIdentityPoolProviderSamlToTerraform(struct?: DataGoogleIamWorkloadIdentityPoolProviderSaml): any;
export declare function dataGoogleIamWorkloadIdentityPoolProviderSamlToHclTerraform(struct?: DataGoogleIamWorkloadIdentityPoolProviderSaml): any;
export declare class DataGoogleIamWorkloadIdentityPoolProviderSamlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleIamWorkloadIdentityPoolProviderSaml | undefined;
    set internalValue(value: DataGoogleIamWorkloadIdentityPoolProviderSaml | undefined);
    get idpMetadataXml(): string;
}
export declare class DataGoogleIamWorkloadIdentityPoolProviderSamlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleIamWorkloadIdentityPoolProviderSamlOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_iam_workload_identity_pool_provider google_iam_workload_identity_pool_provider}
*/
export declare class DataGoogleIamWorkloadIdentityPoolProvider extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_iam_workload_identity_pool_provider";
    /**
    * Generates CDKTF code for importing a DataGoogleIamWorkloadIdentityPoolProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleIamWorkloadIdentityPoolProvider to import
    * @param importFromId The id of the existing DataGoogleIamWorkloadIdentityPoolProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_iam_workload_identity_pool_provider#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleIamWorkloadIdentityPoolProvider to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_iam_workload_identity_pool_provider google_iam_workload_identity_pool_provider} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleIamWorkloadIdentityPoolProviderConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleIamWorkloadIdentityPoolProviderConfig);
    get attributeCondition(): string;
    private _attributeMapping;
    get attributeMapping(): cdktf.StringMap;
    private _aws;
    get aws(): DataGoogleIamWorkloadIdentityPoolProviderAwsList;
    get description(): string;
    get disabled(): cdktf.IResolvable;
    get displayName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _oidc;
    get oidc(): DataGoogleIamWorkloadIdentityPoolProviderOidcList;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _saml;
    get saml(): DataGoogleIamWorkloadIdentityPoolProviderSamlList;
    get state(): string;
    private _workloadIdentityPoolId?;
    get workloadIdentityPoolId(): string;
    set workloadIdentityPoolId(value: string);
    get workloadIdentityPoolIdInput(): string | undefined;
    private _workloadIdentityPoolProviderId?;
    get workloadIdentityPoolProviderId(): string;
    set workloadIdentityPoolProviderId(value: string);
    get workloadIdentityPoolProviderIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
