/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleKmsSecretCiphertextConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_kms_secret_ciphertext#crypto_key DataGoogleKmsSecretCiphertext#crypto_key}
    */
    readonly cryptoKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_kms_secret_ciphertext#id DataGoogleKmsSecretCiphertext#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_kms_secret_ciphertext#plaintext DataGoogleKmsSecretCiphertext#plaintext}
    */
    readonly plaintext: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_kms_secret_ciphertext google_kms_secret_ciphertext}
*/
export declare class DataGoogleKmsSecretCiphertext extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_kms_secret_ciphertext";
    /**
    * Generates CDKTF code for importing a DataGoogleKmsSecretCiphertext resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleKmsSecretCiphertext to import
    * @param importFromId The id of the existing DataGoogleKmsSecretCiphertext that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_kms_secret_ciphertext#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleKmsSecretCiphertext to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_kms_secret_ciphertext google_kms_secret_ciphertext} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleKmsSecretCiphertextConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleKmsSecretCiphertextConfig);
    get ciphertext(): string;
    private _cryptoKey?;
    get cryptoKey(): string;
    set cryptoKey(value: string);
    get cryptoKeyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _plaintext?;
    get plaintext(): string;
    set plaintext(value: string);
    get plaintextInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
