/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleLoggingOrganizationSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_logging_organization_settings#id DataGoogleLoggingOrganizationSettings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The organization for which to retrieve settings.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_logging_organization_settings#organization DataGoogleLoggingOrganizationSettings#organization}
    */
    readonly organization: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_logging_organization_settings google_logging_organization_settings}
*/
export declare class DataGoogleLoggingOrganizationSettings extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_logging_organization_settings";
    /**
    * Generates CDKTF code for importing a DataGoogleLoggingOrganizationSettings resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleLoggingOrganizationSettings to import
    * @param importFromId The id of the existing DataGoogleLoggingOrganizationSettings that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_logging_organization_settings#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleLoggingOrganizationSettings to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_logging_organization_settings google_logging_organization_settings} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleLoggingOrganizationSettingsConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleLoggingOrganizationSettingsConfig);
    get disableDefaultSink(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kmsKeyName(): string;
    get kmsServiceAccountId(): string;
    get loggingServiceAccountId(): string;
    get name(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    get storageLocation(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
