/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleLoggingSinkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Required. An identifier for the resource in format: "projects/[PROJECT_ID]/sinks/[SINK_NAME]", "organizations/[ORGANIZATION_ID]/sinks/[SINK_NAME]", "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_NAME]", "folders/[FOLDER_ID]/sinks/[SINK_NAME]"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_logging_sink#id DataGoogleLoggingSink#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export interface DataGoogleLoggingSinkBigqueryOptions {
}
export declare function dataGoogleLoggingSinkBigqueryOptionsToTerraform(struct?: DataGoogleLoggingSinkBigqueryOptions): any;
export declare function dataGoogleLoggingSinkBigqueryOptionsToHclTerraform(struct?: DataGoogleLoggingSinkBigqueryOptions): any;
export declare class DataGoogleLoggingSinkBigqueryOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleLoggingSinkBigqueryOptions | undefined;
    set internalValue(value: DataGoogleLoggingSinkBigqueryOptions | undefined);
    get usePartitionedTables(): cdktf.IResolvable;
}
export declare class DataGoogleLoggingSinkBigqueryOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleLoggingSinkBigqueryOptionsOutputReference;
}
export interface DataGoogleLoggingSinkExclusions {
}
export declare function dataGoogleLoggingSinkExclusionsToTerraform(struct?: DataGoogleLoggingSinkExclusions): any;
export declare function dataGoogleLoggingSinkExclusionsToHclTerraform(struct?: DataGoogleLoggingSinkExclusions): any;
export declare class DataGoogleLoggingSinkExclusionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleLoggingSinkExclusions | undefined;
    set internalValue(value: DataGoogleLoggingSinkExclusions | undefined);
    get description(): string;
    get disabled(): cdktf.IResolvable;
    get filter(): string;
    get name(): string;
}
export declare class DataGoogleLoggingSinkExclusionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleLoggingSinkExclusionsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_logging_sink google_logging_sink}
*/
export declare class DataGoogleLoggingSink extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_logging_sink";
    /**
    * Generates CDKTF code for importing a DataGoogleLoggingSink resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleLoggingSink to import
    * @param importFromId The id of the existing DataGoogleLoggingSink that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_logging_sink#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleLoggingSink to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_logging_sink google_logging_sink} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleLoggingSinkConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleLoggingSinkConfig);
    private _bigqueryOptions;
    get bigqueryOptions(): DataGoogleLoggingSinkBigqueryOptionsList;
    get description(): string;
    get destination(): string;
    get disabled(): cdktf.IResolvable;
    private _exclusions;
    get exclusions(): DataGoogleLoggingSinkExclusionsList;
    get filter(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    get name(): string;
    get writerIdentity(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
