/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGooglePubsubSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_pubsub_subscription#id DataGooglePubsubSubscription#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the subscription.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_pubsub_subscription#name DataGooglePubsubSubscription#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_pubsub_subscription#project DataGooglePubsubSubscription#project}
    */
    readonly project?: string;
}
export interface DataGooglePubsubSubscriptionBigqueryConfig {
}
export declare function dataGooglePubsubSubscriptionBigqueryConfigToTerraform(struct?: DataGooglePubsubSubscriptionBigqueryConfig): any;
export declare function dataGooglePubsubSubscriptionBigqueryConfigToHclTerraform(struct?: DataGooglePubsubSubscriptionBigqueryConfig): any;
export declare class DataGooglePubsubSubscriptionBigqueryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePubsubSubscriptionBigqueryConfig | undefined;
    set internalValue(value: DataGooglePubsubSubscriptionBigqueryConfig | undefined);
    get dropUnknownFields(): cdktf.IResolvable;
    get table(): string;
    get useTableSchema(): cdktf.IResolvable;
    get useTopicSchema(): cdktf.IResolvable;
    get writeMetadata(): cdktf.IResolvable;
}
export declare class DataGooglePubsubSubscriptionBigqueryConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePubsubSubscriptionBigqueryConfigOutputReference;
}
export interface DataGooglePubsubSubscriptionCloudStorageConfigAvroConfig {
}
export declare function dataGooglePubsubSubscriptionCloudStorageConfigAvroConfigToTerraform(struct?: DataGooglePubsubSubscriptionCloudStorageConfigAvroConfig): any;
export declare function dataGooglePubsubSubscriptionCloudStorageConfigAvroConfigToHclTerraform(struct?: DataGooglePubsubSubscriptionCloudStorageConfigAvroConfig): any;
export declare class DataGooglePubsubSubscriptionCloudStorageConfigAvroConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePubsubSubscriptionCloudStorageConfigAvroConfig | undefined;
    set internalValue(value: DataGooglePubsubSubscriptionCloudStorageConfigAvroConfig | undefined);
    get writeMetadata(): cdktf.IResolvable;
}
export declare class DataGooglePubsubSubscriptionCloudStorageConfigAvroConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePubsubSubscriptionCloudStorageConfigAvroConfigOutputReference;
}
export interface DataGooglePubsubSubscriptionCloudStorageConfig {
}
export declare function dataGooglePubsubSubscriptionCloudStorageConfigToTerraform(struct?: DataGooglePubsubSubscriptionCloudStorageConfig): any;
export declare function dataGooglePubsubSubscriptionCloudStorageConfigToHclTerraform(struct?: DataGooglePubsubSubscriptionCloudStorageConfig): any;
export declare class DataGooglePubsubSubscriptionCloudStorageConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePubsubSubscriptionCloudStorageConfig | undefined;
    set internalValue(value: DataGooglePubsubSubscriptionCloudStorageConfig | undefined);
    private _avroConfig;
    get avroConfig(): DataGooglePubsubSubscriptionCloudStorageConfigAvroConfigList;
    get bucket(): string;
    get filenamePrefix(): string;
    get filenameSuffix(): string;
    get maxBytes(): number;
    get maxDuration(): string;
    get state(): string;
}
export declare class DataGooglePubsubSubscriptionCloudStorageConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePubsubSubscriptionCloudStorageConfigOutputReference;
}
export interface DataGooglePubsubSubscriptionDeadLetterPolicy {
}
export declare function dataGooglePubsubSubscriptionDeadLetterPolicyToTerraform(struct?: DataGooglePubsubSubscriptionDeadLetterPolicy): any;
export declare function dataGooglePubsubSubscriptionDeadLetterPolicyToHclTerraform(struct?: DataGooglePubsubSubscriptionDeadLetterPolicy): any;
export declare class DataGooglePubsubSubscriptionDeadLetterPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePubsubSubscriptionDeadLetterPolicy | undefined;
    set internalValue(value: DataGooglePubsubSubscriptionDeadLetterPolicy | undefined);
    get deadLetterTopic(): string;
    get maxDeliveryAttempts(): number;
}
export declare class DataGooglePubsubSubscriptionDeadLetterPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePubsubSubscriptionDeadLetterPolicyOutputReference;
}
export interface DataGooglePubsubSubscriptionExpirationPolicy {
}
export declare function dataGooglePubsubSubscriptionExpirationPolicyToTerraform(struct?: DataGooglePubsubSubscriptionExpirationPolicy): any;
export declare function dataGooglePubsubSubscriptionExpirationPolicyToHclTerraform(struct?: DataGooglePubsubSubscriptionExpirationPolicy): any;
export declare class DataGooglePubsubSubscriptionExpirationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePubsubSubscriptionExpirationPolicy | undefined;
    set internalValue(value: DataGooglePubsubSubscriptionExpirationPolicy | undefined);
    get ttl(): string;
}
export declare class DataGooglePubsubSubscriptionExpirationPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePubsubSubscriptionExpirationPolicyOutputReference;
}
export interface DataGooglePubsubSubscriptionPushConfigNoWrapper {
}
export declare function dataGooglePubsubSubscriptionPushConfigNoWrapperToTerraform(struct?: DataGooglePubsubSubscriptionPushConfigNoWrapper): any;
export declare function dataGooglePubsubSubscriptionPushConfigNoWrapperToHclTerraform(struct?: DataGooglePubsubSubscriptionPushConfigNoWrapper): any;
export declare class DataGooglePubsubSubscriptionPushConfigNoWrapperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePubsubSubscriptionPushConfigNoWrapper | undefined;
    set internalValue(value: DataGooglePubsubSubscriptionPushConfigNoWrapper | undefined);
    get writeMetadata(): cdktf.IResolvable;
}
export declare class DataGooglePubsubSubscriptionPushConfigNoWrapperList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePubsubSubscriptionPushConfigNoWrapperOutputReference;
}
export interface DataGooglePubsubSubscriptionPushConfigOidcToken {
}
export declare function dataGooglePubsubSubscriptionPushConfigOidcTokenToTerraform(struct?: DataGooglePubsubSubscriptionPushConfigOidcToken): any;
export declare function dataGooglePubsubSubscriptionPushConfigOidcTokenToHclTerraform(struct?: DataGooglePubsubSubscriptionPushConfigOidcToken): any;
export declare class DataGooglePubsubSubscriptionPushConfigOidcTokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePubsubSubscriptionPushConfigOidcToken | undefined;
    set internalValue(value: DataGooglePubsubSubscriptionPushConfigOidcToken | undefined);
    get audience(): string;
    get serviceAccountEmail(): string;
}
export declare class DataGooglePubsubSubscriptionPushConfigOidcTokenList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePubsubSubscriptionPushConfigOidcTokenOutputReference;
}
export interface DataGooglePubsubSubscriptionPushConfig {
}
export declare function dataGooglePubsubSubscriptionPushConfigToTerraform(struct?: DataGooglePubsubSubscriptionPushConfig): any;
export declare function dataGooglePubsubSubscriptionPushConfigToHclTerraform(struct?: DataGooglePubsubSubscriptionPushConfig): any;
export declare class DataGooglePubsubSubscriptionPushConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePubsubSubscriptionPushConfig | undefined;
    set internalValue(value: DataGooglePubsubSubscriptionPushConfig | undefined);
    private _attributes;
    get attributes(): cdktf.StringMap;
    private _noWrapper;
    get noWrapper(): DataGooglePubsubSubscriptionPushConfigNoWrapperList;
    private _oidcToken;
    get oidcToken(): DataGooglePubsubSubscriptionPushConfigOidcTokenList;
    get pushEndpoint(): string;
}
export declare class DataGooglePubsubSubscriptionPushConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePubsubSubscriptionPushConfigOutputReference;
}
export interface DataGooglePubsubSubscriptionRetryPolicy {
}
export declare function dataGooglePubsubSubscriptionRetryPolicyToTerraform(struct?: DataGooglePubsubSubscriptionRetryPolicy): any;
export declare function dataGooglePubsubSubscriptionRetryPolicyToHclTerraform(struct?: DataGooglePubsubSubscriptionRetryPolicy): any;
export declare class DataGooglePubsubSubscriptionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePubsubSubscriptionRetryPolicy | undefined;
    set internalValue(value: DataGooglePubsubSubscriptionRetryPolicy | undefined);
    get maximumBackoff(): string;
    get minimumBackoff(): string;
}
export declare class DataGooglePubsubSubscriptionRetryPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePubsubSubscriptionRetryPolicyOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_pubsub_subscription google_pubsub_subscription}
*/
export declare class DataGooglePubsubSubscription extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_pubsub_subscription";
    /**
    * Generates CDKTF code for importing a DataGooglePubsubSubscription resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGooglePubsubSubscription to import
    * @param importFromId The id of the existing DataGooglePubsubSubscription that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_pubsub_subscription#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGooglePubsubSubscription to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_pubsub_subscription google_pubsub_subscription} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGooglePubsubSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: DataGooglePubsubSubscriptionConfig);
    get ackDeadlineSeconds(): number;
    private _bigqueryConfig;
    get bigqueryConfig(): DataGooglePubsubSubscriptionBigqueryConfigList;
    private _cloudStorageConfig;
    get cloudStorageConfig(): DataGooglePubsubSubscriptionCloudStorageConfigList;
    private _deadLetterPolicy;
    get deadLetterPolicy(): DataGooglePubsubSubscriptionDeadLetterPolicyList;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get enableExactlyOnceDelivery(): cdktf.IResolvable;
    get enableMessageOrdering(): cdktf.IResolvable;
    private _expirationPolicy;
    get expirationPolicy(): DataGooglePubsubSubscriptionExpirationPolicyList;
    get filter(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): cdktf.StringMap;
    get messageRetentionDuration(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _pushConfig;
    get pushConfig(): DataGooglePubsubSubscriptionPushConfigList;
    get retainAckedMessages(): cdktf.IResolvable;
    private _retryPolicy;
    get retryPolicy(): DataGooglePubsubSubscriptionRetryPolicyList;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get topic(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
