/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSecretManagerSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_secret_manager_secret#id DataGoogleSecretManagerSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_secret_manager_secret#project DataGoogleSecretManagerSecret#project}
    */
    readonly project?: string;
    /**
    * This must be unique within the project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_secret_manager_secret#secret_id DataGoogleSecretManagerSecret#secret_id}
    */
    readonly secretId: string;
}
export interface DataGoogleSecretManagerSecretReplicationAutoCustomerManagedEncryption {
}
export declare function dataGoogleSecretManagerSecretReplicationAutoCustomerManagedEncryptionToTerraform(struct?: DataGoogleSecretManagerSecretReplicationAutoCustomerManagedEncryption): any;
export declare function dataGoogleSecretManagerSecretReplicationAutoCustomerManagedEncryptionToHclTerraform(struct?: DataGoogleSecretManagerSecretReplicationAutoCustomerManagedEncryption): any;
export declare class DataGoogleSecretManagerSecretReplicationAutoCustomerManagedEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretReplicationAutoCustomerManagedEncryption | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretReplicationAutoCustomerManagedEncryption | undefined);
    get kmsKeyName(): string;
}
export declare class DataGoogleSecretManagerSecretReplicationAutoCustomerManagedEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretReplicationAutoCustomerManagedEncryptionOutputReference;
}
export interface DataGoogleSecretManagerSecretReplicationAuto {
}
export declare function dataGoogleSecretManagerSecretReplicationAutoToTerraform(struct?: DataGoogleSecretManagerSecretReplicationAuto): any;
export declare function dataGoogleSecretManagerSecretReplicationAutoToHclTerraform(struct?: DataGoogleSecretManagerSecretReplicationAuto): any;
export declare class DataGoogleSecretManagerSecretReplicationAutoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretReplicationAuto | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretReplicationAuto | undefined);
    private _customerManagedEncryption;
    get customerManagedEncryption(): DataGoogleSecretManagerSecretReplicationAutoCustomerManagedEncryptionList;
}
export declare class DataGoogleSecretManagerSecretReplicationAutoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretReplicationAutoOutputReference;
}
export interface DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption {
}
export declare function dataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionToTerraform(struct?: DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption): any;
export declare function dataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionToHclTerraform(struct?: DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption): any;
export declare class DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption | undefined);
    get kmsKeyName(): string;
}
export declare class DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionOutputReference;
}
export interface DataGoogleSecretManagerSecretReplicationUserManagedReplicas {
}
export declare function dataGoogleSecretManagerSecretReplicationUserManagedReplicasToTerraform(struct?: DataGoogleSecretManagerSecretReplicationUserManagedReplicas): any;
export declare function dataGoogleSecretManagerSecretReplicationUserManagedReplicasToHclTerraform(struct?: DataGoogleSecretManagerSecretReplicationUserManagedReplicas): any;
export declare class DataGoogleSecretManagerSecretReplicationUserManagedReplicasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretReplicationUserManagedReplicas | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretReplicationUserManagedReplicas | undefined);
    private _customerManagedEncryption;
    get customerManagedEncryption(): DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionList;
    get location(): string;
}
export declare class DataGoogleSecretManagerSecretReplicationUserManagedReplicasList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretReplicationUserManagedReplicasOutputReference;
}
export interface DataGoogleSecretManagerSecretReplicationUserManaged {
}
export declare function dataGoogleSecretManagerSecretReplicationUserManagedToTerraform(struct?: DataGoogleSecretManagerSecretReplicationUserManaged): any;
export declare function dataGoogleSecretManagerSecretReplicationUserManagedToHclTerraform(struct?: DataGoogleSecretManagerSecretReplicationUserManaged): any;
export declare class DataGoogleSecretManagerSecretReplicationUserManagedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretReplicationUserManaged | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretReplicationUserManaged | undefined);
    private _replicas;
    get replicas(): DataGoogleSecretManagerSecretReplicationUserManagedReplicasList;
}
export declare class DataGoogleSecretManagerSecretReplicationUserManagedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretReplicationUserManagedOutputReference;
}
export interface DataGoogleSecretManagerSecretReplication {
}
export declare function dataGoogleSecretManagerSecretReplicationToTerraform(struct?: DataGoogleSecretManagerSecretReplication): any;
export declare function dataGoogleSecretManagerSecretReplicationToHclTerraform(struct?: DataGoogleSecretManagerSecretReplication): any;
export declare class DataGoogleSecretManagerSecretReplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretReplication | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretReplication | undefined);
    private _auto;
    get auto(): DataGoogleSecretManagerSecretReplicationAutoList;
    private _userManaged;
    get userManaged(): DataGoogleSecretManagerSecretReplicationUserManagedList;
}
export declare class DataGoogleSecretManagerSecretReplicationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretReplicationOutputReference;
}
export interface DataGoogleSecretManagerSecretRotation {
}
export declare function dataGoogleSecretManagerSecretRotationToTerraform(struct?: DataGoogleSecretManagerSecretRotation): any;
export declare function dataGoogleSecretManagerSecretRotationToHclTerraform(struct?: DataGoogleSecretManagerSecretRotation): any;
export declare class DataGoogleSecretManagerSecretRotationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretRotation | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretRotation | undefined);
    get nextRotationTime(): string;
    get rotationPeriod(): string;
}
export declare class DataGoogleSecretManagerSecretRotationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretRotationOutputReference;
}
export interface DataGoogleSecretManagerSecretTopics {
}
export declare function dataGoogleSecretManagerSecretTopicsToTerraform(struct?: DataGoogleSecretManagerSecretTopics): any;
export declare function dataGoogleSecretManagerSecretTopicsToHclTerraform(struct?: DataGoogleSecretManagerSecretTopics): any;
export declare class DataGoogleSecretManagerSecretTopicsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretTopics | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretTopics | undefined);
    get name(): string;
}
export declare class DataGoogleSecretManagerSecretTopicsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretTopicsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_secret_manager_secret google_secret_manager_secret}
*/
export declare class DataGoogleSecretManagerSecret extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_secret_manager_secret";
    /**
    * Generates CDKTF code for importing a DataGoogleSecretManagerSecret resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleSecretManagerSecret to import
    * @param importFromId The id of the existing DataGoogleSecretManagerSecret that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_secret_manager_secret#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleSecretManagerSecret to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_secret_manager_secret google_secret_manager_secret} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleSecretManagerSecretConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleSecretManagerSecretConfig);
    private _annotations;
    get annotations(): cdktf.StringMap;
    get createTime(): string;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get expireTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): cdktf.StringMap;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _replication;
    get replication(): DataGoogleSecretManagerSecretReplicationList;
    private _rotation;
    get rotation(): DataGoogleSecretManagerSecretRotationList;
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    get secretIdInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _topics;
    get topics(): DataGoogleSecretManagerSecretTopicsList;
    get ttl(): string;
    private _versionAliases;
    get versionAliases(): cdktf.StringMap;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
