/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSecretManagerSecretsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Filter string, adhering to the rules in List-operation filtering (https://cloud.google.com/secret-manager/docs/filtering).
    * List only secrets matching the filter. If filter is empty, all secrets are listed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_secret_manager_secrets#filter DataGoogleSecretManagerSecrets#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_secret_manager_secrets#id DataGoogleSecretManagerSecrets#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_secret_manager_secrets#project DataGoogleSecretManagerSecrets#project}
    */
    readonly project?: string;
}
export interface DataGoogleSecretManagerSecretsSecretsReplicationAutoCustomerManagedEncryption {
}
export declare function dataGoogleSecretManagerSecretsSecretsReplicationAutoCustomerManagedEncryptionToTerraform(struct?: DataGoogleSecretManagerSecretsSecretsReplicationAutoCustomerManagedEncryption): any;
export declare function dataGoogleSecretManagerSecretsSecretsReplicationAutoCustomerManagedEncryptionToHclTerraform(struct?: DataGoogleSecretManagerSecretsSecretsReplicationAutoCustomerManagedEncryption): any;
export declare class DataGoogleSecretManagerSecretsSecretsReplicationAutoCustomerManagedEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretsSecretsReplicationAutoCustomerManagedEncryption | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretsSecretsReplicationAutoCustomerManagedEncryption | undefined);
    get kmsKeyName(): string;
}
export declare class DataGoogleSecretManagerSecretsSecretsReplicationAutoCustomerManagedEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretsSecretsReplicationAutoCustomerManagedEncryptionOutputReference;
}
export interface DataGoogleSecretManagerSecretsSecretsReplicationAuto {
}
export declare function dataGoogleSecretManagerSecretsSecretsReplicationAutoToTerraform(struct?: DataGoogleSecretManagerSecretsSecretsReplicationAuto): any;
export declare function dataGoogleSecretManagerSecretsSecretsReplicationAutoToHclTerraform(struct?: DataGoogleSecretManagerSecretsSecretsReplicationAuto): any;
export declare class DataGoogleSecretManagerSecretsSecretsReplicationAutoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretsSecretsReplicationAuto | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretsSecretsReplicationAuto | undefined);
    private _customerManagedEncryption;
    get customerManagedEncryption(): DataGoogleSecretManagerSecretsSecretsReplicationAutoCustomerManagedEncryptionList;
}
export declare class DataGoogleSecretManagerSecretsSecretsReplicationAutoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretsSecretsReplicationAutoOutputReference;
}
export interface DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasCustomerManagedEncryption {
}
export declare function dataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasCustomerManagedEncryptionToTerraform(struct?: DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasCustomerManagedEncryption): any;
export declare function dataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasCustomerManagedEncryptionToHclTerraform(struct?: DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasCustomerManagedEncryption): any;
export declare class DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasCustomerManagedEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasCustomerManagedEncryption | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasCustomerManagedEncryption | undefined);
    get kmsKeyName(): string;
}
export declare class DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasCustomerManagedEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasCustomerManagedEncryptionOutputReference;
}
export interface DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicas {
}
export declare function dataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasToTerraform(struct?: DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicas): any;
export declare function dataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasToHclTerraform(struct?: DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicas): any;
export declare class DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicas | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicas | undefined);
    private _customerManagedEncryption;
    get customerManagedEncryption(): DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasCustomerManagedEncryptionList;
    get location(): string;
}
export declare class DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasOutputReference;
}
export interface DataGoogleSecretManagerSecretsSecretsReplicationUserManaged {
}
export declare function dataGoogleSecretManagerSecretsSecretsReplicationUserManagedToTerraform(struct?: DataGoogleSecretManagerSecretsSecretsReplicationUserManaged): any;
export declare function dataGoogleSecretManagerSecretsSecretsReplicationUserManagedToHclTerraform(struct?: DataGoogleSecretManagerSecretsSecretsReplicationUserManaged): any;
export declare class DataGoogleSecretManagerSecretsSecretsReplicationUserManagedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretsSecretsReplicationUserManaged | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretsSecretsReplicationUserManaged | undefined);
    private _replicas;
    get replicas(): DataGoogleSecretManagerSecretsSecretsReplicationUserManagedReplicasList;
}
export declare class DataGoogleSecretManagerSecretsSecretsReplicationUserManagedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretsSecretsReplicationUserManagedOutputReference;
}
export interface DataGoogleSecretManagerSecretsSecretsReplication {
}
export declare function dataGoogleSecretManagerSecretsSecretsReplicationToTerraform(struct?: DataGoogleSecretManagerSecretsSecretsReplication): any;
export declare function dataGoogleSecretManagerSecretsSecretsReplicationToHclTerraform(struct?: DataGoogleSecretManagerSecretsSecretsReplication): any;
export declare class DataGoogleSecretManagerSecretsSecretsReplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretsSecretsReplication | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretsSecretsReplication | undefined);
    private _auto;
    get auto(): DataGoogleSecretManagerSecretsSecretsReplicationAutoList;
    private _userManaged;
    get userManaged(): DataGoogleSecretManagerSecretsSecretsReplicationUserManagedList;
}
export declare class DataGoogleSecretManagerSecretsSecretsReplicationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretsSecretsReplicationOutputReference;
}
export interface DataGoogleSecretManagerSecretsSecretsRotation {
}
export declare function dataGoogleSecretManagerSecretsSecretsRotationToTerraform(struct?: DataGoogleSecretManagerSecretsSecretsRotation): any;
export declare function dataGoogleSecretManagerSecretsSecretsRotationToHclTerraform(struct?: DataGoogleSecretManagerSecretsSecretsRotation): any;
export declare class DataGoogleSecretManagerSecretsSecretsRotationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretsSecretsRotation | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretsSecretsRotation | undefined);
    get nextRotationTime(): string;
    get rotationPeriod(): string;
}
export declare class DataGoogleSecretManagerSecretsSecretsRotationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretsSecretsRotationOutputReference;
}
export interface DataGoogleSecretManagerSecretsSecretsTopics {
}
export declare function dataGoogleSecretManagerSecretsSecretsTopicsToTerraform(struct?: DataGoogleSecretManagerSecretsSecretsTopics): any;
export declare function dataGoogleSecretManagerSecretsSecretsTopicsToHclTerraform(struct?: DataGoogleSecretManagerSecretsSecretsTopics): any;
export declare class DataGoogleSecretManagerSecretsSecretsTopicsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretsSecretsTopics | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretsSecretsTopics | undefined);
    get name(): string;
}
export declare class DataGoogleSecretManagerSecretsSecretsTopicsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretsSecretsTopicsOutputReference;
}
export interface DataGoogleSecretManagerSecretsSecrets {
}
export declare function dataGoogleSecretManagerSecretsSecretsToTerraform(struct?: DataGoogleSecretManagerSecretsSecrets): any;
export declare function dataGoogleSecretManagerSecretsSecretsToHclTerraform(struct?: DataGoogleSecretManagerSecretsSecrets): any;
export declare class DataGoogleSecretManagerSecretsSecretsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretsSecrets | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretsSecrets | undefined);
    private _annotations;
    get annotations(): cdktf.StringMap;
    get createTime(): string;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get expireTime(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get name(): string;
    get project(): string;
    private _replication;
    get replication(): DataGoogleSecretManagerSecretsSecretsReplicationList;
    private _rotation;
    get rotation(): DataGoogleSecretManagerSecretsSecretsRotationList;
    get secretId(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _topics;
    get topics(): DataGoogleSecretManagerSecretsSecretsTopicsList;
    get ttl(): string;
    private _versionAliases;
    get versionAliases(): cdktf.StringMap;
}
export declare class DataGoogleSecretManagerSecretsSecretsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretsSecretsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_secret_manager_secrets google_secret_manager_secrets}
*/
export declare class DataGoogleSecretManagerSecrets extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_secret_manager_secrets";
    /**
    * Generates CDKTF code for importing a DataGoogleSecretManagerSecrets resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleSecretManagerSecrets to import
    * @param importFromId The id of the existing DataGoogleSecretManagerSecrets that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_secret_manager_secrets#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleSecretManagerSecrets to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_secret_manager_secrets google_secret_manager_secrets} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleSecretManagerSecretsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleSecretManagerSecretsConfig);
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _secrets;
    get secrets(): DataGoogleSecretManagerSecretsSecretsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
