/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleServiceAccountIdTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_service_account_id_token#delegates DataGoogleServiceAccountIdToken#delegates}
    */
    readonly delegates?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_service_account_id_token#id DataGoogleServiceAccountIdToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_service_account_id_token#include_email DataGoogleServiceAccountIdToken#include_email}
    */
    readonly includeEmail?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_service_account_id_token#target_audience DataGoogleServiceAccountIdToken#target_audience}
    */
    readonly targetAudience: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_service_account_id_token#target_service_account DataGoogleServiceAccountIdToken#target_service_account}
    */
    readonly targetServiceAccount?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_service_account_id_token google_service_account_id_token}
*/
export declare class DataGoogleServiceAccountIdToken extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_service_account_id_token";
    /**
    * Generates CDKTF code for importing a DataGoogleServiceAccountIdToken resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleServiceAccountIdToken to import
    * @param importFromId The id of the existing DataGoogleServiceAccountIdToken that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_service_account_id_token#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleServiceAccountIdToken to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_service_account_id_token google_service_account_id_token} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleServiceAccountIdTokenConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleServiceAccountIdTokenConfig);
    private _delegates?;
    get delegates(): string[];
    set delegates(value: string[]);
    resetDelegates(): void;
    get delegatesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get idToken(): string;
    private _includeEmail?;
    get includeEmail(): boolean | cdktf.IResolvable;
    set includeEmail(value: boolean | cdktf.IResolvable);
    resetIncludeEmail(): void;
    get includeEmailInput(): boolean | cdktf.IResolvable | undefined;
    private _targetAudience?;
    get targetAudience(): string;
    set targetAudience(value: string);
    get targetAudienceInput(): string | undefined;
    private _targetServiceAccount?;
    get targetServiceAccount(): string;
    set targetServiceAccount(value: string);
    resetTargetServiceAccount(): void;
    get targetServiceAccountInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
