/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSourcerepoRepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sourcerepo_repository#id DataGoogleSourcerepoRepository#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource name of the repository, of the form '{{repo}}'.
    * The repo name may contain slashes. eg, 'name/with/slash'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sourcerepo_repository#name DataGoogleSourcerepoRepository#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sourcerepo_repository#project DataGoogleSourcerepoRepository#project}
    */
    readonly project?: string;
}
export interface DataGoogleSourcerepoRepositoryPubsubConfigs {
}
export declare function dataGoogleSourcerepoRepositoryPubsubConfigsToTerraform(struct?: DataGoogleSourcerepoRepositoryPubsubConfigs): any;
export declare function dataGoogleSourcerepoRepositoryPubsubConfigsToHclTerraform(struct?: DataGoogleSourcerepoRepositoryPubsubConfigs): any;
export declare class DataGoogleSourcerepoRepositoryPubsubConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSourcerepoRepositoryPubsubConfigs | undefined;
    set internalValue(value: DataGoogleSourcerepoRepositoryPubsubConfigs | undefined);
    get messageFormat(): string;
    get serviceAccountEmail(): string;
    get topic(): string;
}
export declare class DataGoogleSourcerepoRepositoryPubsubConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSourcerepoRepositoryPubsubConfigsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sourcerepo_repository google_sourcerepo_repository}
*/
export declare class DataGoogleSourcerepoRepository extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_sourcerepo_repository";
    /**
    * Generates CDKTF code for importing a DataGoogleSourcerepoRepository resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleSourcerepoRepository to import
    * @param importFromId The id of the existing DataGoogleSourcerepoRepository that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sourcerepo_repository#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleSourcerepoRepository to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sourcerepo_repository google_sourcerepo_repository} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleSourcerepoRepositoryConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleSourcerepoRepositoryConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _pubsubConfigs;
    get pubsubConfigs(): DataGoogleSourcerepoRepositoryPubsubConfigsList;
    get size(): number;
    get url(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
