/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSpannerInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the instance's configuration (similar but not
    * quite the same as a region) which defines the geographic placement and
    * replication of your databases in this instance. It determines where your data
    * is stored. Values are typically of the form 'regional-europe-west1' , 'us-central' etc.
    * In order to obtain a valid list please consult the
    * [Configuration section of the docs](https://cloud.google.com/spanner/docs/instances).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_spanner_instance#config DataGoogleSpannerInstance#config}
    */
    readonly config?: string;
    /**
    * The descriptive name for this instance as it appears in UIs. Must be
    * unique per project and between 4 and 30 characters in length.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_spanner_instance#display_name DataGoogleSpannerInstance#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_spanner_instance#id DataGoogleSpannerInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A unique identifier for the instance, which cannot be changed after
    * the instance is created. The name must be between 6 and 30 characters
    * in length.
    *
    *
    * If not provided, a random string starting with 'tf-' will be selected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_spanner_instance#name DataGoogleSpannerInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_spanner_instance#project DataGoogleSpannerInstance#project}
    */
    readonly project?: string;
}
export interface DataGoogleSpannerInstanceAutoscalingConfigAutoscalingLimits {
}
export declare function dataGoogleSpannerInstanceAutoscalingConfigAutoscalingLimitsToTerraform(struct?: DataGoogleSpannerInstanceAutoscalingConfigAutoscalingLimits): any;
export declare function dataGoogleSpannerInstanceAutoscalingConfigAutoscalingLimitsToHclTerraform(struct?: DataGoogleSpannerInstanceAutoscalingConfigAutoscalingLimits): any;
export declare class DataGoogleSpannerInstanceAutoscalingConfigAutoscalingLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSpannerInstanceAutoscalingConfigAutoscalingLimits | undefined;
    set internalValue(value: DataGoogleSpannerInstanceAutoscalingConfigAutoscalingLimits | undefined);
    get maxNodes(): number;
    get maxProcessingUnits(): number;
    get minNodes(): number;
    get minProcessingUnits(): number;
}
export declare class DataGoogleSpannerInstanceAutoscalingConfigAutoscalingLimitsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSpannerInstanceAutoscalingConfigAutoscalingLimitsOutputReference;
}
export interface DataGoogleSpannerInstanceAutoscalingConfigAutoscalingTargets {
}
export declare function dataGoogleSpannerInstanceAutoscalingConfigAutoscalingTargetsToTerraform(struct?: DataGoogleSpannerInstanceAutoscalingConfigAutoscalingTargets): any;
export declare function dataGoogleSpannerInstanceAutoscalingConfigAutoscalingTargetsToHclTerraform(struct?: DataGoogleSpannerInstanceAutoscalingConfigAutoscalingTargets): any;
export declare class DataGoogleSpannerInstanceAutoscalingConfigAutoscalingTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSpannerInstanceAutoscalingConfigAutoscalingTargets | undefined;
    set internalValue(value: DataGoogleSpannerInstanceAutoscalingConfigAutoscalingTargets | undefined);
    get highPriorityCpuUtilizationPercent(): number;
    get storageUtilizationPercent(): number;
}
export declare class DataGoogleSpannerInstanceAutoscalingConfigAutoscalingTargetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSpannerInstanceAutoscalingConfigAutoscalingTargetsOutputReference;
}
export interface DataGoogleSpannerInstanceAutoscalingConfig {
}
export declare function dataGoogleSpannerInstanceAutoscalingConfigToTerraform(struct?: DataGoogleSpannerInstanceAutoscalingConfig): any;
export declare function dataGoogleSpannerInstanceAutoscalingConfigToHclTerraform(struct?: DataGoogleSpannerInstanceAutoscalingConfig): any;
export declare class DataGoogleSpannerInstanceAutoscalingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSpannerInstanceAutoscalingConfig | undefined;
    set internalValue(value: DataGoogleSpannerInstanceAutoscalingConfig | undefined);
    private _autoscalingLimits;
    get autoscalingLimits(): DataGoogleSpannerInstanceAutoscalingConfigAutoscalingLimitsList;
    private _autoscalingTargets;
    get autoscalingTargets(): DataGoogleSpannerInstanceAutoscalingConfigAutoscalingTargetsList;
}
export declare class DataGoogleSpannerInstanceAutoscalingConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSpannerInstanceAutoscalingConfigOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_spanner_instance google_spanner_instance}
*/
export declare class DataGoogleSpannerInstance extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_spanner_instance";
    /**
    * Generates CDKTF code for importing a DataGoogleSpannerInstance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleSpannerInstance to import
    * @param importFromId The id of the existing DataGoogleSpannerInstance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_spanner_instance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleSpannerInstance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_spanner_instance google_spanner_instance} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleSpannerInstanceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleSpannerInstanceConfig);
    private _autoscalingConfig;
    get autoscalingConfig(): DataGoogleSpannerInstanceAutoscalingConfigList;
    private _config?;
    get config(): string;
    set config(value: string);
    resetConfig(): void;
    get configInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get forceDestroy(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): cdktf.StringMap;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get numNodes(): number;
    get processingUnits(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
