/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSqlDatabaseInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sql_database_instance#id DataGoogleSqlDatabaseInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the instance. If the name is left blank, Terraform will randomly generate one when the instance is first created. This is done because after a name is used, it cannot be reused for up to one week.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sql_database_instance#name DataGoogleSqlDatabaseInstance#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sql_database_instance#project DataGoogleSqlDatabaseInstance#project}
    */
    readonly project?: string;
}
export interface DataGoogleSqlDatabaseInstanceClone {
}
export declare function dataGoogleSqlDatabaseInstanceCloneToTerraform(struct?: DataGoogleSqlDatabaseInstanceClone): any;
export declare function dataGoogleSqlDatabaseInstanceCloneToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceClone): any;
export declare class DataGoogleSqlDatabaseInstanceCloneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceClone | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceClone | undefined);
    get allocatedIpRange(): string;
    get databaseNames(): string[];
    get pointInTime(): string;
    get preferredZone(): string;
    get sourceInstanceName(): string;
}
export declare class DataGoogleSqlDatabaseInstanceCloneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceCloneOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceIpAddress {
}
export declare function dataGoogleSqlDatabaseInstanceIpAddressToTerraform(struct?: DataGoogleSqlDatabaseInstanceIpAddress): any;
export declare function dataGoogleSqlDatabaseInstanceIpAddressToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceIpAddress): any;
export declare class DataGoogleSqlDatabaseInstanceIpAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceIpAddress | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceIpAddress | undefined);
    get ipAddress(): string;
    get timeToRetire(): string;
    get type(): string;
}
export declare class DataGoogleSqlDatabaseInstanceIpAddressList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceIpAddressOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceReplicaConfiguration {
}
export declare function dataGoogleSqlDatabaseInstanceReplicaConfigurationToTerraform(struct?: DataGoogleSqlDatabaseInstanceReplicaConfiguration): any;
export declare function dataGoogleSqlDatabaseInstanceReplicaConfigurationToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceReplicaConfiguration): any;
export declare class DataGoogleSqlDatabaseInstanceReplicaConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceReplicaConfiguration | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceReplicaConfiguration | undefined);
    get caCertificate(): string;
    get clientCertificate(): string;
    get clientKey(): string;
    get connectRetryInterval(): number;
    get dumpFilePath(): string;
    get failoverTarget(): cdktf.IResolvable;
    get masterHeartbeatPeriod(): number;
    get password(): string;
    get sslCipher(): string;
    get username(): string;
    get verifyServerCertificate(): cdktf.IResolvable;
}
export declare class DataGoogleSqlDatabaseInstanceReplicaConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceReplicaConfigurationOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceRestoreBackupContext {
}
export declare function dataGoogleSqlDatabaseInstanceRestoreBackupContextToTerraform(struct?: DataGoogleSqlDatabaseInstanceRestoreBackupContext): any;
export declare function dataGoogleSqlDatabaseInstanceRestoreBackupContextToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceRestoreBackupContext): any;
export declare class DataGoogleSqlDatabaseInstanceRestoreBackupContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceRestoreBackupContext | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceRestoreBackupContext | undefined);
    get backupRunId(): number;
    get instanceId(): string;
    get project(): string;
}
export declare class DataGoogleSqlDatabaseInstanceRestoreBackupContextList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceRestoreBackupContextOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceServerCaCert {
}
export declare function dataGoogleSqlDatabaseInstanceServerCaCertToTerraform(struct?: DataGoogleSqlDatabaseInstanceServerCaCert): any;
export declare function dataGoogleSqlDatabaseInstanceServerCaCertToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceServerCaCert): any;
export declare class DataGoogleSqlDatabaseInstanceServerCaCertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceServerCaCert | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceServerCaCert | undefined);
    get cert(): string;
    get commonName(): string;
    get createTime(): string;
    get expirationTime(): string;
    get sha1Fingerprint(): string;
}
export declare class DataGoogleSqlDatabaseInstanceServerCaCertList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceServerCaCertOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceSettingsActiveDirectoryConfig {
}
export declare function dataGoogleSqlDatabaseInstanceSettingsActiveDirectoryConfigToTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsActiveDirectoryConfig): any;
export declare function dataGoogleSqlDatabaseInstanceSettingsActiveDirectoryConfigToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsActiveDirectoryConfig): any;
export declare class DataGoogleSqlDatabaseInstanceSettingsActiveDirectoryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceSettingsActiveDirectoryConfig | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceSettingsActiveDirectoryConfig | undefined);
    get domain(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsActiveDirectoryConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceSettingsActiveDirectoryConfigOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceSettingsAdvancedMachineFeatures {
}
export declare function dataGoogleSqlDatabaseInstanceSettingsAdvancedMachineFeaturesToTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsAdvancedMachineFeatures): any;
export declare function dataGoogleSqlDatabaseInstanceSettingsAdvancedMachineFeaturesToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsAdvancedMachineFeatures): any;
export declare class DataGoogleSqlDatabaseInstanceSettingsAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceSettingsAdvancedMachineFeatures | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceSettingsAdvancedMachineFeatures | undefined);
    get threadsPerCore(): number;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsAdvancedMachineFeaturesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceSettingsAdvancedMachineFeaturesOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings {
}
export declare function dataGoogleSqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsToTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings): any;
export declare function dataGoogleSqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings): any;
export declare class DataGoogleSqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings | undefined);
    get retainedBackups(): number;
    get retentionUnit(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceSettingsBackupConfiguration {
}
export declare function dataGoogleSqlDatabaseInstanceSettingsBackupConfigurationToTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsBackupConfiguration): any;
export declare function dataGoogleSqlDatabaseInstanceSettingsBackupConfigurationToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsBackupConfiguration): any;
export declare class DataGoogleSqlDatabaseInstanceSettingsBackupConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceSettingsBackupConfiguration | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceSettingsBackupConfiguration | undefined);
    private _backupRetentionSettings;
    get backupRetentionSettings(): DataGoogleSqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsList;
    get binaryLogEnabled(): cdktf.IResolvable;
    get enabled(): cdktf.IResolvable;
    get location(): string;
    get pointInTimeRecoveryEnabled(): cdktf.IResolvable;
    get startTime(): string;
    get transactionLogRetentionDays(): number;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsBackupConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceSettingsBackupConfigurationOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceSettingsDataCacheConfig {
}
export declare function dataGoogleSqlDatabaseInstanceSettingsDataCacheConfigToTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsDataCacheConfig): any;
export declare function dataGoogleSqlDatabaseInstanceSettingsDataCacheConfigToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsDataCacheConfig): any;
export declare class DataGoogleSqlDatabaseInstanceSettingsDataCacheConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceSettingsDataCacheConfig | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceSettingsDataCacheConfig | undefined);
    get dataCacheEnabled(): cdktf.IResolvable;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsDataCacheConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceSettingsDataCacheConfigOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceSettingsDatabaseFlags {
}
export declare function dataGoogleSqlDatabaseInstanceSettingsDatabaseFlagsToTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsDatabaseFlags): any;
export declare function dataGoogleSqlDatabaseInstanceSettingsDatabaseFlagsToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsDatabaseFlags): any;
export declare class DataGoogleSqlDatabaseInstanceSettingsDatabaseFlagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceSettingsDatabaseFlags | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceSettingsDatabaseFlags | undefined);
    get name(): string;
    get value(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsDatabaseFlagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceSettingsDatabaseFlagsOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceSettingsDenyMaintenancePeriod {
}
export declare function dataGoogleSqlDatabaseInstanceSettingsDenyMaintenancePeriodToTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsDenyMaintenancePeriod): any;
export declare function dataGoogleSqlDatabaseInstanceSettingsDenyMaintenancePeriodToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsDenyMaintenancePeriod): any;
export declare class DataGoogleSqlDatabaseInstanceSettingsDenyMaintenancePeriodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceSettingsDenyMaintenancePeriod | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceSettingsDenyMaintenancePeriod | undefined);
    get endDate(): string;
    get startDate(): string;
    get time(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsDenyMaintenancePeriodList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceSettingsDenyMaintenancePeriodOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceSettingsInsightsConfig {
}
export declare function dataGoogleSqlDatabaseInstanceSettingsInsightsConfigToTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsInsightsConfig): any;
export declare function dataGoogleSqlDatabaseInstanceSettingsInsightsConfigToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsInsightsConfig): any;
export declare class DataGoogleSqlDatabaseInstanceSettingsInsightsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceSettingsInsightsConfig | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceSettingsInsightsConfig | undefined);
    get queryInsightsEnabled(): cdktf.IResolvable;
    get queryPlansPerMinute(): number;
    get queryStringLength(): number;
    get recordApplicationTags(): cdktf.IResolvable;
    get recordClientAddress(): cdktf.IResolvable;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsInsightsConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceSettingsInsightsConfigOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks {
}
export declare function dataGoogleSqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworksToTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks): any;
export declare function dataGoogleSqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworksToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks): any;
export declare class DataGoogleSqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks | undefined);
    get expirationTime(): string;
    get name(): string;
    get value(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworksOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceSettingsIpConfigurationPscConfig {
}
export declare function dataGoogleSqlDatabaseInstanceSettingsIpConfigurationPscConfigToTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsIpConfigurationPscConfig): any;
export declare function dataGoogleSqlDatabaseInstanceSettingsIpConfigurationPscConfigToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsIpConfigurationPscConfig): any;
export declare class DataGoogleSqlDatabaseInstanceSettingsIpConfigurationPscConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceSettingsIpConfigurationPscConfig | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceSettingsIpConfigurationPscConfig | undefined);
    get allowedConsumerProjects(): string[];
    get pscEnabled(): cdktf.IResolvable;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsIpConfigurationPscConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceSettingsIpConfigurationPscConfigOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceSettingsIpConfiguration {
}
export declare function dataGoogleSqlDatabaseInstanceSettingsIpConfigurationToTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsIpConfiguration): any;
export declare function dataGoogleSqlDatabaseInstanceSettingsIpConfigurationToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsIpConfiguration): any;
export declare class DataGoogleSqlDatabaseInstanceSettingsIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceSettingsIpConfiguration | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceSettingsIpConfiguration | undefined);
    get allocatedIpRange(): string;
    private _authorizedNetworks;
    get authorizedNetworks(): DataGoogleSqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworksList;
    get enablePrivatePathForGoogleCloudServices(): cdktf.IResolvable;
    get ipv4Enabled(): cdktf.IResolvable;
    get privateNetwork(): string;
    private _pscConfig;
    get pscConfig(): DataGoogleSqlDatabaseInstanceSettingsIpConfigurationPscConfigList;
    get requireSsl(): cdktf.IResolvable;
    get sslMode(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceSettingsIpConfigurationOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceSettingsLocationPreference {
}
export declare function dataGoogleSqlDatabaseInstanceSettingsLocationPreferenceToTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsLocationPreference): any;
export declare function dataGoogleSqlDatabaseInstanceSettingsLocationPreferenceToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsLocationPreference): any;
export declare class DataGoogleSqlDatabaseInstanceSettingsLocationPreferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceSettingsLocationPreference | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceSettingsLocationPreference | undefined);
    get followGaeApplication(): string;
    get secondaryZone(): string;
    get zone(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsLocationPreferenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceSettingsLocationPreferenceOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceSettingsMaintenanceWindow {
}
export declare function dataGoogleSqlDatabaseInstanceSettingsMaintenanceWindowToTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsMaintenanceWindow): any;
export declare function dataGoogleSqlDatabaseInstanceSettingsMaintenanceWindowToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsMaintenanceWindow): any;
export declare class DataGoogleSqlDatabaseInstanceSettingsMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceSettingsMaintenanceWindow | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceSettingsMaintenanceWindow | undefined);
    get day(): number;
    get hour(): number;
    get updateTrack(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceSettingsMaintenanceWindowOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceSettingsPasswordValidationPolicy {
}
export declare function dataGoogleSqlDatabaseInstanceSettingsPasswordValidationPolicyToTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsPasswordValidationPolicy): any;
export declare function dataGoogleSqlDatabaseInstanceSettingsPasswordValidationPolicyToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsPasswordValidationPolicy): any;
export declare class DataGoogleSqlDatabaseInstanceSettingsPasswordValidationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceSettingsPasswordValidationPolicy | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceSettingsPasswordValidationPolicy | undefined);
    get complexity(): string;
    get disallowUsernameSubstring(): cdktf.IResolvable;
    get enablePasswordPolicy(): cdktf.IResolvable;
    get minLength(): number;
    get passwordChangeInterval(): string;
    get reuseInterval(): number;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsPasswordValidationPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceSettingsPasswordValidationPolicyOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceSettingsSqlServerAuditConfig {
}
export declare function dataGoogleSqlDatabaseInstanceSettingsSqlServerAuditConfigToTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsSqlServerAuditConfig): any;
export declare function dataGoogleSqlDatabaseInstanceSettingsSqlServerAuditConfigToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceSettingsSqlServerAuditConfig): any;
export declare class DataGoogleSqlDatabaseInstanceSettingsSqlServerAuditConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceSettingsSqlServerAuditConfig | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceSettingsSqlServerAuditConfig | undefined);
    get bucket(): string;
    get retentionInterval(): string;
    get uploadInterval(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsSqlServerAuditConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceSettingsSqlServerAuditConfigOutputReference;
}
export interface DataGoogleSqlDatabaseInstanceSettings {
}
export declare function dataGoogleSqlDatabaseInstanceSettingsToTerraform(struct?: DataGoogleSqlDatabaseInstanceSettings): any;
export declare function dataGoogleSqlDatabaseInstanceSettingsToHclTerraform(struct?: DataGoogleSqlDatabaseInstanceSettings): any;
export declare class DataGoogleSqlDatabaseInstanceSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstanceSettings | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstanceSettings | undefined);
    get activationPolicy(): string;
    private _activeDirectoryConfig;
    get activeDirectoryConfig(): DataGoogleSqlDatabaseInstanceSettingsActiveDirectoryConfigList;
    private _advancedMachineFeatures;
    get advancedMachineFeatures(): DataGoogleSqlDatabaseInstanceSettingsAdvancedMachineFeaturesList;
    get availabilityType(): string;
    private _backupConfiguration;
    get backupConfiguration(): DataGoogleSqlDatabaseInstanceSettingsBackupConfigurationList;
    get collation(): string;
    get connectorEnforcement(): string;
    private _dataCacheConfig;
    get dataCacheConfig(): DataGoogleSqlDatabaseInstanceSettingsDataCacheConfigList;
    private _databaseFlags;
    get databaseFlags(): DataGoogleSqlDatabaseInstanceSettingsDatabaseFlagsList;
    get deletionProtectionEnabled(): cdktf.IResolvable;
    private _denyMaintenancePeriod;
    get denyMaintenancePeriod(): DataGoogleSqlDatabaseInstanceSettingsDenyMaintenancePeriodList;
    get diskAutoresize(): cdktf.IResolvable;
    get diskAutoresizeLimit(): number;
    get diskSize(): number;
    get diskType(): string;
    get edition(): string;
    private _insightsConfig;
    get insightsConfig(): DataGoogleSqlDatabaseInstanceSettingsInsightsConfigList;
    private _ipConfiguration;
    get ipConfiguration(): DataGoogleSqlDatabaseInstanceSettingsIpConfigurationList;
    private _locationPreference;
    get locationPreference(): DataGoogleSqlDatabaseInstanceSettingsLocationPreferenceList;
    private _maintenanceWindow;
    get maintenanceWindow(): DataGoogleSqlDatabaseInstanceSettingsMaintenanceWindowList;
    private _passwordValidationPolicy;
    get passwordValidationPolicy(): DataGoogleSqlDatabaseInstanceSettingsPasswordValidationPolicyList;
    get pricingPlan(): string;
    private _sqlServerAuditConfig;
    get sqlServerAuditConfig(): DataGoogleSqlDatabaseInstanceSettingsSqlServerAuditConfigList;
    get tier(): string;
    get timeZone(): string;
    private _userLabels;
    get userLabels(): cdktf.StringMap;
    get version(): number;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstanceSettingsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sql_database_instance google_sql_database_instance}
*/
export declare class DataGoogleSqlDatabaseInstance extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_sql_database_instance";
    /**
    * Generates CDKTF code for importing a DataGoogleSqlDatabaseInstance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleSqlDatabaseInstance to import
    * @param importFromId The id of the existing DataGoogleSqlDatabaseInstance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sql_database_instance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleSqlDatabaseInstance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sql_database_instance google_sql_database_instance} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleSqlDatabaseInstanceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleSqlDatabaseInstanceConfig);
    get availableMaintenanceVersions(): string[];
    private _clone;
    get clone(): DataGoogleSqlDatabaseInstanceCloneList;
    get connectionName(): string;
    get databaseVersion(): string;
    get deletionProtection(): cdktf.IResolvable;
    get dnsName(): string;
    get encryptionKeyName(): string;
    get firstIpAddress(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get instanceType(): string;
    private _ipAddress;
    get ipAddress(): DataGoogleSqlDatabaseInstanceIpAddressList;
    get maintenanceVersion(): string;
    get masterInstanceName(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateIpAddress(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get pscServiceAttachmentLink(): string;
    get publicIpAddress(): string;
    get region(): string;
    private _replicaConfiguration;
    get replicaConfiguration(): DataGoogleSqlDatabaseInstanceReplicaConfigurationList;
    private _restoreBackupContext;
    get restoreBackupContext(): DataGoogleSqlDatabaseInstanceRestoreBackupContextList;
    get rootPassword(): string;
    get selfLink(): string;
    private _serverCaCert;
    get serverCaCert(): DataGoogleSqlDatabaseInstanceServerCaCertList;
    get serviceAccountEmailAddress(): string;
    private _settings;
    get settings(): DataGoogleSqlDatabaseInstanceSettingsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
