/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSqlDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sql_database#id DataGoogleSqlDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Cloud SQL instance. This does not include the project
    * ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sql_database#instance DataGoogleSqlDatabase#instance}
    */
    readonly instance: string;
    /**
    * The name of the database in the Cloud SQL instance.
    * This does not include the project ID or instance name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sql_database#name DataGoogleSqlDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sql_database#project DataGoogleSqlDatabase#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sql_database google_sql_database}
*/
export declare class DataGoogleSqlDatabase extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_sql_database";
    /**
    * Generates CDKTF code for importing a DataGoogleSqlDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleSqlDatabase to import
    * @param importFromId The id of the existing DataGoogleSqlDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sql_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleSqlDatabase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_sql_database google_sql_database} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleSqlDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleSqlDatabaseConfig);
    get charset(): string;
    get collation(): string;
    get deletionPolicy(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
