/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleStorageBucketObjectContentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the containing bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_storage_bucket_object_content#bucket DataGoogleStorageBucketObjectContent#bucket}
    */
    readonly bucket: string;
    /**
    * Data as string to be uploaded. Must be defined if source is not. Note: The content field is marked as sensitive. To view the raw contents of the object, please define an output.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_storage_bucket_object_content#content DataGoogleStorageBucketObjectContent#content}
    */
    readonly content?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_storage_bucket_object_content#id DataGoogleStorageBucketObjectContent#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the object. If you're interpolating the name of this object, see output_name instead.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_storage_bucket_object_content#name DataGoogleStorageBucketObjectContent#name}
    */
    readonly name: string;
}
export interface DataGoogleStorageBucketObjectContentCustomerEncryption {
}
export declare function dataGoogleStorageBucketObjectContentCustomerEncryptionToTerraform(struct?: DataGoogleStorageBucketObjectContentCustomerEncryption): any;
export declare function dataGoogleStorageBucketObjectContentCustomerEncryptionToHclTerraform(struct?: DataGoogleStorageBucketObjectContentCustomerEncryption): any;
export declare class DataGoogleStorageBucketObjectContentCustomerEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleStorageBucketObjectContentCustomerEncryption | undefined;
    set internalValue(value: DataGoogleStorageBucketObjectContentCustomerEncryption | undefined);
    get encryptionAlgorithm(): string;
    get encryptionKey(): string;
}
export declare class DataGoogleStorageBucketObjectContentCustomerEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleStorageBucketObjectContentCustomerEncryptionOutputReference;
}
export interface DataGoogleStorageBucketObjectContentRetention {
}
export declare function dataGoogleStorageBucketObjectContentRetentionToTerraform(struct?: DataGoogleStorageBucketObjectContentRetention): any;
export declare function dataGoogleStorageBucketObjectContentRetentionToHclTerraform(struct?: DataGoogleStorageBucketObjectContentRetention): any;
export declare class DataGoogleStorageBucketObjectContentRetentionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleStorageBucketObjectContentRetention | undefined;
    set internalValue(value: DataGoogleStorageBucketObjectContentRetention | undefined);
    get mode(): string;
    get retainUntilTime(): string;
}
export declare class DataGoogleStorageBucketObjectContentRetentionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleStorageBucketObjectContentRetentionOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_storage_bucket_object_content google_storage_bucket_object_content}
*/
export declare class DataGoogleStorageBucketObjectContent extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_storage_bucket_object_content";
    /**
    * Generates CDKTF code for importing a DataGoogleStorageBucketObjectContent resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleStorageBucketObjectContent to import
    * @param importFromId The id of the existing DataGoogleStorageBucketObjectContent that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_storage_bucket_object_content#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleStorageBucketObjectContent to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_storage_bucket_object_content google_storage_bucket_object_content} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleStorageBucketObjectContentConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleStorageBucketObjectContentConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get cacheControl(): string;
    private _content?;
    get content(): string;
    set content(value: string);
    resetContent(): void;
    get contentInput(): string | undefined;
    get contentDisposition(): string;
    get contentEncoding(): string;
    get contentLanguage(): string;
    get contentType(): string;
    get crc32C(): string;
    private _customerEncryption;
    get customerEncryption(): DataGoogleStorageBucketObjectContentCustomerEncryptionList;
    get detectMd5Hash(): string;
    get eventBasedHold(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kmsKeyName(): string;
    get md5Hash(): string;
    get mediaLink(): string;
    private _metadata;
    get metadata(): cdktf.StringMap;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputName(): string;
    private _retention;
    get retention(): DataGoogleStorageBucketObjectContentRetentionList;
    get selfLink(): string;
    get source(): string;
    get storageClass(): string;
    get temporaryHold(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
