/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleTagsTagKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_tags_tag_key#parent DataGoogleTagsTagKey#parent}
    */
    readonly parent: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_tags_tag_key#short_name DataGoogleTagsTagKey#short_name}
    */
    readonly shortName: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_tags_tag_key google_tags_tag_key}
*/
export declare class DataGoogleTagsTagKey extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_tags_tag_key";
    /**
    * Generates CDKTF code for importing a DataGoogleTagsTagKey resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleTagsTagKey to import
    * @param importFromId The id of the existing DataGoogleTagsTagKey that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_tags_tag_key#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleTagsTagKey to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_tags_tag_key google_tags_tag_key} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleTagsTagKeyConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleTagsTagKeyConfig);
    get createTime(): string;
    get description(): string;
    get id(): string;
    get name(): string;
    get namespacedName(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _shortName?;
    get shortName(): string;
    set shortName(value: string);
    get shortNameInput(): string | undefined;
    get updateTime(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
