/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleTpuTensorflowVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_tpu_tensorflow_versions#id DataGoogleTpuTensorflowVersions#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_tpu_tensorflow_versions#project DataGoogleTpuTensorflowVersions#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_tpu_tensorflow_versions#zone DataGoogleTpuTensorflowVersions#zone}
    */
    readonly zone?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_tpu_tensorflow_versions google_tpu_tensorflow_versions}
*/
export declare class DataGoogleTpuTensorflowVersions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_tpu_tensorflow_versions";
    /**
    * Generates CDKTF code for importing a DataGoogleTpuTensorflowVersions resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleTpuTensorflowVersions to import
    * @param importFromId The id of the existing DataGoogleTpuTensorflowVersions that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_tpu_tensorflow_versions#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleTpuTensorflowVersions to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_tpu_tensorflow_versions google_tpu_tensorflow_versions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleTpuTensorflowVersionsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleTpuTensorflowVersionsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get versions(): string[];
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
