/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleVertexAiIndexConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vertex_ai_index#id DataGoogleVertexAiIndex#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource name of the Index.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vertex_ai_index#name DataGoogleVertexAiIndex#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vertex_ai_index#project DataGoogleVertexAiIndex#project}
    */
    readonly project?: string;
    /**
    * The region of the index. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vertex_ai_index#region DataGoogleVertexAiIndex#region}
    */
    readonly region: string;
}
export interface DataGoogleVertexAiIndexDeployedIndexes {
}
export declare function dataGoogleVertexAiIndexDeployedIndexesToTerraform(struct?: DataGoogleVertexAiIndexDeployedIndexes): any;
export declare function dataGoogleVertexAiIndexDeployedIndexesToHclTerraform(struct?: DataGoogleVertexAiIndexDeployedIndexes): any;
export declare class DataGoogleVertexAiIndexDeployedIndexesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVertexAiIndexDeployedIndexes | undefined;
    set internalValue(value: DataGoogleVertexAiIndexDeployedIndexes | undefined);
    get deployedIndexId(): string;
    get indexEndpoint(): string;
}
export declare class DataGoogleVertexAiIndexDeployedIndexesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVertexAiIndexDeployedIndexesOutputReference;
}
export interface DataGoogleVertexAiIndexIndexStats {
}
export declare function dataGoogleVertexAiIndexIndexStatsToTerraform(struct?: DataGoogleVertexAiIndexIndexStats): any;
export declare function dataGoogleVertexAiIndexIndexStatsToHclTerraform(struct?: DataGoogleVertexAiIndexIndexStats): any;
export declare class DataGoogleVertexAiIndexIndexStatsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVertexAiIndexIndexStats | undefined;
    set internalValue(value: DataGoogleVertexAiIndexIndexStats | undefined);
    get shardsCount(): number;
    get vectorsCount(): string;
}
export declare class DataGoogleVertexAiIndexIndexStatsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVertexAiIndexIndexStatsOutputReference;
}
export interface DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfig {
}
export declare function dataGoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfigToTerraform(struct?: DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfig): any;
export declare function dataGoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfigToHclTerraform(struct?: DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfig): any;
export declare class DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfig | undefined;
    set internalValue(value: DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfig | undefined);
}
export declare class DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfigOutputReference;
}
export interface DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfig {
}
export declare function dataGoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfigToTerraform(struct?: DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfig): any;
export declare function dataGoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfigToHclTerraform(struct?: DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfig): any;
export declare class DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfig | undefined;
    set internalValue(value: DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfig | undefined);
    get leafNodeEmbeddingCount(): number;
    get leafNodesToSearchPercent(): number;
}
export declare class DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfigOutputReference;
}
export interface DataGoogleVertexAiIndexMetadataConfigAlgorithmConfig {
}
export declare function dataGoogleVertexAiIndexMetadataConfigAlgorithmConfigToTerraform(struct?: DataGoogleVertexAiIndexMetadataConfigAlgorithmConfig): any;
export declare function dataGoogleVertexAiIndexMetadataConfigAlgorithmConfigToHclTerraform(struct?: DataGoogleVertexAiIndexMetadataConfigAlgorithmConfig): any;
export declare class DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVertexAiIndexMetadataConfigAlgorithmConfig | undefined;
    set internalValue(value: DataGoogleVertexAiIndexMetadataConfigAlgorithmConfig | undefined);
    private _bruteForceConfig;
    get bruteForceConfig(): DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfigList;
    private _treeAhConfig;
    get treeAhConfig(): DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfigList;
}
export declare class DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigOutputReference;
}
export interface DataGoogleVertexAiIndexMetadataConfig {
}
export declare function dataGoogleVertexAiIndexMetadataConfigToTerraform(struct?: DataGoogleVertexAiIndexMetadataConfig): any;
export declare function dataGoogleVertexAiIndexMetadataConfigToHclTerraform(struct?: DataGoogleVertexAiIndexMetadataConfig): any;
export declare class DataGoogleVertexAiIndexMetadataConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVertexAiIndexMetadataConfig | undefined;
    set internalValue(value: DataGoogleVertexAiIndexMetadataConfig | undefined);
    private _algorithmConfig;
    get algorithmConfig(): DataGoogleVertexAiIndexMetadataConfigAlgorithmConfigList;
    get approximateNeighborsCount(): number;
    get dimensions(): number;
    get distanceMeasureType(): string;
    get featureNormType(): string;
    get shardSize(): string;
}
export declare class DataGoogleVertexAiIndexMetadataConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVertexAiIndexMetadataConfigOutputReference;
}
export interface DataGoogleVertexAiIndexMetadata {
}
export declare function dataGoogleVertexAiIndexMetadataToTerraform(struct?: DataGoogleVertexAiIndexMetadata): any;
export declare function dataGoogleVertexAiIndexMetadataToHclTerraform(struct?: DataGoogleVertexAiIndexMetadata): any;
export declare class DataGoogleVertexAiIndexMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVertexAiIndexMetadata | undefined;
    set internalValue(value: DataGoogleVertexAiIndexMetadata | undefined);
    private _config;
    get config(): DataGoogleVertexAiIndexMetadataConfigList;
    get contentsDeltaUri(): string;
    get isCompleteOverwrite(): cdktf.IResolvable;
}
export declare class DataGoogleVertexAiIndexMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVertexAiIndexMetadataOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vertex_ai_index google_vertex_ai_index}
*/
export declare class DataGoogleVertexAiIndex extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_vertex_ai_index";
    /**
    * Generates CDKTF code for importing a DataGoogleVertexAiIndex resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleVertexAiIndex to import
    * @param importFromId The id of the existing DataGoogleVertexAiIndex that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vertex_ai_index#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleVertexAiIndex to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vertex_ai_index google_vertex_ai_index} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleVertexAiIndexConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleVertexAiIndexConfig);
    get createTime(): string;
    private _deployedIndexes;
    get deployedIndexes(): DataGoogleVertexAiIndexDeployedIndexesList;
    get description(): string;
    get displayName(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _indexStats;
    get indexStats(): DataGoogleVertexAiIndexIndexStatsList;
    get indexUpdateMethod(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    private _metadata;
    get metadata(): DataGoogleVertexAiIndexMetadataList;
    get metadataSchemaUri(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
