/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleVmwareengineExternalAccessRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_external_access_rule#id DataGoogleVmwareengineExternalAccessRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the external access rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_external_access_rule#name DataGoogleVmwareengineExternalAccessRule#name}
    */
    readonly name: string;
    /**
    * The resource name of the network policy.
    * Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
    * For example: projects/my-project/locations/us-west1-a/networkPolicies/my-policy
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_external_access_rule#parent DataGoogleVmwareengineExternalAccessRule#parent}
    */
    readonly parent: string;
}
export interface DataGoogleVmwareengineExternalAccessRuleDestinationIpRanges {
}
export declare function dataGoogleVmwareengineExternalAccessRuleDestinationIpRangesToTerraform(struct?: DataGoogleVmwareengineExternalAccessRuleDestinationIpRanges): any;
export declare function dataGoogleVmwareengineExternalAccessRuleDestinationIpRangesToHclTerraform(struct?: DataGoogleVmwareengineExternalAccessRuleDestinationIpRanges): any;
export declare class DataGoogleVmwareengineExternalAccessRuleDestinationIpRangesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVmwareengineExternalAccessRuleDestinationIpRanges | undefined;
    set internalValue(value: DataGoogleVmwareengineExternalAccessRuleDestinationIpRanges | undefined);
    get externalAddress(): string;
    get ipAddressRange(): string;
}
export declare class DataGoogleVmwareengineExternalAccessRuleDestinationIpRangesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVmwareengineExternalAccessRuleDestinationIpRangesOutputReference;
}
export interface DataGoogleVmwareengineExternalAccessRuleSourceIpRanges {
}
export declare function dataGoogleVmwareengineExternalAccessRuleSourceIpRangesToTerraform(struct?: DataGoogleVmwareengineExternalAccessRuleSourceIpRanges): any;
export declare function dataGoogleVmwareengineExternalAccessRuleSourceIpRangesToHclTerraform(struct?: DataGoogleVmwareengineExternalAccessRuleSourceIpRanges): any;
export declare class DataGoogleVmwareengineExternalAccessRuleSourceIpRangesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVmwareengineExternalAccessRuleSourceIpRanges | undefined;
    set internalValue(value: DataGoogleVmwareengineExternalAccessRuleSourceIpRanges | undefined);
    get ipAddress(): string;
    get ipAddressRange(): string;
}
export declare class DataGoogleVmwareengineExternalAccessRuleSourceIpRangesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVmwareengineExternalAccessRuleSourceIpRangesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_external_access_rule google_vmwareengine_external_access_rule}
*/
export declare class DataGoogleVmwareengineExternalAccessRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_vmwareengine_external_access_rule";
    /**
    * Generates CDKTF code for importing a DataGoogleVmwareengineExternalAccessRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleVmwareengineExternalAccessRule to import
    * @param importFromId The id of the existing DataGoogleVmwareengineExternalAccessRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_external_access_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleVmwareengineExternalAccessRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_external_access_rule google_vmwareengine_external_access_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleVmwareengineExternalAccessRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleVmwareengineExternalAccessRuleConfig);
    get action(): string;
    get createTime(): string;
    get description(): string;
    private _destinationIpRanges;
    get destinationIpRanges(): DataGoogleVmwareengineExternalAccessRuleDestinationIpRangesList;
    get destinationPorts(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ipProtocol(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    get priority(): number;
    private _sourceIpRanges;
    get sourceIpRanges(): DataGoogleVmwareengineExternalAccessRuleSourceIpRangesList;
    get sourcePorts(): string[];
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
