/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleVmwareengineExternalAddressConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_external_address#id DataGoogleVmwareengineExternalAddress#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the external IP Address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_external_address#name DataGoogleVmwareengineExternalAddress#name}
    */
    readonly name: string;
    /**
    * The resource name of the private cloud to create a new external address in.
    * Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
    * For example: projects/my-project/locations/us-west1-a/privateClouds/my-cloud
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_external_address#parent DataGoogleVmwareengineExternalAddress#parent}
    */
    readonly parent: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_external_address google_vmwareengine_external_address}
*/
export declare class DataGoogleVmwareengineExternalAddress extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_vmwareengine_external_address";
    /**
    * Generates CDKTF code for importing a DataGoogleVmwareengineExternalAddress resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleVmwareengineExternalAddress to import
    * @param importFromId The id of the existing DataGoogleVmwareengineExternalAddress that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_external_address#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleVmwareengineExternalAddress to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_external_address google_vmwareengine_external_address} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleVmwareengineExternalAddressConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleVmwareengineExternalAddressConfig);
    get createTime(): string;
    get description(): string;
    get externalIp(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get internalIp(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
