/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleVmwareengineNetworkPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_network_peering#id DataGoogleVmwareengineNetworkPeering#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the Network Peering.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_network_peering#name DataGoogleVmwareengineNetworkPeering#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_network_peering#project DataGoogleVmwareengineNetworkPeering#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_network_peering google_vmwareengine_network_peering}
*/
export declare class DataGoogleVmwareengineNetworkPeering extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_vmwareengine_network_peering";
    /**
    * Generates CDKTF code for importing a DataGoogleVmwareengineNetworkPeering resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleVmwareengineNetworkPeering to import
    * @param importFromId The id of the existing DataGoogleVmwareengineNetworkPeering that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_network_peering#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleVmwareengineNetworkPeering to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_network_peering google_vmwareengine_network_peering} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleVmwareengineNetworkPeeringConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleVmwareengineNetworkPeeringConfig);
    get createTime(): string;
    get description(): string;
    get exportCustomRoutes(): cdktf.IResolvable;
    get exportCustomRoutesWithPublicIp(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get importCustomRoutes(): cdktf.IResolvable;
    get importCustomRoutesWithPublicIp(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get peerNetwork(): string;
    get peerNetworkType(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    get stateDetails(): string;
    get uid(): string;
    get updateTime(): string;
    get vmwareEngineNetwork(): string;
    get vmwareEngineNetworkCanonical(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
