/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleVmwareengineNetworkPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_network_policy#id DataGoogleVmwareengineNetworkPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource name of the location (region) to create the new network policy in.
    * Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
    * For example: projects/my-project/locations/us-central1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_network_policy#location DataGoogleVmwareengineNetworkPolicy#location}
    */
    readonly location: string;
    /**
    * The ID of the Network Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_network_policy#name DataGoogleVmwareengineNetworkPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_network_policy#project DataGoogleVmwareengineNetworkPolicy#project}
    */
    readonly project?: string;
}
export interface DataGoogleVmwareengineNetworkPolicyExternalIp {
}
export declare function dataGoogleVmwareengineNetworkPolicyExternalIpToTerraform(struct?: DataGoogleVmwareengineNetworkPolicyExternalIp): any;
export declare function dataGoogleVmwareengineNetworkPolicyExternalIpToHclTerraform(struct?: DataGoogleVmwareengineNetworkPolicyExternalIp): any;
export declare class DataGoogleVmwareengineNetworkPolicyExternalIpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVmwareengineNetworkPolicyExternalIp | undefined;
    set internalValue(value: DataGoogleVmwareengineNetworkPolicyExternalIp | undefined);
    get enabled(): cdktf.IResolvable;
    get state(): string;
}
export declare class DataGoogleVmwareengineNetworkPolicyExternalIpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVmwareengineNetworkPolicyExternalIpOutputReference;
}
export interface DataGoogleVmwareengineNetworkPolicyInternetAccess {
}
export declare function dataGoogleVmwareengineNetworkPolicyInternetAccessToTerraform(struct?: DataGoogleVmwareengineNetworkPolicyInternetAccess): any;
export declare function dataGoogleVmwareengineNetworkPolicyInternetAccessToHclTerraform(struct?: DataGoogleVmwareengineNetworkPolicyInternetAccess): any;
export declare class DataGoogleVmwareengineNetworkPolicyInternetAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVmwareengineNetworkPolicyInternetAccess | undefined;
    set internalValue(value: DataGoogleVmwareengineNetworkPolicyInternetAccess | undefined);
    get enabled(): cdktf.IResolvable;
    get state(): string;
}
export declare class DataGoogleVmwareengineNetworkPolicyInternetAccessList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVmwareengineNetworkPolicyInternetAccessOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_network_policy google_vmwareengine_network_policy}
*/
export declare class DataGoogleVmwareengineNetworkPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_vmwareengine_network_policy";
    /**
    * Generates CDKTF code for importing a DataGoogleVmwareengineNetworkPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleVmwareengineNetworkPolicy to import
    * @param importFromId The id of the existing DataGoogleVmwareengineNetworkPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_network_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleVmwareengineNetworkPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_network_policy google_vmwareengine_network_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleVmwareengineNetworkPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleVmwareengineNetworkPolicyConfig);
    get createTime(): string;
    get description(): string;
    get edgeServicesCidr(): string;
    private _externalIp;
    get externalIp(): DataGoogleVmwareengineNetworkPolicyExternalIpList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _internetAccess;
    get internetAccess(): DataGoogleVmwareengineNetworkPolicyInternetAccessList;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get uid(): string;
    get updateTime(): string;
    get vmwareEngineNetwork(): string;
    get vmwareEngineNetworkCanonical(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
