/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleVmwareenginePrivateCloudConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_private_cloud#id DataGoogleVmwareenginePrivateCloud#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location where the PrivateCloud should reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_private_cloud#location DataGoogleVmwareenginePrivateCloud#location}
    */
    readonly location: string;
    /**
    * The ID of the PrivateCloud.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_private_cloud#name DataGoogleVmwareenginePrivateCloud#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_private_cloud#project DataGoogleVmwareenginePrivateCloud#project}
    */
    readonly project?: string;
}
export interface DataGoogleVmwareenginePrivateCloudHcx {
}
export declare function dataGoogleVmwareenginePrivateCloudHcxToTerraform(struct?: DataGoogleVmwareenginePrivateCloudHcx): any;
export declare function dataGoogleVmwareenginePrivateCloudHcxToHclTerraform(struct?: DataGoogleVmwareenginePrivateCloudHcx): any;
export declare class DataGoogleVmwareenginePrivateCloudHcxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVmwareenginePrivateCloudHcx | undefined;
    set internalValue(value: DataGoogleVmwareenginePrivateCloudHcx | undefined);
    get fqdn(): string;
    get internalIp(): string;
    get state(): string;
    get version(): string;
}
export declare class DataGoogleVmwareenginePrivateCloudHcxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVmwareenginePrivateCloudHcxOutputReference;
}
export interface DataGoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigs {
}
export declare function dataGoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigsToTerraform(struct?: DataGoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigs): any;
export declare function dataGoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigsToHclTerraform(struct?: DataGoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigs): any;
export declare class DataGoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigs | undefined;
    set internalValue(value: DataGoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigs | undefined);
    get customCoreCount(): number;
    get nodeCount(): number;
    get nodeTypeId(): string;
}
export declare class DataGoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigsOutputReference;
}
export interface DataGoogleVmwareenginePrivateCloudManagementCluster {
}
export declare function dataGoogleVmwareenginePrivateCloudManagementClusterToTerraform(struct?: DataGoogleVmwareenginePrivateCloudManagementCluster): any;
export declare function dataGoogleVmwareenginePrivateCloudManagementClusterToHclTerraform(struct?: DataGoogleVmwareenginePrivateCloudManagementCluster): any;
export declare class DataGoogleVmwareenginePrivateCloudManagementClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVmwareenginePrivateCloudManagementCluster | undefined;
    set internalValue(value: DataGoogleVmwareenginePrivateCloudManagementCluster | undefined);
    get clusterId(): string;
    private _nodeTypeConfigs;
    get nodeTypeConfigs(): DataGoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigsList;
}
export declare class DataGoogleVmwareenginePrivateCloudManagementClusterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVmwareenginePrivateCloudManagementClusterOutputReference;
}
export interface DataGoogleVmwareenginePrivateCloudNetworkConfig {
}
export declare function dataGoogleVmwareenginePrivateCloudNetworkConfigToTerraform(struct?: DataGoogleVmwareenginePrivateCloudNetworkConfig): any;
export declare function dataGoogleVmwareenginePrivateCloudNetworkConfigToHclTerraform(struct?: DataGoogleVmwareenginePrivateCloudNetworkConfig): any;
export declare class DataGoogleVmwareenginePrivateCloudNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVmwareenginePrivateCloudNetworkConfig | undefined;
    set internalValue(value: DataGoogleVmwareenginePrivateCloudNetworkConfig | undefined);
    get dnsServerIp(): string;
    get managementCidr(): string;
    get managementIpAddressLayoutVersion(): number;
    get vmwareEngineNetwork(): string;
    get vmwareEngineNetworkCanonical(): string;
}
export declare class DataGoogleVmwareenginePrivateCloudNetworkConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVmwareenginePrivateCloudNetworkConfigOutputReference;
}
export interface DataGoogleVmwareenginePrivateCloudNsx {
}
export declare function dataGoogleVmwareenginePrivateCloudNsxToTerraform(struct?: DataGoogleVmwareenginePrivateCloudNsx): any;
export declare function dataGoogleVmwareenginePrivateCloudNsxToHclTerraform(struct?: DataGoogleVmwareenginePrivateCloudNsx): any;
export declare class DataGoogleVmwareenginePrivateCloudNsxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVmwareenginePrivateCloudNsx | undefined;
    set internalValue(value: DataGoogleVmwareenginePrivateCloudNsx | undefined);
    get fqdn(): string;
    get internalIp(): string;
    get state(): string;
    get version(): string;
}
export declare class DataGoogleVmwareenginePrivateCloudNsxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVmwareenginePrivateCloudNsxOutputReference;
}
export interface DataGoogleVmwareenginePrivateCloudVcenter {
}
export declare function dataGoogleVmwareenginePrivateCloudVcenterToTerraform(struct?: DataGoogleVmwareenginePrivateCloudVcenter): any;
export declare function dataGoogleVmwareenginePrivateCloudVcenterToHclTerraform(struct?: DataGoogleVmwareenginePrivateCloudVcenter): any;
export declare class DataGoogleVmwareenginePrivateCloudVcenterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleVmwareenginePrivateCloudVcenter | undefined;
    set internalValue(value: DataGoogleVmwareenginePrivateCloudVcenter | undefined);
    get fqdn(): string;
    get internalIp(): string;
    get state(): string;
    get version(): string;
}
export declare class DataGoogleVmwareenginePrivateCloudVcenterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleVmwareenginePrivateCloudVcenterOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_private_cloud google_vmwareengine_private_cloud}
*/
export declare class DataGoogleVmwareenginePrivateCloud extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_vmwareengine_private_cloud";
    /**
    * Generates CDKTF code for importing a DataGoogleVmwareenginePrivateCloud resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleVmwareenginePrivateCloud to import
    * @param importFromId The id of the existing DataGoogleVmwareenginePrivateCloud that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_private_cloud#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleVmwareenginePrivateCloud to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_vmwareengine_private_cloud google_vmwareengine_private_cloud} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleVmwareenginePrivateCloudConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleVmwareenginePrivateCloudConfig);
    get description(): string;
    private _hcx;
    get hcx(): DataGoogleVmwareenginePrivateCloudHcxList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _managementCluster;
    get managementCluster(): DataGoogleVmwareenginePrivateCloudManagementClusterList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkConfig;
    get networkConfig(): DataGoogleVmwareenginePrivateCloudNetworkConfigList;
    private _nsx;
    get nsx(): DataGoogleVmwareenginePrivateCloudNsxList;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    get type(): string;
    get uid(): string;
    private _vcenter;
    get vcenter(): DataGoogleVmwareenginePrivateCloudVcenterList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
