/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAccessContextManagerAccessLevelConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the AccessLevel and its use. Does not affect behavior.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#description GoogleAccessContextManagerAccessLevel#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#id GoogleAccessContextManagerAccessLevel#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource name for the Access Level. The short_name component must begin
    * with a letter and only include alphanumeric and '_'.
    * Format: accessPolicies/{policy_id}/accessLevels/{short_name}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#name GoogleAccessContextManagerAccessLevel#name}
    */
    readonly name: string;
    /**
    * The AccessPolicy this AccessLevel lives in.
    * Format: accessPolicies/{policy_id}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#parent GoogleAccessContextManagerAccessLevel#parent}
    */
    readonly parent: string;
    /**
    * Human readable title. Must be unique within the Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#title GoogleAccessContextManagerAccessLevel#title}
    */
    readonly title: string;
    /**
    * basic block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#basic GoogleAccessContextManagerAccessLevel#basic}
    */
    readonly basic?: GoogleAccessContextManagerAccessLevelBasic;
    /**
    * custom block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#custom GoogleAccessContextManagerAccessLevel#custom}
    */
    readonly custom?: GoogleAccessContextManagerAccessLevelCustom;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#timeouts GoogleAccessContextManagerAccessLevel#timeouts}
    */
    readonly timeouts?: GoogleAccessContextManagerAccessLevelTimeouts;
}
export interface GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints {
    /**
    * The minimum allowed OS version. If not set, any version
    * of this OS satisfies the constraint.
    * Format: "major.minor.patch" such as "10.5.301", "9.2.1".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#minimum_version GoogleAccessContextManagerAccessLevel#minimum_version}
    */
    readonly minimumVersion?: string;
    /**
    * The operating system type of the device. Possible values: ["OS_UNSPECIFIED", "DESKTOP_MAC", "DESKTOP_WINDOWS", "DESKTOP_LINUX", "DESKTOP_CHROME_OS", "ANDROID", "IOS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#os_type GoogleAccessContextManagerAccessLevel#os_type}
    */
    readonly osType: string;
    /**
    * If you specify DESKTOP_CHROME_OS for osType, you can optionally include requireVerifiedChromeOs to require Chrome Verified Access.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#require_verified_chrome_os GoogleAccessContextManagerAccessLevel#require_verified_chrome_os}
    */
    readonly requireVerifiedChromeOs?: boolean | cdktf.IResolvable;
}
export declare function googleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraintsToTerraform(struct?: GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints | cdktf.IResolvable): any;
export declare function googleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraintsToHclTerraform(struct?: GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints | cdktf.IResolvable | undefined);
    private _minimumVersion?;
    get minimumVersion(): string;
    set minimumVersion(value: string);
    resetMinimumVersion(): void;
    get minimumVersionInput(): string | undefined;
    private _osType?;
    get osType(): string;
    set osType(value: string);
    get osTypeInput(): string | undefined;
    private _requireVerifiedChromeOs?;
    get requireVerifiedChromeOs(): boolean | cdktf.IResolvable;
    set requireVerifiedChromeOs(value: boolean | cdktf.IResolvable);
    resetRequireVerifiedChromeOs(): void;
    get requireVerifiedChromeOsInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraintsOutputReference;
}
export interface GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicy {
    /**
    * A list of allowed device management levels.
    * An empty list allows all management levels. Possible values: ["MANAGEMENT_UNSPECIFIED", "NONE", "BASIC", "COMPLETE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#allowed_device_management_levels GoogleAccessContextManagerAccessLevel#allowed_device_management_levels}
    */
    readonly allowedDeviceManagementLevels?: string[];
    /**
    * A list of allowed encryptions statuses.
    * An empty list allows all statuses. Possible values: ["ENCRYPTION_UNSPECIFIED", "ENCRYPTION_UNSUPPORTED", "UNENCRYPTED", "ENCRYPTED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#allowed_encryption_statuses GoogleAccessContextManagerAccessLevel#allowed_encryption_statuses}
    */
    readonly allowedEncryptionStatuses?: string[];
    /**
    * Whether the device needs to be approved by the customer admin.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#require_admin_approval GoogleAccessContextManagerAccessLevel#require_admin_approval}
    */
    readonly requireAdminApproval?: boolean | cdktf.IResolvable;
    /**
    * Whether the device needs to be corp owned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#require_corp_owned GoogleAccessContextManagerAccessLevel#require_corp_owned}
    */
    readonly requireCorpOwned?: boolean | cdktf.IResolvable;
    /**
    * Whether or not screenlock is required for the DevicePolicy
    * to be true. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#require_screen_lock GoogleAccessContextManagerAccessLevel#require_screen_lock}
    */
    readonly requireScreenLock?: boolean | cdktf.IResolvable;
    /**
    * os_constraints block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#os_constraints GoogleAccessContextManagerAccessLevel#os_constraints}
    */
    readonly osConstraints?: GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerAccessLevelBasicConditionsDevicePolicyToTerraform(struct?: GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOutputReference | GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicy): any;
export declare function googleAccessContextManagerAccessLevelBasicConditionsDevicePolicyToHclTerraform(struct?: GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOutputReference | GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicy): any;
export declare class GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicy | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicy | undefined);
    private _allowedDeviceManagementLevels?;
    get allowedDeviceManagementLevels(): string[];
    set allowedDeviceManagementLevels(value: string[]);
    resetAllowedDeviceManagementLevels(): void;
    get allowedDeviceManagementLevelsInput(): string[] | undefined;
    private _allowedEncryptionStatuses?;
    get allowedEncryptionStatuses(): string[];
    set allowedEncryptionStatuses(value: string[]);
    resetAllowedEncryptionStatuses(): void;
    get allowedEncryptionStatusesInput(): string[] | undefined;
    private _requireAdminApproval?;
    get requireAdminApproval(): boolean | cdktf.IResolvable;
    set requireAdminApproval(value: boolean | cdktf.IResolvable);
    resetRequireAdminApproval(): void;
    get requireAdminApprovalInput(): boolean | cdktf.IResolvable | undefined;
    private _requireCorpOwned?;
    get requireCorpOwned(): boolean | cdktf.IResolvable;
    set requireCorpOwned(value: boolean | cdktf.IResolvable);
    resetRequireCorpOwned(): void;
    get requireCorpOwnedInput(): boolean | cdktf.IResolvable | undefined;
    private _requireScreenLock?;
    get requireScreenLock(): boolean | cdktf.IResolvable;
    set requireScreenLock(value: boolean | cdktf.IResolvable);
    resetRequireScreenLock(): void;
    get requireScreenLockInput(): boolean | cdktf.IResolvable | undefined;
    private _osConstraints;
    get osConstraints(): GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraintsList;
    putOsConstraints(value: GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints[] | cdktf.IResolvable): void;
    resetOsConstraints(): void;
    get osConstraintsInput(): cdktf.IResolvable | GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints[] | undefined;
}
export interface GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesVpcSubnetwork {
    /**
    * Required. Network name to be allowed by this Access Level. Networks of foreign organizations requires 'compute.network.get' permission to be granted to caller.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#network GoogleAccessContextManagerAccessLevel#network}
    */
    readonly network: string;
    /**
    * CIDR block IP subnetwork specification. Must be IPv4.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#vpc_ip_subnetworks GoogleAccessContextManagerAccessLevel#vpc_ip_subnetworks}
    */
    readonly vpcIpSubnetworks?: string[];
}
export declare function googleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesVpcSubnetworkToTerraform(struct?: GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesVpcSubnetworkOutputReference | GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesVpcSubnetwork): any;
export declare function googleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesVpcSubnetworkToHclTerraform(struct?: GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesVpcSubnetworkOutputReference | GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesVpcSubnetwork): any;
export declare class GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesVpcSubnetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesVpcSubnetwork | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesVpcSubnetwork | undefined);
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _vpcIpSubnetworks?;
    get vpcIpSubnetworks(): string[];
    set vpcIpSubnetworks(value: string[]);
    resetVpcIpSubnetworks(): void;
    get vpcIpSubnetworksInput(): string[] | undefined;
}
export interface GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSources {
    /**
    * vpc_subnetwork block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#vpc_subnetwork GoogleAccessContextManagerAccessLevel#vpc_subnetwork}
    */
    readonly vpcSubnetwork?: GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesVpcSubnetwork;
}
export declare function googleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesToTerraform(struct?: GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSources | cdktf.IResolvable): any;
export declare function googleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesToHclTerraform(struct?: GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSources | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSources | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSources | cdktf.IResolvable | undefined);
    private _vpcSubnetwork;
    get vpcSubnetwork(): GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesVpcSubnetworkOutputReference;
    putVpcSubnetwork(value: GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesVpcSubnetwork): void;
    resetVpcSubnetwork(): void;
    get vpcSubnetworkInput(): GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesVpcSubnetwork | undefined;
}
export declare class GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesOutputReference;
}
export interface GoogleAccessContextManagerAccessLevelBasicConditions {
    /**
    * A list of CIDR block IP subnetwork specification. May be IPv4
    * or IPv6.
    * Note that for a CIDR IP address block, the specified IP address
    * portion must be properly truncated (i.e. all the host bits must
    * be zero) or the input is considered malformed. For example,
    * "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
    * for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
    * is not. The originating IP of a request must be in one of the
    * listed subnets in order for this Condition to be true.
    * If empty, all IP addresses are allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#ip_subnetworks GoogleAccessContextManagerAccessLevel#ip_subnetworks}
    */
    readonly ipSubnetworks?: string[];
    /**
    * An allowed list of members (users, service accounts).
    * Using groups is not supported yet.
    *
    * The signed-in user originating the request must be a part of one
    * of the provided members. If not specified, a request may come
    * from any user (logged in/not logged in, not present in any
    * groups, etc.).
    * Formats: 'user:{emailid}', 'serviceAccount:{emailid}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#members GoogleAccessContextManagerAccessLevel#members}
    */
    readonly members?: string[];
    /**
    * Whether to negate the Condition. If true, the Condition becomes
    * a NAND over its non-empty fields, each field must be false for
    * the Condition overall to be satisfied. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#negate GoogleAccessContextManagerAccessLevel#negate}
    */
    readonly negate?: boolean | cdktf.IResolvable;
    /**
    * The request must originate from one of the provided
    * countries/regions.
    * Format: A valid ISO 3166-1 alpha-2 code.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#regions GoogleAccessContextManagerAccessLevel#regions}
    */
    readonly regions?: string[];
    /**
    * A list of other access levels defined in the same Policy,
    * referenced by resource name. Referencing an AccessLevel which
    * does not exist is an error. All access levels listed must be
    * granted for the Condition to be true.
    * Format: accessPolicies/{policy_id}/accessLevels/{short_name}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#required_access_levels GoogleAccessContextManagerAccessLevel#required_access_levels}
    */
    readonly requiredAccessLevels?: string[];
    /**
    * device_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#device_policy GoogleAccessContextManagerAccessLevel#device_policy}
    */
    readonly devicePolicy?: GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicy;
    /**
    * vpc_network_sources block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#vpc_network_sources GoogleAccessContextManagerAccessLevel#vpc_network_sources}
    */
    readonly vpcNetworkSources?: GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSources[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerAccessLevelBasicConditionsToTerraform(struct?: GoogleAccessContextManagerAccessLevelBasicConditions | cdktf.IResolvable): any;
export declare function googleAccessContextManagerAccessLevelBasicConditionsToHclTerraform(struct?: GoogleAccessContextManagerAccessLevelBasicConditions | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerAccessLevelBasicConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerAccessLevelBasicConditions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelBasicConditions | cdktf.IResolvable | undefined);
    private _ipSubnetworks?;
    get ipSubnetworks(): string[];
    set ipSubnetworks(value: string[]);
    resetIpSubnetworks(): void;
    get ipSubnetworksInput(): string[] | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    resetMembers(): void;
    get membersInput(): string[] | undefined;
    private _negate?;
    get negate(): boolean | cdktf.IResolvable;
    set negate(value: boolean | cdktf.IResolvable);
    resetNegate(): void;
    get negateInput(): boolean | cdktf.IResolvable | undefined;
    private _regions?;
    get regions(): string[];
    set regions(value: string[]);
    resetRegions(): void;
    get regionsInput(): string[] | undefined;
    private _requiredAccessLevels?;
    get requiredAccessLevels(): string[];
    set requiredAccessLevels(value: string[]);
    resetRequiredAccessLevels(): void;
    get requiredAccessLevelsInput(): string[] | undefined;
    private _devicePolicy;
    get devicePolicy(): GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicyOutputReference;
    putDevicePolicy(value: GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicy): void;
    resetDevicePolicy(): void;
    get devicePolicyInput(): GoogleAccessContextManagerAccessLevelBasicConditionsDevicePolicy | undefined;
    private _vpcNetworkSources;
    get vpcNetworkSources(): GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSourcesList;
    putVpcNetworkSources(value: GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSources[] | cdktf.IResolvable): void;
    resetVpcNetworkSources(): void;
    get vpcNetworkSourcesInput(): cdktf.IResolvable | GoogleAccessContextManagerAccessLevelBasicConditionsVpcNetworkSources[] | undefined;
}
export declare class GoogleAccessContextManagerAccessLevelBasicConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerAccessLevelBasicConditions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerAccessLevelBasicConditionsOutputReference;
}
export interface GoogleAccessContextManagerAccessLevelBasic {
    /**
    * How the conditions list should be combined to determine if a request
    * is granted this AccessLevel. If AND is used, each Condition in
    * conditions must be satisfied for the AccessLevel to be applied. If
    * OR is used, at least one Condition in conditions must be satisfied
    * for the AccessLevel to be applied. Default value: "AND" Possible values: ["AND", "OR"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#combining_function GoogleAccessContextManagerAccessLevel#combining_function}
    */
    readonly combiningFunction?: string;
    /**
    * conditions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#conditions GoogleAccessContextManagerAccessLevel#conditions}
    */
    readonly conditions: GoogleAccessContextManagerAccessLevelBasicConditions[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerAccessLevelBasicToTerraform(struct?: GoogleAccessContextManagerAccessLevelBasicOutputReference | GoogleAccessContextManagerAccessLevelBasic): any;
export declare function googleAccessContextManagerAccessLevelBasicToHclTerraform(struct?: GoogleAccessContextManagerAccessLevelBasicOutputReference | GoogleAccessContextManagerAccessLevelBasic): any;
export declare class GoogleAccessContextManagerAccessLevelBasicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerAccessLevelBasic | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelBasic | undefined);
    private _combiningFunction?;
    get combiningFunction(): string;
    set combiningFunction(value: string);
    resetCombiningFunction(): void;
    get combiningFunctionInput(): string | undefined;
    private _conditions;
    get conditions(): GoogleAccessContextManagerAccessLevelBasicConditionsList;
    putConditions(value: GoogleAccessContextManagerAccessLevelBasicConditions[] | cdktf.IResolvable): void;
    get conditionsInput(): cdktf.IResolvable | GoogleAccessContextManagerAccessLevelBasicConditions[] | undefined;
}
export interface GoogleAccessContextManagerAccessLevelCustomExpr {
    /**
    * Description of the expression
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#description GoogleAccessContextManagerAccessLevel#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#expression GoogleAccessContextManagerAccessLevel#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#location GoogleAccessContextManagerAccessLevel#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#title GoogleAccessContextManagerAccessLevel#title}
    */
    readonly title?: string;
}
export declare function googleAccessContextManagerAccessLevelCustomExprToTerraform(struct?: GoogleAccessContextManagerAccessLevelCustomExprOutputReference | GoogleAccessContextManagerAccessLevelCustomExpr): any;
export declare function googleAccessContextManagerAccessLevelCustomExprToHclTerraform(struct?: GoogleAccessContextManagerAccessLevelCustomExprOutputReference | GoogleAccessContextManagerAccessLevelCustomExpr): any;
export declare class GoogleAccessContextManagerAccessLevelCustomExprOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerAccessLevelCustomExpr | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelCustomExpr | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleAccessContextManagerAccessLevelCustom {
    /**
    * expr block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#expr GoogleAccessContextManagerAccessLevel#expr}
    */
    readonly expr: GoogleAccessContextManagerAccessLevelCustomExpr;
}
export declare function googleAccessContextManagerAccessLevelCustomToTerraform(struct?: GoogleAccessContextManagerAccessLevelCustomOutputReference | GoogleAccessContextManagerAccessLevelCustom): any;
export declare function googleAccessContextManagerAccessLevelCustomToHclTerraform(struct?: GoogleAccessContextManagerAccessLevelCustomOutputReference | GoogleAccessContextManagerAccessLevelCustom): any;
export declare class GoogleAccessContextManagerAccessLevelCustomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerAccessLevelCustom | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelCustom | undefined);
    private _expr;
    get expr(): GoogleAccessContextManagerAccessLevelCustomExprOutputReference;
    putExpr(value: GoogleAccessContextManagerAccessLevelCustomExpr): void;
    get exprInput(): GoogleAccessContextManagerAccessLevelCustomExpr | undefined;
}
export interface GoogleAccessContextManagerAccessLevelTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#create GoogleAccessContextManagerAccessLevel#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#delete GoogleAccessContextManagerAccessLevel#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#update GoogleAccessContextManagerAccessLevel#update}
    */
    readonly update?: string;
}
export declare function googleAccessContextManagerAccessLevelTimeoutsToTerraform(struct?: GoogleAccessContextManagerAccessLevelTimeouts | cdktf.IResolvable): any;
export declare function googleAccessContextManagerAccessLevelTimeoutsToHclTerraform(struct?: GoogleAccessContextManagerAccessLevelTimeouts | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerAccessLevelTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerAccessLevelTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level google_access_context_manager_access_level}
*/
export declare class GoogleAccessContextManagerAccessLevel extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_access_context_manager_access_level";
    /**
    * Generates CDKTF code for importing a GoogleAccessContextManagerAccessLevel resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleAccessContextManagerAccessLevel to import
    * @param importFromId The id of the existing GoogleAccessContextManagerAccessLevel that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleAccessContextManagerAccessLevel to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_access_level google_access_context_manager_access_level} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAccessContextManagerAccessLevelConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAccessContextManagerAccessLevelConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _basic;
    get basic(): GoogleAccessContextManagerAccessLevelBasicOutputReference;
    putBasic(value: GoogleAccessContextManagerAccessLevelBasic): void;
    resetBasic(): void;
    get basicInput(): GoogleAccessContextManagerAccessLevelBasic | undefined;
    private _custom;
    get custom(): GoogleAccessContextManagerAccessLevelCustomOutputReference;
    putCustom(value: GoogleAccessContextManagerAccessLevelCustom): void;
    resetCustom(): void;
    get customInput(): GoogleAccessContextManagerAccessLevelCustom | undefined;
    private _timeouts;
    get timeouts(): GoogleAccessContextManagerAccessLevelTimeoutsOutputReference;
    putTimeouts(value: GoogleAccessContextManagerAccessLevelTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): GoogleAccessContextManagerAccessLevelTimeouts | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
