/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAccessContextManagerAuthorizedOrgsDescConfig extends cdktf.TerraformMetaArguments {
    /**
    * The type of entities that need to use the authorization relationship during
    * evaluation, such as a device. Valid values are "ASSET_TYPE_DEVICE" and
    * "ASSET_TYPE_CREDENTIAL_STRENGTH". Possible values: ["ASSET_TYPE_DEVICE", "ASSET_TYPE_CREDENTIAL_STRENGTH"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_authorized_orgs_desc#asset_type GoogleAccessContextManagerAuthorizedOrgsDesc#asset_type}
    */
    readonly assetType?: string;
    /**
    * The direction of the authorization relationship between this organization
    * and the organizations listed in the "orgs" field. The valid values for this
    * field include the following:
    *
    * AUTHORIZATION_DIRECTION_FROM: Allows this organization to evaluate traffic
    * in the organizations listed in the 'orgs' field.
    *
    * AUTHORIZATION_DIRECTION_TO: Allows the organizations listed in the 'orgs'
    * field to evaluate the traffic in this organization.
    *
    * For the authorization relationship to take effect, all of the organizations
    * must authorize and specify the appropriate relationship direction. For
    * example, if organization A authorized organization B and C to evaluate its
    * traffic, by specifying "AUTHORIZATION_DIRECTION_TO" as the authorization
    * direction, organizations B and C must specify
    * "AUTHORIZATION_DIRECTION_FROM" as the authorization direction in their
    * "AuthorizedOrgsDesc" resource. Possible values: ["AUTHORIZATION_DIRECTION_TO", "AUTHORIZATION_DIRECTION_FROM"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_authorized_orgs_desc#authorization_direction GoogleAccessContextManagerAuthorizedOrgsDesc#authorization_direction}
    */
    readonly authorizationDirection?: string;
    /**
    * A granular control type for authorization levels. Valid value is "AUTHORIZATION_TYPE_TRUST". Possible values: ["AUTHORIZATION_TYPE_TRUST"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_authorized_orgs_desc#authorization_type GoogleAccessContextManagerAuthorizedOrgsDesc#authorization_type}
    */
    readonly authorizationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_authorized_orgs_desc#id GoogleAccessContextManagerAuthorizedOrgsDesc#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource name for the 'AuthorizedOrgsDesc'. Format:
    * 'accessPolicies/{access_policy}/authorizedOrgsDescs/{authorized_orgs_desc}'.
    * The 'authorized_orgs_desc' component must begin with a letter, followed by
    * alphanumeric characters or '_'.
    * After you create an 'AuthorizedOrgsDesc', you cannot change its 'name'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_authorized_orgs_desc#name GoogleAccessContextManagerAuthorizedOrgsDesc#name}
    */
    readonly name: string;
    /**
    * The list of organization ids in this AuthorizedOrgsDesc.
    * Format: 'organizations/<org_number>'
    * Example: 'organizations/123456'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_authorized_orgs_desc#orgs GoogleAccessContextManagerAuthorizedOrgsDesc#orgs}
    */
    readonly orgs?: string[];
    /**
    * Required. Resource name for the access policy which owns this 'AuthorizedOrgsDesc'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_authorized_orgs_desc#parent GoogleAccessContextManagerAuthorizedOrgsDesc#parent}
    */
    readonly parent: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_authorized_orgs_desc#timeouts GoogleAccessContextManagerAuthorizedOrgsDesc#timeouts}
    */
    readonly timeouts?: GoogleAccessContextManagerAuthorizedOrgsDescTimeouts;
}
export interface GoogleAccessContextManagerAuthorizedOrgsDescTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_authorized_orgs_desc#create GoogleAccessContextManagerAuthorizedOrgsDesc#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_authorized_orgs_desc#delete GoogleAccessContextManagerAuthorizedOrgsDesc#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_authorized_orgs_desc#update GoogleAccessContextManagerAuthorizedOrgsDesc#update}
    */
    readonly update?: string;
}
export declare function googleAccessContextManagerAuthorizedOrgsDescTimeoutsToTerraform(struct?: GoogleAccessContextManagerAuthorizedOrgsDescTimeouts | cdktf.IResolvable): any;
export declare function googleAccessContextManagerAuthorizedOrgsDescTimeoutsToHclTerraform(struct?: GoogleAccessContextManagerAuthorizedOrgsDescTimeouts | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerAuthorizedOrgsDescTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerAuthorizedOrgsDescTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerAuthorizedOrgsDescTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_authorized_orgs_desc google_access_context_manager_authorized_orgs_desc}
*/
export declare class GoogleAccessContextManagerAuthorizedOrgsDesc extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_access_context_manager_authorized_orgs_desc";
    /**
    * Generates CDKTF code for importing a GoogleAccessContextManagerAuthorizedOrgsDesc resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleAccessContextManagerAuthorizedOrgsDesc to import
    * @param importFromId The id of the existing GoogleAccessContextManagerAuthorizedOrgsDesc that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_authorized_orgs_desc#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleAccessContextManagerAuthorizedOrgsDesc to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_authorized_orgs_desc google_access_context_manager_authorized_orgs_desc} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAccessContextManagerAuthorizedOrgsDescConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAccessContextManagerAuthorizedOrgsDescConfig);
    private _assetType?;
    get assetType(): string;
    set assetType(value: string);
    resetAssetType(): void;
    get assetTypeInput(): string | undefined;
    private _authorizationDirection?;
    get authorizationDirection(): string;
    set authorizationDirection(value: string);
    resetAuthorizationDirection(): void;
    get authorizationDirectionInput(): string | undefined;
    private _authorizationType?;
    get authorizationType(): string;
    set authorizationType(value: string);
    resetAuthorizationType(): void;
    get authorizationTypeInput(): string | undefined;
    get createTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orgs?;
    get orgs(): string[];
    set orgs(value: string[]);
    resetOrgs(): void;
    get orgsInput(): string[] | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleAccessContextManagerAuthorizedOrgsDescTimeoutsOutputReference;
    putTimeouts(value: GoogleAccessContextManagerAuthorizedOrgsDescTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAccessContextManagerAuthorizedOrgsDescTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
