/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAccessContextManagerServicePerimeterEgressPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#id GoogleAccessContextManagerServicePerimeterEgressPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Service Perimeter to add this resource to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#perimeter GoogleAccessContextManagerServicePerimeterEgressPolicy#perimeter}
    */
    readonly perimeter: string;
    /**
    * egress_from block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#egress_from GoogleAccessContextManagerServicePerimeterEgressPolicy#egress_from}
    */
    readonly egressFrom?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFrom;
    /**
    * egress_to block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#egress_to GoogleAccessContextManagerServicePerimeterEgressPolicy#egress_to}
    */
    readonly egressTo?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressTo;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#timeouts GoogleAccessContextManagerServicePerimeterEgressPolicy#timeouts}
    */
    readonly timeouts?: GoogleAccessContextManagerServicePerimeterEgressPolicyTimeouts;
}
export interface GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromSources {
    /**
    * An AccessLevel resource name that allows resources outside the ServicePerimeter to be accessed from the inside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#access_level GoogleAccessContextManagerServicePerimeterEgressPolicy#access_level}
    */
    readonly accessLevel?: string;
}
export declare function googleAccessContextManagerServicePerimeterEgressPolicyEgressFromSourcesToTerraform(struct?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromSources | cdktf.IResolvable): any;
export declare function googleAccessContextManagerServicePerimeterEgressPolicyEgressFromSourcesToHclTerraform(struct?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromSources | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromSources | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromSources | cdktf.IResolvable | undefined);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    resetAccessLevel(): void;
    get accessLevelInput(): string | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromSources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromSourcesOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFrom {
    /**
    * A list of identities that are allowed access through this 'EgressPolicy'.
    * Should be in the format of an email address. The email address should
    * represent an individual user, service account, or Google group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#identities GoogleAccessContextManagerServicePerimeterEgressPolicy#identities}
    */
    readonly identities?: string[];
    /**
    * Specifies the type of identities that are allowed access to outside the
    * perimeter. If left unspecified, then members of 'identities' field will
    * be allowed access. Possible values: ["ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#identity_type GoogleAccessContextManagerServicePerimeterEgressPolicy#identity_type}
    */
    readonly identityType?: string;
    /**
    * Whether to enforce traffic restrictions based on 'sources' field. If the 'sources' field is non-empty, then this field must be set to 'SOURCE_RESTRICTION_ENABLED'. Possible values: ["SOURCE_RESTRICTION_UNSPECIFIED", "SOURCE_RESTRICTION_ENABLED", "SOURCE_RESTRICTION_DISABLED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#source_restriction GoogleAccessContextManagerServicePerimeterEgressPolicy#source_restriction}
    */
    readonly sourceRestriction?: string;
    /**
    * sources block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#sources GoogleAccessContextManagerServicePerimeterEgressPolicy#sources}
    */
    readonly sources?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromSources[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterEgressPolicyEgressFromToTerraform(struct?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromOutputReference | GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFrom): any;
export declare function googleAccessContextManagerServicePerimeterEgressPolicyEgressFromToHclTerraform(struct?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromOutputReference | GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFrom): any;
export declare class GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFrom | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFrom | undefined);
    private _identities?;
    get identities(): string[];
    set identities(value: string[]);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string;
    set identityType(value: string);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
    private _sourceRestriction?;
    get sourceRestriction(): string;
    set sourceRestriction(value: string);
    resetSourceRestriction(): void;
    get sourceRestrictionInput(): string | undefined;
    private _sources;
    get sources(): GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromSourcesList;
    putSources(value: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromSources[] | cdktf.IResolvable): void;
    resetSources(): void;
    get sourcesInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromSources[] | undefined;
}
export interface GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsMethodSelectors {
    /**
    * Value for 'method' should be a valid method name for the corresponding
    * 'serviceName' in 'ApiOperation'. If '*' used as value for method,
    * then ALL methods and permissions are allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#method GoogleAccessContextManagerServicePerimeterEgressPolicy#method}
    */
    readonly method?: string;
    /**
    * Value for permission should be a valid Cloud IAM permission for the
    * corresponding 'serviceName' in 'ApiOperation'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#permission GoogleAccessContextManagerServicePerimeterEgressPolicy#permission}
    */
    readonly permission?: string;
}
export declare function googleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsMethodSelectorsToTerraform(struct?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsMethodSelectors | cdktf.IResolvable): any;
export declare function googleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsMethodSelectorsToHclTerraform(struct?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsMethodSelectors | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsMethodSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsMethodSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsMethodSelectors | cdktf.IResolvable | undefined);
    private _method?;
    get method(): string;
    set method(value: string);
    resetMethod(): void;
    get methodInput(): string | undefined;
    private _permission?;
    get permission(): string;
    set permission(value: string);
    resetPermission(): void;
    get permissionInput(): string | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsMethodSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsMethodSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsMethodSelectorsOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperations {
    /**
    * The name of the API whose methods or permissions the 'IngressPolicy' or
    * 'EgressPolicy' want to allow. A single 'ApiOperation' with serviceName
    * field set to '*' will allow all methods AND permissions for all services.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#service_name GoogleAccessContextManagerServicePerimeterEgressPolicy#service_name}
    */
    readonly serviceName?: string;
    /**
    * method_selectors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#method_selectors GoogleAccessContextManagerServicePerimeterEgressPolicy#method_selectors}
    */
    readonly methodSelectors?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsMethodSelectors[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsToTerraform(struct?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperations | cdktf.IResolvable): any;
export declare function googleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsToHclTerraform(struct?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperations | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperations | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperations | cdktf.IResolvable | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _methodSelectors;
    get methodSelectors(): GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsMethodSelectorsList;
    putMethodSelectors(value: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsMethodSelectors[] | cdktf.IResolvable): void;
    resetMethodSelectors(): void;
    get methodSelectorsInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsMethodSelectors[] | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterEgressPolicyEgressTo {
    /**
    * A list of external resources that are allowed to be accessed. A request
    * matches if it contains an external resource in this list (Example:
    * s3://bucket/path). Currently '*' is not allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#external_resources GoogleAccessContextManagerServicePerimeterEgressPolicy#external_resources}
    */
    readonly externalResources?: string[];
    /**
    * A list of resources, currently only projects in the form
    * 'projects/<projectnumber>', that match this to stanza. A request matches
    * if it contains a resource in this list. If * is specified for resources,
    * then this 'EgressTo' rule will authorize access to all resources outside
    * the perimeter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#resources GoogleAccessContextManagerServicePerimeterEgressPolicy#resources}
    */
    readonly resources?: string[];
    /**
    * operations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#operations GoogleAccessContextManagerServicePerimeterEgressPolicy#operations}
    */
    readonly operations?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperations[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterEgressPolicyEgressToToTerraform(struct?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOutputReference | GoogleAccessContextManagerServicePerimeterEgressPolicyEgressTo): any;
export declare function googleAccessContextManagerServicePerimeterEgressPolicyEgressToToHclTerraform(struct?: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOutputReference | GoogleAccessContextManagerServicePerimeterEgressPolicyEgressTo): any;
export declare class GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterEgressPolicyEgressTo | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressTo | undefined);
    private _externalResources?;
    get externalResources(): string[];
    set externalResources(value: string[]);
    resetExternalResources(): void;
    get externalResourcesInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations;
    get operations(): GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperationsList;
    putOperations(value: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperations[] | cdktf.IResolvable): void;
    resetOperations(): void;
    get operationsInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOperations[] | undefined;
}
export interface GoogleAccessContextManagerServicePerimeterEgressPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#create GoogleAccessContextManagerServicePerimeterEgressPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#delete GoogleAccessContextManagerServicePerimeterEgressPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#update GoogleAccessContextManagerServicePerimeterEgressPolicy#update}
    */
    readonly update?: string;
}
export declare function googleAccessContextManagerServicePerimeterEgressPolicyTimeoutsToTerraform(struct?: GoogleAccessContextManagerServicePerimeterEgressPolicyTimeouts | cdktf.IResolvable): any;
export declare function googleAccessContextManagerServicePerimeterEgressPolicyTimeoutsToHclTerraform(struct?: GoogleAccessContextManagerServicePerimeterEgressPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterEgressPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterEgressPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterEgressPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy google_access_context_manager_service_perimeter_egress_policy}
*/
export declare class GoogleAccessContextManagerServicePerimeterEgressPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_access_context_manager_service_perimeter_egress_policy";
    /**
    * Generates CDKTF code for importing a GoogleAccessContextManagerServicePerimeterEgressPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleAccessContextManagerServicePerimeterEgressPolicy to import
    * @param importFromId The id of the existing GoogleAccessContextManagerServicePerimeterEgressPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleAccessContextManagerServicePerimeterEgressPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_egress_policy google_access_context_manager_service_perimeter_egress_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAccessContextManagerServicePerimeterEgressPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAccessContextManagerServicePerimeterEgressPolicyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _perimeter?;
    get perimeter(): string;
    set perimeter(value: string);
    get perimeterInput(): string | undefined;
    private _egressFrom;
    get egressFrom(): GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFromOutputReference;
    putEgressFrom(value: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFrom): void;
    resetEgressFrom(): void;
    get egressFromInput(): GoogleAccessContextManagerServicePerimeterEgressPolicyEgressFrom | undefined;
    private _egressTo;
    get egressTo(): GoogleAccessContextManagerServicePerimeterEgressPolicyEgressToOutputReference;
    putEgressTo(value: GoogleAccessContextManagerServicePerimeterEgressPolicyEgressTo): void;
    resetEgressTo(): void;
    get egressToInput(): GoogleAccessContextManagerServicePerimeterEgressPolicyEgressTo | undefined;
    private _timeouts;
    get timeouts(): GoogleAccessContextManagerServicePerimeterEgressPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleAccessContextManagerServicePerimeterEgressPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterEgressPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
