/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAccessContextManagerServicePerimeterIngressPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#id GoogleAccessContextManagerServicePerimeterIngressPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Service Perimeter to add this resource to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#perimeter GoogleAccessContextManagerServicePerimeterIngressPolicy#perimeter}
    */
    readonly perimeter: string;
    /**
    * ingress_from block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#ingress_from GoogleAccessContextManagerServicePerimeterIngressPolicy#ingress_from}
    */
    readonly ingressFrom?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFrom;
    /**
    * ingress_to block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#ingress_to GoogleAccessContextManagerServicePerimeterIngressPolicy#ingress_to}
    */
    readonly ingressTo?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressTo;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#timeouts GoogleAccessContextManagerServicePerimeterIngressPolicy#timeouts}
    */
    readonly timeouts?: GoogleAccessContextManagerServicePerimeterIngressPolicyTimeouts;
}
export interface GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromSources {
    /**
    * An 'AccessLevel' resource name that allow resources within the
    * 'ServicePerimeters' to be accessed from the internet. 'AccessLevels' listed
    * must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
    * 'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
    * resources within the perimeter can only be accessed via Google Cloud calls
    * with request origins within the perimeter.
    * Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
    * If * is specified, then all IngressSources will be allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#access_level GoogleAccessContextManagerServicePerimeterIngressPolicy#access_level}
    */
    readonly accessLevel?: string;
    /**
    * A Google Cloud resource that is allowed to ingress the perimeter.
    * Requests from these resources will be allowed to access perimeter data.
    * Currently only projects are allowed. Format 'projects/{project_number}'
    * The project may be in any Google Cloud organization, not just the
    * organization that the perimeter is defined in. '*' is not allowed, the case
    * of allowing all Google Cloud resources only is not supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#resource GoogleAccessContextManagerServicePerimeterIngressPolicy#resource}
    */
    readonly resource?: string;
}
export declare function googleAccessContextManagerServicePerimeterIngressPolicyIngressFromSourcesToTerraform(struct?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromSources | cdktf.IResolvable): any;
export declare function googleAccessContextManagerServicePerimeterIngressPolicyIngressFromSourcesToHclTerraform(struct?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromSources | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromSources | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromSources | cdktf.IResolvable | undefined);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    resetAccessLevel(): void;
    get accessLevelInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    resetResource(): void;
    get resourceInput(): string | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromSources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromSourcesOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFrom {
    /**
    * A list of identities that are allowed access through this 'IngressPolicy'.
    * Should be in the format of an email address. The email address should represent
    * an individual user, service account, or Google group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#identities GoogleAccessContextManagerServicePerimeterIngressPolicy#identities}
    */
    readonly identities?: string[];
    /**
    * Specifies the type of identities that are allowed access from outside the
    * perimeter. If left unspecified, then members of 'identities' field will be
    * allowed access. Possible values: ["ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#identity_type GoogleAccessContextManagerServicePerimeterIngressPolicy#identity_type}
    */
    readonly identityType?: string;
    /**
    * sources block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#sources GoogleAccessContextManagerServicePerimeterIngressPolicy#sources}
    */
    readonly sources?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromSources[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterIngressPolicyIngressFromToTerraform(struct?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromOutputReference | GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFrom): any;
export declare function googleAccessContextManagerServicePerimeterIngressPolicyIngressFromToHclTerraform(struct?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromOutputReference | GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFrom): any;
export declare class GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFrom | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFrom | undefined);
    private _identities?;
    get identities(): string[];
    set identities(value: string[]);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string;
    set identityType(value: string);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
    private _sources;
    get sources(): GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromSourcesList;
    putSources(value: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromSources[] | cdktf.IResolvable): void;
    resetSources(): void;
    get sourcesInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromSources[] | undefined;
}
export interface GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsMethodSelectors {
    /**
    * Value for method should be a valid method name for the corresponding
    * serviceName in 'ApiOperation'. If '*' used as value for 'method', then
    * ALL methods and permissions are allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#method GoogleAccessContextManagerServicePerimeterIngressPolicy#method}
    */
    readonly method?: string;
    /**
    * Value for permission should be a valid Cloud IAM permission for the
    * corresponding 'serviceName' in 'ApiOperation'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#permission GoogleAccessContextManagerServicePerimeterIngressPolicy#permission}
    */
    readonly permission?: string;
}
export declare function googleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsMethodSelectorsToTerraform(struct?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsMethodSelectors | cdktf.IResolvable): any;
export declare function googleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsMethodSelectorsToHclTerraform(struct?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsMethodSelectors | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsMethodSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsMethodSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsMethodSelectors | cdktf.IResolvable | undefined);
    private _method?;
    get method(): string;
    set method(value: string);
    resetMethod(): void;
    get methodInput(): string | undefined;
    private _permission?;
    get permission(): string;
    set permission(value: string);
    resetPermission(): void;
    get permissionInput(): string | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsMethodSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsMethodSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsMethodSelectorsOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperations {
    /**
    * The name of the API whose methods or permissions the 'IngressPolicy' or
    * 'EgressPolicy' want to allow. A single 'ApiOperation' with 'serviceName'
    * field set to '*' will allow all methods AND permissions for all services.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#service_name GoogleAccessContextManagerServicePerimeterIngressPolicy#service_name}
    */
    readonly serviceName?: string;
    /**
    * method_selectors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#method_selectors GoogleAccessContextManagerServicePerimeterIngressPolicy#method_selectors}
    */
    readonly methodSelectors?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsMethodSelectors[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsToTerraform(struct?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperations | cdktf.IResolvable): any;
export declare function googleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsToHclTerraform(struct?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperations | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperations | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperations | cdktf.IResolvable | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _methodSelectors;
    get methodSelectors(): GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsMethodSelectorsList;
    putMethodSelectors(value: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsMethodSelectors[] | cdktf.IResolvable): void;
    resetMethodSelectors(): void;
    get methodSelectorsInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsMethodSelectors[] | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterIngressPolicyIngressTo {
    /**
    * A list of resources, currently only projects in the form
    * 'projects/<projectnumber>', protected by this 'ServicePerimeter'
    * that are allowed to be accessed by sources defined in the
    * corresponding 'IngressFrom'. A request matches if it contains
    * a resource in this list. If '*' is specified for resources,
    * then this 'IngressTo' rule will authorize access to all
    * resources inside the perimeter, provided that the request
    * also matches the 'operations' field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#resources GoogleAccessContextManagerServicePerimeterIngressPolicy#resources}
    */
    readonly resources?: string[];
    /**
    * operations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#operations GoogleAccessContextManagerServicePerimeterIngressPolicy#operations}
    */
    readonly operations?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperations[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterIngressPolicyIngressToToTerraform(struct?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOutputReference | GoogleAccessContextManagerServicePerimeterIngressPolicyIngressTo): any;
export declare function googleAccessContextManagerServicePerimeterIngressPolicyIngressToToHclTerraform(struct?: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOutputReference | GoogleAccessContextManagerServicePerimeterIngressPolicyIngressTo): any;
export declare class GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterIngressPolicyIngressTo | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressTo | undefined);
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations;
    get operations(): GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperationsList;
    putOperations(value: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperations[] | cdktf.IResolvable): void;
    resetOperations(): void;
    get operationsInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOperations[] | undefined;
}
export interface GoogleAccessContextManagerServicePerimeterIngressPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#create GoogleAccessContextManagerServicePerimeterIngressPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#delete GoogleAccessContextManagerServicePerimeterIngressPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#update GoogleAccessContextManagerServicePerimeterIngressPolicy#update}
    */
    readonly update?: string;
}
export declare function googleAccessContextManagerServicePerimeterIngressPolicyTimeoutsToTerraform(struct?: GoogleAccessContextManagerServicePerimeterIngressPolicyTimeouts | cdktf.IResolvable): any;
export declare function googleAccessContextManagerServicePerimeterIngressPolicyTimeoutsToHclTerraform(struct?: GoogleAccessContextManagerServicePerimeterIngressPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterIngressPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterIngressPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterIngressPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy google_access_context_manager_service_perimeter_ingress_policy}
*/
export declare class GoogleAccessContextManagerServicePerimeterIngressPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_access_context_manager_service_perimeter_ingress_policy";
    /**
    * Generates CDKTF code for importing a GoogleAccessContextManagerServicePerimeterIngressPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleAccessContextManagerServicePerimeterIngressPolicy to import
    * @param importFromId The id of the existing GoogleAccessContextManagerServicePerimeterIngressPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleAccessContextManagerServicePerimeterIngressPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_access_context_manager_service_perimeter_ingress_policy google_access_context_manager_service_perimeter_ingress_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAccessContextManagerServicePerimeterIngressPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAccessContextManagerServicePerimeterIngressPolicyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _perimeter?;
    get perimeter(): string;
    set perimeter(value: string);
    get perimeterInput(): string | undefined;
    private _ingressFrom;
    get ingressFrom(): GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFromOutputReference;
    putIngressFrom(value: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFrom): void;
    resetIngressFrom(): void;
    get ingressFromInput(): GoogleAccessContextManagerServicePerimeterIngressPolicyIngressFrom | undefined;
    private _ingressTo;
    get ingressTo(): GoogleAccessContextManagerServicePerimeterIngressPolicyIngressToOutputReference;
    putIngressTo(value: GoogleAccessContextManagerServicePerimeterIngressPolicyIngressTo): void;
    resetIngressTo(): void;
    get ingressToInput(): GoogleAccessContextManagerServicePerimeterIngressPolicyIngressTo | undefined;
    private _timeouts;
    get timeouts(): GoogleAccessContextManagerServicePerimeterIngressPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleAccessContextManagerServicePerimeterIngressPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterIngressPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
