/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleActiveDirectoryDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of delegated administrator account used to perform Active Directory operations.
    * If not specified, setupadmin will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_active_directory_domain#admin GoogleActiveDirectoryDomain#admin}
    */
    readonly admin?: string;
    /**
    * The full names of the Google Compute Engine networks the domain instance is connected to. The domain is only available on networks listed in authorizedNetworks.
    * If CIDR subnets overlap between networks, domain creation will fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_active_directory_domain#authorized_networks GoogleActiveDirectoryDomain#authorized_networks}
    */
    readonly authorizedNetworks?: string[];
    /**
    * The fully qualified domain name. e.g. mydomain.myorganization.com, with the restrictions,
    * https://cloud.google.com/managed-microsoft-ad/reference/rest/v1/projects.locations.global.domains.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_active_directory_domain#domain_name GoogleActiveDirectoryDomain#domain_name}
    */
    readonly domainName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_active_directory_domain#id GoogleActiveDirectoryDomain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource labels that can contain user-provided metadata
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_active_directory_domain#labels GoogleActiveDirectoryDomain#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Locations where domain needs to be provisioned. [regions][compute/docs/regions-zones/]
    * e.g. us-west1 or us-east4 Service supports up to 4 locations at once. Each location will use a /26 block.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_active_directory_domain#locations GoogleActiveDirectoryDomain#locations}
    */
    readonly locations: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_active_directory_domain#project GoogleActiveDirectoryDomain#project}
    */
    readonly project?: string;
    /**
    * The CIDR range of internal addresses that are reserved for this domain. Reserved networks must be /24 or larger.
    * Ranges must be unique and non-overlapping with existing subnets in authorizedNetworks
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_active_directory_domain#reserved_ip_range GoogleActiveDirectoryDomain#reserved_ip_range}
    */
    readonly reservedIpRange: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_active_directory_domain#timeouts GoogleActiveDirectoryDomain#timeouts}
    */
    readonly timeouts?: GoogleActiveDirectoryDomainTimeouts;
}
export interface GoogleActiveDirectoryDomainTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_active_directory_domain#create GoogleActiveDirectoryDomain#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_active_directory_domain#delete GoogleActiveDirectoryDomain#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_active_directory_domain#update GoogleActiveDirectoryDomain#update}
    */
    readonly update?: string;
}
export declare function googleActiveDirectoryDomainTimeoutsToTerraform(struct?: GoogleActiveDirectoryDomainTimeouts | cdktf.IResolvable): any;
export declare function googleActiveDirectoryDomainTimeoutsToHclTerraform(struct?: GoogleActiveDirectoryDomainTimeouts | cdktf.IResolvable): any;
export declare class GoogleActiveDirectoryDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleActiveDirectoryDomainTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleActiveDirectoryDomainTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_active_directory_domain google_active_directory_domain}
*/
export declare class GoogleActiveDirectoryDomain extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_active_directory_domain";
    /**
    * Generates CDKTF code for importing a GoogleActiveDirectoryDomain resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleActiveDirectoryDomain to import
    * @param importFromId The id of the existing GoogleActiveDirectoryDomain that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_active_directory_domain#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleActiveDirectoryDomain to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_active_directory_domain google_active_directory_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleActiveDirectoryDomainConfig
    */
    constructor(scope: Construct, id: string, config: GoogleActiveDirectoryDomainConfig);
    private _admin?;
    get admin(): string;
    set admin(value: string);
    resetAdmin(): void;
    get adminInput(): string | undefined;
    private _authorizedNetworks?;
    get authorizedNetworks(): string[];
    set authorizedNetworks(value: string[]);
    resetAuthorizedNetworks(): void;
    get authorizedNetworksInput(): string[] | undefined;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get fqdn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _locations?;
    get locations(): string[];
    set locations(value: string[]);
    get locationsInput(): string[] | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _reservedIpRange?;
    get reservedIpRange(): string;
    set reservedIpRange(value: string);
    get reservedIpRangeInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): GoogleActiveDirectoryDomainTimeoutsOutputReference;
    putTimeouts(value: GoogleActiveDirectoryDomainTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleActiveDirectoryDomainTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
