/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAlloydbBackupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels. https://google.aip.dev/128
    * An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#annotations GoogleAlloydbBackup#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * The ID of the alloydb backup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#backup_id GoogleAlloydbBackup#backup_id}
    */
    readonly backupId: string;
    /**
    * The full resource name of the backup source cluster (e.g., projects/{project}/locations/{location}/clusters/{clusterId}).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#cluster_name GoogleAlloydbBackup#cluster_name}
    */
    readonly clusterName: string;
    /**
    * User-provided description of the backup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#description GoogleAlloydbBackup#description}
    */
    readonly description?: string;
    /**
    * User-settable and human-readable display name for the Backup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#display_name GoogleAlloydbBackup#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#id GoogleAlloydbBackup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-defined labels for the alloydb backup. An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#labels GoogleAlloydbBackup#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the alloydb backup should reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#location GoogleAlloydbBackup#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#project GoogleAlloydbBackup#project}
    */
    readonly project?: string;
    /**
    * The backup type, which suggests the trigger for the backup. Possible values: ["TYPE_UNSPECIFIED", "ON_DEMAND", "AUTOMATED", "CONTINUOUS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#type GoogleAlloydbBackup#type}
    */
    readonly type?: string;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#encryption_config GoogleAlloydbBackup#encryption_config}
    */
    readonly encryptionConfig?: GoogleAlloydbBackupEncryptionConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#timeouts GoogleAlloydbBackup#timeouts}
    */
    readonly timeouts?: GoogleAlloydbBackupTimeouts;
}
export interface GoogleAlloydbBackupEncryptionInfo {
}
export declare function googleAlloydbBackupEncryptionInfoToTerraform(struct?: GoogleAlloydbBackupEncryptionInfo): any;
export declare function googleAlloydbBackupEncryptionInfoToHclTerraform(struct?: GoogleAlloydbBackupEncryptionInfo): any;
export declare class GoogleAlloydbBackupEncryptionInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAlloydbBackupEncryptionInfo | undefined;
    set internalValue(value: GoogleAlloydbBackupEncryptionInfo | undefined);
    get encryptionType(): string;
    get kmsKeyVersions(): string[];
}
export declare class GoogleAlloydbBackupEncryptionInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAlloydbBackupEncryptionInfoOutputReference;
}
export interface GoogleAlloydbBackupExpiryQuantity {
}
export declare function googleAlloydbBackupExpiryQuantityToTerraform(struct?: GoogleAlloydbBackupExpiryQuantity): any;
export declare function googleAlloydbBackupExpiryQuantityToHclTerraform(struct?: GoogleAlloydbBackupExpiryQuantity): any;
export declare class GoogleAlloydbBackupExpiryQuantityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAlloydbBackupExpiryQuantity | undefined;
    set internalValue(value: GoogleAlloydbBackupExpiryQuantity | undefined);
    get retentionCount(): number;
    get totalRetentionCount(): number;
}
export declare class GoogleAlloydbBackupExpiryQuantityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAlloydbBackupExpiryQuantityOutputReference;
}
export interface GoogleAlloydbBackupEncryptionConfig {
    /**
    * The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#kms_key_name GoogleAlloydbBackup#kms_key_name}
    */
    readonly kmsKeyName?: string;
}
export declare function googleAlloydbBackupEncryptionConfigToTerraform(struct?: GoogleAlloydbBackupEncryptionConfigOutputReference | GoogleAlloydbBackupEncryptionConfig): any;
export declare function googleAlloydbBackupEncryptionConfigToHclTerraform(struct?: GoogleAlloydbBackupEncryptionConfigOutputReference | GoogleAlloydbBackupEncryptionConfig): any;
export declare class GoogleAlloydbBackupEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbBackupEncryptionConfig | undefined;
    set internalValue(value: GoogleAlloydbBackupEncryptionConfig | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
}
export interface GoogleAlloydbBackupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#create GoogleAlloydbBackup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#delete GoogleAlloydbBackup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#update GoogleAlloydbBackup#update}
    */
    readonly update?: string;
}
export declare function googleAlloydbBackupTimeoutsToTerraform(struct?: GoogleAlloydbBackupTimeouts | cdktf.IResolvable): any;
export declare function googleAlloydbBackupTimeoutsToHclTerraform(struct?: GoogleAlloydbBackupTimeouts | cdktf.IResolvable): any;
export declare class GoogleAlloydbBackupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbBackupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAlloydbBackupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup google_alloydb_backup}
*/
export declare class GoogleAlloydbBackup extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_alloydb_backup";
    /**
    * Generates CDKTF code for importing a GoogleAlloydbBackup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleAlloydbBackup to import
    * @param importFromId The id of the existing GoogleAlloydbBackup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleAlloydbBackup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_backup google_alloydb_backup} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAlloydbBackupConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAlloydbBackupConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _backupId?;
    get backupId(): string;
    set backupId(value: string);
    get backupIdInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    get clusterUid(): string;
    get createTime(): string;
    get deleteTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _encryptionInfo;
    get encryptionInfo(): GoogleAlloydbBackupEncryptionInfoList;
    get etag(): string;
    private _expiryQuantity;
    get expiryQuantity(): GoogleAlloydbBackupExpiryQuantityList;
    get expiryTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get sizeBytes(): string;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get uid(): string;
    get updateTime(): string;
    private _encryptionConfig;
    get encryptionConfig(): GoogleAlloydbBackupEncryptionConfigOutputReference;
    putEncryptionConfig(value: GoogleAlloydbBackupEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): GoogleAlloydbBackupEncryptionConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleAlloydbBackupTimeoutsOutputReference;
    putTimeouts(value: GoogleAlloydbBackupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAlloydbBackupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
