/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAlloydbClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels. https://google.aip.dev/128
    * An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#annotations GoogleAlloydbCluster#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * The ID of the alloydb cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#cluster_id GoogleAlloydbCluster#cluster_id}
    */
    readonly clusterId: string;
    /**
    * The type of cluster. If not set, defaults to PRIMARY. Default value: "PRIMARY" Possible values: ["PRIMARY", "SECONDARY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#cluster_type GoogleAlloydbCluster#cluster_type}
    */
    readonly clusterType?: string;
    /**
    * The database engine major version. This is an optional field and it's populated at the Cluster creation time. This field cannot be changed after cluster creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#database_version GoogleAlloydbCluster#database_version}
    */
    readonly databaseVersion?: string;
    /**
    * Policy to determine if the cluster should be deleted forcefully.
    * Deleting a cluster forcefully, deletes the cluster and all its associated instances within the cluster.
    * Deleting a Secondary cluster with a secondary instance REQUIRES setting deletion_policy = "FORCE" otherwise an error is returned. This is needed as there is no support to delete just the secondary instance, and the only way to delete secondary instance is to delete the associated secondary cluster forcefully which also deletes the secondary instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#deletion_policy GoogleAlloydbCluster#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * User-settable and human-readable display name for the Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#display_name GoogleAlloydbCluster#display_name}
    */
    readonly displayName?: string;
    /**
    * For Resource freshness validation (https://google.aip.dev/154)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#etag GoogleAlloydbCluster#etag}
    */
    readonly etag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#id GoogleAlloydbCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-defined labels for the alloydb cluster.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#labels GoogleAlloydbCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the alloydb cluster should reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#location GoogleAlloydbCluster#location}
    */
    readonly location: string;
    /**
    * The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
    *
    * "projects/{projectNumber}/global/networks/{network_id}".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#network GoogleAlloydbCluster#network}
    */
    readonly network?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#project GoogleAlloydbCluster#project}
    */
    readonly project?: string;
    /**
    * automated_backup_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#automated_backup_policy GoogleAlloydbCluster#automated_backup_policy}
    */
    readonly automatedBackupPolicy?: GoogleAlloydbClusterAutomatedBackupPolicy;
    /**
    * continuous_backup_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#continuous_backup_config GoogleAlloydbCluster#continuous_backup_config}
    */
    readonly continuousBackupConfig?: GoogleAlloydbClusterContinuousBackupConfig;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#encryption_config GoogleAlloydbCluster#encryption_config}
    */
    readonly encryptionConfig?: GoogleAlloydbClusterEncryptionConfig;
    /**
    * initial_user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#initial_user GoogleAlloydbCluster#initial_user}
    */
    readonly initialUser?: GoogleAlloydbClusterInitialUser;
    /**
    * network_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#network_config GoogleAlloydbCluster#network_config}
    */
    readonly networkConfig?: GoogleAlloydbClusterNetworkConfig;
    /**
    * restore_backup_source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#restore_backup_source GoogleAlloydbCluster#restore_backup_source}
    */
    readonly restoreBackupSource?: GoogleAlloydbClusterRestoreBackupSource;
    /**
    * restore_continuous_backup_source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#restore_continuous_backup_source GoogleAlloydbCluster#restore_continuous_backup_source}
    */
    readonly restoreContinuousBackupSource?: GoogleAlloydbClusterRestoreContinuousBackupSource;
    /**
    * secondary_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#secondary_config GoogleAlloydbCluster#secondary_config}
    */
    readonly secondaryConfig?: GoogleAlloydbClusterSecondaryConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#timeouts GoogleAlloydbCluster#timeouts}
    */
    readonly timeouts?: GoogleAlloydbClusterTimeouts;
}
export interface GoogleAlloydbClusterBackupSource {
}
export declare function googleAlloydbClusterBackupSourceToTerraform(struct?: GoogleAlloydbClusterBackupSource): any;
export declare function googleAlloydbClusterBackupSourceToHclTerraform(struct?: GoogleAlloydbClusterBackupSource): any;
export declare class GoogleAlloydbClusterBackupSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAlloydbClusterBackupSource | undefined;
    set internalValue(value: GoogleAlloydbClusterBackupSource | undefined);
    get backupName(): string;
}
export declare class GoogleAlloydbClusterBackupSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAlloydbClusterBackupSourceOutputReference;
}
export interface GoogleAlloydbClusterContinuousBackupInfoEncryptionInfo {
}
export declare function googleAlloydbClusterContinuousBackupInfoEncryptionInfoToTerraform(struct?: GoogleAlloydbClusterContinuousBackupInfoEncryptionInfo): any;
export declare function googleAlloydbClusterContinuousBackupInfoEncryptionInfoToHclTerraform(struct?: GoogleAlloydbClusterContinuousBackupInfoEncryptionInfo): any;
export declare class GoogleAlloydbClusterContinuousBackupInfoEncryptionInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAlloydbClusterContinuousBackupInfoEncryptionInfo | undefined;
    set internalValue(value: GoogleAlloydbClusterContinuousBackupInfoEncryptionInfo | undefined);
    get encryptionType(): string;
    get kmsKeyVersions(): string[];
}
export declare class GoogleAlloydbClusterContinuousBackupInfoEncryptionInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAlloydbClusterContinuousBackupInfoEncryptionInfoOutputReference;
}
export interface GoogleAlloydbClusterContinuousBackupInfo {
}
export declare function googleAlloydbClusterContinuousBackupInfoToTerraform(struct?: GoogleAlloydbClusterContinuousBackupInfo): any;
export declare function googleAlloydbClusterContinuousBackupInfoToHclTerraform(struct?: GoogleAlloydbClusterContinuousBackupInfo): any;
export declare class GoogleAlloydbClusterContinuousBackupInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAlloydbClusterContinuousBackupInfo | undefined;
    set internalValue(value: GoogleAlloydbClusterContinuousBackupInfo | undefined);
    get earliestRestorableTime(): string;
    get enabledTime(): string;
    private _encryptionInfo;
    get encryptionInfo(): GoogleAlloydbClusterContinuousBackupInfoEncryptionInfoList;
    get schedule(): string[];
}
export declare class GoogleAlloydbClusterContinuousBackupInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAlloydbClusterContinuousBackupInfoOutputReference;
}
export interface GoogleAlloydbClusterEncryptionInfo {
}
export declare function googleAlloydbClusterEncryptionInfoToTerraform(struct?: GoogleAlloydbClusterEncryptionInfo): any;
export declare function googleAlloydbClusterEncryptionInfoToHclTerraform(struct?: GoogleAlloydbClusterEncryptionInfo): any;
export declare class GoogleAlloydbClusterEncryptionInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAlloydbClusterEncryptionInfo | undefined;
    set internalValue(value: GoogleAlloydbClusterEncryptionInfo | undefined);
    get encryptionType(): string;
    get kmsKeyVersions(): string[];
}
export declare class GoogleAlloydbClusterEncryptionInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAlloydbClusterEncryptionInfoOutputReference;
}
export interface GoogleAlloydbClusterMigrationSource {
}
export declare function googleAlloydbClusterMigrationSourceToTerraform(struct?: GoogleAlloydbClusterMigrationSource): any;
export declare function googleAlloydbClusterMigrationSourceToHclTerraform(struct?: GoogleAlloydbClusterMigrationSource): any;
export declare class GoogleAlloydbClusterMigrationSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAlloydbClusterMigrationSource | undefined;
    set internalValue(value: GoogleAlloydbClusterMigrationSource | undefined);
    get hostPort(): string;
    get referenceId(): string;
    get sourceType(): string;
}
export declare class GoogleAlloydbClusterMigrationSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAlloydbClusterMigrationSourceOutputReference;
}
export interface GoogleAlloydbClusterAutomatedBackupPolicyEncryptionConfig {
    /**
    * The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#kms_key_name GoogleAlloydbCluster#kms_key_name}
    */
    readonly kmsKeyName?: string;
}
export declare function googleAlloydbClusterAutomatedBackupPolicyEncryptionConfigToTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyEncryptionConfigOutputReference | GoogleAlloydbClusterAutomatedBackupPolicyEncryptionConfig): any;
export declare function googleAlloydbClusterAutomatedBackupPolicyEncryptionConfigToHclTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyEncryptionConfigOutputReference | GoogleAlloydbClusterAutomatedBackupPolicyEncryptionConfig): any;
export declare class GoogleAlloydbClusterAutomatedBackupPolicyEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterAutomatedBackupPolicyEncryptionConfig | undefined;
    set internalValue(value: GoogleAlloydbClusterAutomatedBackupPolicyEncryptionConfig | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
}
export interface GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetention {
    /**
    * The number of backups to retain.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#count GoogleAlloydbCluster#count}
    */
    readonly count?: number;
}
export declare function googleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetentionToTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetentionOutputReference | GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetention): any;
export declare function googleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetentionToHclTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetentionOutputReference | GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetention): any;
export declare class GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetentionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetention | undefined;
    set internalValue(value: GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetention | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
}
export interface GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetention {
    /**
    * The retention period.
    * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#retention_period GoogleAlloydbCluster#retention_period}
    */
    readonly retentionPeriod?: string;
}
export declare function googleAlloydbClusterAutomatedBackupPolicyTimeBasedRetentionToTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetentionOutputReference | GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetention): any;
export declare function googleAlloydbClusterAutomatedBackupPolicyTimeBasedRetentionToHclTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetentionOutputReference | GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetention): any;
export declare class GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetentionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetention | undefined;
    set internalValue(value: GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetention | undefined);
    private _retentionPeriod?;
    get retentionPeriod(): string;
    set retentionPeriod(value: string);
    resetRetentionPeriod(): void;
    get retentionPeriodInput(): string | undefined;
}
export interface GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes {
    /**
    * Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#hours GoogleAlloydbCluster#hours}
    */
    readonly hours?: number;
    /**
    * Minutes of hour of day. Currently, only the value 0 is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#minutes GoogleAlloydbCluster#minutes}
    */
    readonly minutes?: number;
    /**
    * Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#nanos GoogleAlloydbCluster#nanos}
    */
    readonly nanos?: number;
    /**
    * Seconds of minutes of the time. Currently, only the value 0 is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#seconds GoogleAlloydbCluster#seconds}
    */
    readonly seconds?: number;
}
export declare function googleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimesToTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes | cdktf.IResolvable): any;
export declare function googleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimesToHclTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes | cdktf.IResolvable): any;
export declare class GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes | cdktf.IResolvable | undefined);
    private _hours?;
    get hours(): number;
    set hours(value: number);
    resetHours(): void;
    get hoursInput(): number | undefined;
    private _minutes?;
    get minutes(): number;
    set minutes(value: number);
    resetMinutes(): void;
    get minutesInput(): number | undefined;
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    resetSeconds(): void;
    get secondsInput(): number | undefined;
}
export declare class GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimesOutputReference;
}
export interface GoogleAlloydbClusterAutomatedBackupPolicyWeeklySchedule {
    /**
    * The days of the week to perform a backup. At least one day of the week must be provided. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#days_of_week GoogleAlloydbCluster#days_of_week}
    */
    readonly daysOfWeek?: string[];
    /**
    * start_times block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#start_times GoogleAlloydbCluster#start_times}
    */
    readonly startTimes: GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes[] | cdktf.IResolvable;
}
export declare function googleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleToTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleOutputReference | GoogleAlloydbClusterAutomatedBackupPolicyWeeklySchedule): any;
export declare function googleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleToHclTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleOutputReference | GoogleAlloydbClusterAutomatedBackupPolicyWeeklySchedule): any;
export declare class GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterAutomatedBackupPolicyWeeklySchedule | undefined;
    set internalValue(value: GoogleAlloydbClusterAutomatedBackupPolicyWeeklySchedule | undefined);
    private _daysOfWeek?;
    get daysOfWeek(): string[];
    set daysOfWeek(value: string[]);
    resetDaysOfWeek(): void;
    get daysOfWeekInput(): string[] | undefined;
    private _startTimes;
    get startTimes(): GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimesList;
    putStartTimes(value: GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes[] | cdktf.IResolvable): void;
    get startTimesInput(): cdktf.IResolvable | GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes[] | undefined;
}
export interface GoogleAlloydbClusterAutomatedBackupPolicy {
    /**
    * The length of the time window during which a backup can be taken. If a backup does not succeed within this time window, it will be canceled and considered failed.
    *
    * The backup window must be at least 5 minutes long. There is no upper bound on the window. If not set, it will default to 1 hour.
    *
    * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#backup_window GoogleAlloydbCluster#backup_window}
    */
    readonly backupWindow?: string;
    /**
    * Whether automated backups are enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#enabled GoogleAlloydbCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Labels to apply to backups created using this configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#labels GoogleAlloydbCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#location GoogleAlloydbCluster#location}
    */
    readonly location?: string;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#encryption_config GoogleAlloydbCluster#encryption_config}
    */
    readonly encryptionConfig?: GoogleAlloydbClusterAutomatedBackupPolicyEncryptionConfig;
    /**
    * quantity_based_retention block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#quantity_based_retention GoogleAlloydbCluster#quantity_based_retention}
    */
    readonly quantityBasedRetention?: GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetention;
    /**
    * time_based_retention block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#time_based_retention GoogleAlloydbCluster#time_based_retention}
    */
    readonly timeBasedRetention?: GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetention;
    /**
    * weekly_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#weekly_schedule GoogleAlloydbCluster#weekly_schedule}
    */
    readonly weeklySchedule?: GoogleAlloydbClusterAutomatedBackupPolicyWeeklySchedule;
}
export declare function googleAlloydbClusterAutomatedBackupPolicyToTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyOutputReference | GoogleAlloydbClusterAutomatedBackupPolicy): any;
export declare function googleAlloydbClusterAutomatedBackupPolicyToHclTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyOutputReference | GoogleAlloydbClusterAutomatedBackupPolicy): any;
export declare class GoogleAlloydbClusterAutomatedBackupPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterAutomatedBackupPolicy | undefined;
    set internalValue(value: GoogleAlloydbClusterAutomatedBackupPolicy | undefined);
    private _backupWindow?;
    get backupWindow(): string;
    set backupWindow(value: string);
    resetBackupWindow(): void;
    get backupWindowInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _encryptionConfig;
    get encryptionConfig(): GoogleAlloydbClusterAutomatedBackupPolicyEncryptionConfigOutputReference;
    putEncryptionConfig(value: GoogleAlloydbClusterAutomatedBackupPolicyEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): GoogleAlloydbClusterAutomatedBackupPolicyEncryptionConfig | undefined;
    private _quantityBasedRetention;
    get quantityBasedRetention(): GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetentionOutputReference;
    putQuantityBasedRetention(value: GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetention): void;
    resetQuantityBasedRetention(): void;
    get quantityBasedRetentionInput(): GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetention | undefined;
    private _timeBasedRetention;
    get timeBasedRetention(): GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetentionOutputReference;
    putTimeBasedRetention(value: GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetention): void;
    resetTimeBasedRetention(): void;
    get timeBasedRetentionInput(): GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetention | undefined;
    private _weeklySchedule;
    get weeklySchedule(): GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleOutputReference;
    putWeeklySchedule(value: GoogleAlloydbClusterAutomatedBackupPolicyWeeklySchedule): void;
    resetWeeklySchedule(): void;
    get weeklyScheduleInput(): GoogleAlloydbClusterAutomatedBackupPolicyWeeklySchedule | undefined;
}
export interface GoogleAlloydbClusterContinuousBackupConfigEncryptionConfig {
    /**
    * The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#kms_key_name GoogleAlloydbCluster#kms_key_name}
    */
    readonly kmsKeyName?: string;
}
export declare function googleAlloydbClusterContinuousBackupConfigEncryptionConfigToTerraform(struct?: GoogleAlloydbClusterContinuousBackupConfigEncryptionConfigOutputReference | GoogleAlloydbClusterContinuousBackupConfigEncryptionConfig): any;
export declare function googleAlloydbClusterContinuousBackupConfigEncryptionConfigToHclTerraform(struct?: GoogleAlloydbClusterContinuousBackupConfigEncryptionConfigOutputReference | GoogleAlloydbClusterContinuousBackupConfigEncryptionConfig): any;
export declare class GoogleAlloydbClusterContinuousBackupConfigEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterContinuousBackupConfigEncryptionConfig | undefined;
    set internalValue(value: GoogleAlloydbClusterContinuousBackupConfigEncryptionConfig | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
}
export interface GoogleAlloydbClusterContinuousBackupConfig {
    /**
    * Whether continuous backup recovery is enabled. If not set, defaults to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#enabled GoogleAlloydbCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The numbers of days that are eligible to restore from using PITR. To support the entire recovery window, backups and logs are retained for one day more than the recovery window.
    *
    * If not set, defaults to 14 days.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#recovery_window_days GoogleAlloydbCluster#recovery_window_days}
    */
    readonly recoveryWindowDays?: number;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#encryption_config GoogleAlloydbCluster#encryption_config}
    */
    readonly encryptionConfig?: GoogleAlloydbClusterContinuousBackupConfigEncryptionConfig;
}
export declare function googleAlloydbClusterContinuousBackupConfigToTerraform(struct?: GoogleAlloydbClusterContinuousBackupConfigOutputReference | GoogleAlloydbClusterContinuousBackupConfig): any;
export declare function googleAlloydbClusterContinuousBackupConfigToHclTerraform(struct?: GoogleAlloydbClusterContinuousBackupConfigOutputReference | GoogleAlloydbClusterContinuousBackupConfig): any;
export declare class GoogleAlloydbClusterContinuousBackupConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterContinuousBackupConfig | undefined;
    set internalValue(value: GoogleAlloydbClusterContinuousBackupConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _recoveryWindowDays?;
    get recoveryWindowDays(): number;
    set recoveryWindowDays(value: number);
    resetRecoveryWindowDays(): void;
    get recoveryWindowDaysInput(): number | undefined;
    private _encryptionConfig;
    get encryptionConfig(): GoogleAlloydbClusterContinuousBackupConfigEncryptionConfigOutputReference;
    putEncryptionConfig(value: GoogleAlloydbClusterContinuousBackupConfigEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): GoogleAlloydbClusterContinuousBackupConfigEncryptionConfig | undefined;
}
export interface GoogleAlloydbClusterEncryptionConfig {
    /**
    * The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#kms_key_name GoogleAlloydbCluster#kms_key_name}
    */
    readonly kmsKeyName?: string;
}
export declare function googleAlloydbClusterEncryptionConfigToTerraform(struct?: GoogleAlloydbClusterEncryptionConfigOutputReference | GoogleAlloydbClusterEncryptionConfig): any;
export declare function googleAlloydbClusterEncryptionConfigToHclTerraform(struct?: GoogleAlloydbClusterEncryptionConfigOutputReference | GoogleAlloydbClusterEncryptionConfig): any;
export declare class GoogleAlloydbClusterEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterEncryptionConfig | undefined;
    set internalValue(value: GoogleAlloydbClusterEncryptionConfig | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
}
export interface GoogleAlloydbClusterInitialUser {
    /**
    * The initial password for the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#password GoogleAlloydbCluster#password}
    */
    readonly password: string;
    /**
    * The database username.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#user GoogleAlloydbCluster#user}
    */
    readonly user?: string;
}
export declare function googleAlloydbClusterInitialUserToTerraform(struct?: GoogleAlloydbClusterInitialUserOutputReference | GoogleAlloydbClusterInitialUser): any;
export declare function googleAlloydbClusterInitialUserToHclTerraform(struct?: GoogleAlloydbClusterInitialUserOutputReference | GoogleAlloydbClusterInitialUser): any;
export declare class GoogleAlloydbClusterInitialUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterInitialUser | undefined;
    set internalValue(value: GoogleAlloydbClusterInitialUser | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
}
export interface GoogleAlloydbClusterNetworkConfig {
    /**
    * The name of the allocated IP range for the private IP AlloyDB cluster. For example: "google-managed-services-default".
    * If set, the instance IPs for this cluster will be created in the allocated range.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#allocated_ip_range GoogleAlloydbCluster#allocated_ip_range}
    */
    readonly allocatedIpRange?: string;
    /**
    * The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
    * It is specified in the form: "projects/{projectNumber}/global/networks/{network_id}".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#network GoogleAlloydbCluster#network}
    */
    readonly network?: string;
}
export declare function googleAlloydbClusterNetworkConfigToTerraform(struct?: GoogleAlloydbClusterNetworkConfigOutputReference | GoogleAlloydbClusterNetworkConfig): any;
export declare function googleAlloydbClusterNetworkConfigToHclTerraform(struct?: GoogleAlloydbClusterNetworkConfigOutputReference | GoogleAlloydbClusterNetworkConfig): any;
export declare class GoogleAlloydbClusterNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterNetworkConfig | undefined;
    set internalValue(value: GoogleAlloydbClusterNetworkConfig | undefined);
    private _allocatedIpRange?;
    get allocatedIpRange(): string;
    set allocatedIpRange(value: string);
    resetAllocatedIpRange(): void;
    get allocatedIpRangeInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
}
export interface GoogleAlloydbClusterRestoreBackupSource {
    /**
    * The name of the backup that this cluster is restored from.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#backup_name GoogleAlloydbCluster#backup_name}
    */
    readonly backupName: string;
}
export declare function googleAlloydbClusterRestoreBackupSourceToTerraform(struct?: GoogleAlloydbClusterRestoreBackupSourceOutputReference | GoogleAlloydbClusterRestoreBackupSource): any;
export declare function googleAlloydbClusterRestoreBackupSourceToHclTerraform(struct?: GoogleAlloydbClusterRestoreBackupSourceOutputReference | GoogleAlloydbClusterRestoreBackupSource): any;
export declare class GoogleAlloydbClusterRestoreBackupSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterRestoreBackupSource | undefined;
    set internalValue(value: GoogleAlloydbClusterRestoreBackupSource | undefined);
    private _backupName?;
    get backupName(): string;
    set backupName(value: string);
    get backupNameInput(): string | undefined;
}
export interface GoogleAlloydbClusterRestoreContinuousBackupSource {
    /**
    * The name of the source cluster that this cluster is restored from.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#cluster GoogleAlloydbCluster#cluster}
    */
    readonly cluster: string;
    /**
    * The point in time that this cluster is restored to, in RFC 3339 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#point_in_time GoogleAlloydbCluster#point_in_time}
    */
    readonly pointInTime: string;
}
export declare function googleAlloydbClusterRestoreContinuousBackupSourceToTerraform(struct?: GoogleAlloydbClusterRestoreContinuousBackupSourceOutputReference | GoogleAlloydbClusterRestoreContinuousBackupSource): any;
export declare function googleAlloydbClusterRestoreContinuousBackupSourceToHclTerraform(struct?: GoogleAlloydbClusterRestoreContinuousBackupSourceOutputReference | GoogleAlloydbClusterRestoreContinuousBackupSource): any;
export declare class GoogleAlloydbClusterRestoreContinuousBackupSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterRestoreContinuousBackupSource | undefined;
    set internalValue(value: GoogleAlloydbClusterRestoreContinuousBackupSource | undefined);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    private _pointInTime?;
    get pointInTime(): string;
    set pointInTime(value: string);
    get pointInTimeInput(): string | undefined;
}
export interface GoogleAlloydbClusterSecondaryConfig {
    /**
    * Name of the primary cluster must be in the format
    * 'projects/{project}/locations/{location}/clusters/{cluster_id}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#primary_cluster_name GoogleAlloydbCluster#primary_cluster_name}
    */
    readonly primaryClusterName: string;
}
export declare function googleAlloydbClusterSecondaryConfigToTerraform(struct?: GoogleAlloydbClusterSecondaryConfigOutputReference | GoogleAlloydbClusterSecondaryConfig): any;
export declare function googleAlloydbClusterSecondaryConfigToHclTerraform(struct?: GoogleAlloydbClusterSecondaryConfigOutputReference | GoogleAlloydbClusterSecondaryConfig): any;
export declare class GoogleAlloydbClusterSecondaryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterSecondaryConfig | undefined;
    set internalValue(value: GoogleAlloydbClusterSecondaryConfig | undefined);
    private _primaryClusterName?;
    get primaryClusterName(): string;
    set primaryClusterName(value: string);
    get primaryClusterNameInput(): string | undefined;
}
export interface GoogleAlloydbClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#create GoogleAlloydbCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#delete GoogleAlloydbCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#update GoogleAlloydbCluster#update}
    */
    readonly update?: string;
}
export declare function googleAlloydbClusterTimeoutsToTerraform(struct?: GoogleAlloydbClusterTimeouts | cdktf.IResolvable): any;
export declare function googleAlloydbClusterTimeoutsToHclTerraform(struct?: GoogleAlloydbClusterTimeouts | cdktf.IResolvable): any;
export declare class GoogleAlloydbClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAlloydbClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster google_alloydb_cluster}
*/
export declare class GoogleAlloydbCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_alloydb_cluster";
    /**
    * Generates CDKTF code for importing a GoogleAlloydbCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleAlloydbCluster to import
    * @param importFromId The id of the existing GoogleAlloydbCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleAlloydbCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_cluster google_alloydb_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAlloydbClusterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAlloydbClusterConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _backupSource;
    get backupSource(): GoogleAlloydbClusterBackupSourceList;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _clusterType?;
    get clusterType(): string;
    set clusterType(value: string);
    resetClusterType(): void;
    get clusterTypeInput(): string | undefined;
    private _continuousBackupInfo;
    get continuousBackupInfo(): GoogleAlloydbClusterContinuousBackupInfoList;
    private _databaseVersion?;
    get databaseVersion(): string;
    set databaseVersion(value: string);
    resetDatabaseVersion(): void;
    get databaseVersionInput(): string | undefined;
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _encryptionInfo;
    get encryptionInfo(): GoogleAlloydbClusterEncryptionInfoList;
    private _etag?;
    get etag(): string;
    set etag(value: string);
    resetEtag(): void;
    get etagInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _migrationSource;
    get migrationSource(): GoogleAlloydbClusterMigrationSourceList;
    get name(): string;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get uid(): string;
    private _automatedBackupPolicy;
    get automatedBackupPolicy(): GoogleAlloydbClusterAutomatedBackupPolicyOutputReference;
    putAutomatedBackupPolicy(value: GoogleAlloydbClusterAutomatedBackupPolicy): void;
    resetAutomatedBackupPolicy(): void;
    get automatedBackupPolicyInput(): GoogleAlloydbClusterAutomatedBackupPolicy | undefined;
    private _continuousBackupConfig;
    get continuousBackupConfig(): GoogleAlloydbClusterContinuousBackupConfigOutputReference;
    putContinuousBackupConfig(value: GoogleAlloydbClusterContinuousBackupConfig): void;
    resetContinuousBackupConfig(): void;
    get continuousBackupConfigInput(): GoogleAlloydbClusterContinuousBackupConfig | undefined;
    private _encryptionConfig;
    get encryptionConfig(): GoogleAlloydbClusterEncryptionConfigOutputReference;
    putEncryptionConfig(value: GoogleAlloydbClusterEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): GoogleAlloydbClusterEncryptionConfig | undefined;
    private _initialUser;
    get initialUser(): GoogleAlloydbClusterInitialUserOutputReference;
    putInitialUser(value: GoogleAlloydbClusterInitialUser): void;
    resetInitialUser(): void;
    get initialUserInput(): GoogleAlloydbClusterInitialUser | undefined;
    private _networkConfig;
    get networkConfig(): GoogleAlloydbClusterNetworkConfigOutputReference;
    putNetworkConfig(value: GoogleAlloydbClusterNetworkConfig): void;
    resetNetworkConfig(): void;
    get networkConfigInput(): GoogleAlloydbClusterNetworkConfig | undefined;
    private _restoreBackupSource;
    get restoreBackupSource(): GoogleAlloydbClusterRestoreBackupSourceOutputReference;
    putRestoreBackupSource(value: GoogleAlloydbClusterRestoreBackupSource): void;
    resetRestoreBackupSource(): void;
    get restoreBackupSourceInput(): GoogleAlloydbClusterRestoreBackupSource | undefined;
    private _restoreContinuousBackupSource;
    get restoreContinuousBackupSource(): GoogleAlloydbClusterRestoreContinuousBackupSourceOutputReference;
    putRestoreContinuousBackupSource(value: GoogleAlloydbClusterRestoreContinuousBackupSource): void;
    resetRestoreContinuousBackupSource(): void;
    get restoreContinuousBackupSourceInput(): GoogleAlloydbClusterRestoreContinuousBackupSource | undefined;
    private _secondaryConfig;
    get secondaryConfig(): GoogleAlloydbClusterSecondaryConfigOutputReference;
    putSecondaryConfig(value: GoogleAlloydbClusterSecondaryConfig): void;
    resetSecondaryConfig(): void;
    get secondaryConfigInput(): GoogleAlloydbClusterSecondaryConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleAlloydbClusterTimeoutsOutputReference;
    putTimeouts(value: GoogleAlloydbClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAlloydbClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
