/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAlloydbInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#annotations GoogleAlloydbInstance#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * 'Availability type of an Instance. Defaults to REGIONAL for both primary and read instances.
    * Note that primary and read instances can have different availability types.
    * Only READ_POOL instance supports ZONAL type. Users can't specify the zone for READ_POOL instance.
    * Zone is automatically chosen from the list of zones in the region specified.
    * Read pool of size 1 can only have zonal availability. Read pools with node count of 2 or more
    * can have regional availability (nodes are present in 2 or more zones in a region).' Possible values: ["AVAILABILITY_TYPE_UNSPECIFIED", "ZONAL", "REGIONAL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#availability_type GoogleAlloydbInstance#availability_type}
    */
    readonly availabilityType?: string;
    /**
    * Identifies the alloydb cluster. Must be in the format
    * 'projects/{project}/locations/{location}/clusters/{cluster_id}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#cluster GoogleAlloydbInstance#cluster}
    */
    readonly cluster: string;
    /**
    * Database flags. Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#database_flags GoogleAlloydbInstance#database_flags}
    */
    readonly databaseFlags?: {
        [key: string]: string;
    };
    /**
    * User-settable and human-readable display name for the Instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#display_name GoogleAlloydbInstance#display_name}
    */
    readonly displayName?: string;
    /**
    * The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#gce_zone GoogleAlloydbInstance#gce_zone}
    */
    readonly gceZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#id GoogleAlloydbInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the alloydb instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#instance_id GoogleAlloydbInstance#instance_id}
    */
    readonly instanceId: string;
    /**
    * The type of the instance.
    * If the instance type is READ_POOL, provide the associated PRIMARY/SECONDARY instance in the 'depends_on' meta-data attribute.
    * If the instance type is SECONDARY, point to the cluster_type of the associated secondary cluster instead of mentioning SECONDARY.
    * Example: {instance_type = google_alloydb_cluster.<secondary_cluster_name>.cluster_type} instead of {instance_type = SECONDARY}
    * If the instance type is SECONDARY, the terraform delete instance operation does not delete the secondary instance but abandons it instead.
    * Use deletion_policy = "FORCE" in the associated secondary cluster and delete the cluster forcefully to delete the secondary cluster as well its associated secondary instance.
    * Users can undo the delete secondary instance action by importing the deleted secondary instance by calling terraform import. Possible values: ["PRIMARY", "READ_POOL", "SECONDARY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#instance_type GoogleAlloydbInstance#instance_type}
    */
    readonly instanceType: string;
    /**
    * User-defined labels for the alloydb instance.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#labels GoogleAlloydbInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * client_connection_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#client_connection_config GoogleAlloydbInstance#client_connection_config}
    */
    readonly clientConnectionConfig?: GoogleAlloydbInstanceClientConnectionConfig;
    /**
    * machine_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#machine_config GoogleAlloydbInstance#machine_config}
    */
    readonly machineConfig?: GoogleAlloydbInstanceMachineConfig;
    /**
    * query_insights_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#query_insights_config GoogleAlloydbInstance#query_insights_config}
    */
    readonly queryInsightsConfig?: GoogleAlloydbInstanceQueryInsightsConfig;
    /**
    * read_pool_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#read_pool_config GoogleAlloydbInstance#read_pool_config}
    */
    readonly readPoolConfig?: GoogleAlloydbInstanceReadPoolConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#timeouts GoogleAlloydbInstance#timeouts}
    */
    readonly timeouts?: GoogleAlloydbInstanceTimeouts;
}
export interface GoogleAlloydbInstanceClientConnectionConfigSslConfig {
    /**
    * SSL mode. Specifies client-server SSL/TLS connection behavior. Possible values: ["ENCRYPTED_ONLY", "ALLOW_UNENCRYPTED_AND_ENCRYPTED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#ssl_mode GoogleAlloydbInstance#ssl_mode}
    */
    readonly sslMode?: string;
}
export declare function googleAlloydbInstanceClientConnectionConfigSslConfigToTerraform(struct?: GoogleAlloydbInstanceClientConnectionConfigSslConfigOutputReference | GoogleAlloydbInstanceClientConnectionConfigSslConfig): any;
export declare function googleAlloydbInstanceClientConnectionConfigSslConfigToHclTerraform(struct?: GoogleAlloydbInstanceClientConnectionConfigSslConfigOutputReference | GoogleAlloydbInstanceClientConnectionConfigSslConfig): any;
export declare class GoogleAlloydbInstanceClientConnectionConfigSslConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbInstanceClientConnectionConfigSslConfig | undefined;
    set internalValue(value: GoogleAlloydbInstanceClientConnectionConfigSslConfig | undefined);
    private _sslMode?;
    get sslMode(): string;
    set sslMode(value: string);
    resetSslMode(): void;
    get sslModeInput(): string | undefined;
}
export interface GoogleAlloydbInstanceClientConnectionConfig {
    /**
    * Configuration to enforce connectors only (ex: AuthProxy) connections to the database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#require_connectors GoogleAlloydbInstance#require_connectors}
    */
    readonly requireConnectors?: boolean | cdktf.IResolvable;
    /**
    * ssl_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#ssl_config GoogleAlloydbInstance#ssl_config}
    */
    readonly sslConfig?: GoogleAlloydbInstanceClientConnectionConfigSslConfig;
}
export declare function googleAlloydbInstanceClientConnectionConfigToTerraform(struct?: GoogleAlloydbInstanceClientConnectionConfigOutputReference | GoogleAlloydbInstanceClientConnectionConfig): any;
export declare function googleAlloydbInstanceClientConnectionConfigToHclTerraform(struct?: GoogleAlloydbInstanceClientConnectionConfigOutputReference | GoogleAlloydbInstanceClientConnectionConfig): any;
export declare class GoogleAlloydbInstanceClientConnectionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbInstanceClientConnectionConfig | undefined;
    set internalValue(value: GoogleAlloydbInstanceClientConnectionConfig | undefined);
    private _requireConnectors?;
    get requireConnectors(): boolean | cdktf.IResolvable;
    set requireConnectors(value: boolean | cdktf.IResolvable);
    resetRequireConnectors(): void;
    get requireConnectorsInput(): boolean | cdktf.IResolvable | undefined;
    private _sslConfig;
    get sslConfig(): GoogleAlloydbInstanceClientConnectionConfigSslConfigOutputReference;
    putSslConfig(value: GoogleAlloydbInstanceClientConnectionConfigSslConfig): void;
    resetSslConfig(): void;
    get sslConfigInput(): GoogleAlloydbInstanceClientConnectionConfigSslConfig | undefined;
}
export interface GoogleAlloydbInstanceMachineConfig {
    /**
    * The number of CPU's in the VM instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#cpu_count GoogleAlloydbInstance#cpu_count}
    */
    readonly cpuCount?: number;
}
export declare function googleAlloydbInstanceMachineConfigToTerraform(struct?: GoogleAlloydbInstanceMachineConfigOutputReference | GoogleAlloydbInstanceMachineConfig): any;
export declare function googleAlloydbInstanceMachineConfigToHclTerraform(struct?: GoogleAlloydbInstanceMachineConfigOutputReference | GoogleAlloydbInstanceMachineConfig): any;
export declare class GoogleAlloydbInstanceMachineConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbInstanceMachineConfig | undefined;
    set internalValue(value: GoogleAlloydbInstanceMachineConfig | undefined);
    private _cpuCount?;
    get cpuCount(): number;
    set cpuCount(value: number);
    resetCpuCount(): void;
    get cpuCountInput(): number | undefined;
}
export interface GoogleAlloydbInstanceQueryInsightsConfig {
    /**
    * Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 20 is considered valid.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#query_plans_per_minute GoogleAlloydbInstance#query_plans_per_minute}
    */
    readonly queryPlansPerMinute?: number;
    /**
    * Query string length. The default value is 1024. Any integer between 256 and 4500 is considered valid.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#query_string_length GoogleAlloydbInstance#query_string_length}
    */
    readonly queryStringLength?: number;
    /**
    * Record application tags for an instance. This flag is turned "on" by default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#record_application_tags GoogleAlloydbInstance#record_application_tags}
    */
    readonly recordApplicationTags?: boolean | cdktf.IResolvable;
    /**
    * Record client address for an instance. Client address is PII information. This flag is turned "on" by default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#record_client_address GoogleAlloydbInstance#record_client_address}
    */
    readonly recordClientAddress?: boolean | cdktf.IResolvable;
}
export declare function googleAlloydbInstanceQueryInsightsConfigToTerraform(struct?: GoogleAlloydbInstanceQueryInsightsConfigOutputReference | GoogleAlloydbInstanceQueryInsightsConfig): any;
export declare function googleAlloydbInstanceQueryInsightsConfigToHclTerraform(struct?: GoogleAlloydbInstanceQueryInsightsConfigOutputReference | GoogleAlloydbInstanceQueryInsightsConfig): any;
export declare class GoogleAlloydbInstanceQueryInsightsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbInstanceQueryInsightsConfig | undefined;
    set internalValue(value: GoogleAlloydbInstanceQueryInsightsConfig | undefined);
    private _queryPlansPerMinute?;
    get queryPlansPerMinute(): number;
    set queryPlansPerMinute(value: number);
    resetQueryPlansPerMinute(): void;
    get queryPlansPerMinuteInput(): number | undefined;
    private _queryStringLength?;
    get queryStringLength(): number;
    set queryStringLength(value: number);
    resetQueryStringLength(): void;
    get queryStringLengthInput(): number | undefined;
    private _recordApplicationTags?;
    get recordApplicationTags(): boolean | cdktf.IResolvable;
    set recordApplicationTags(value: boolean | cdktf.IResolvable);
    resetRecordApplicationTags(): void;
    get recordApplicationTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _recordClientAddress?;
    get recordClientAddress(): boolean | cdktf.IResolvable;
    set recordClientAddress(value: boolean | cdktf.IResolvable);
    resetRecordClientAddress(): void;
    get recordClientAddressInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleAlloydbInstanceReadPoolConfig {
    /**
    * Read capacity, i.e. number of nodes in a read pool instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#node_count GoogleAlloydbInstance#node_count}
    */
    readonly nodeCount?: number;
}
export declare function googleAlloydbInstanceReadPoolConfigToTerraform(struct?: GoogleAlloydbInstanceReadPoolConfigOutputReference | GoogleAlloydbInstanceReadPoolConfig): any;
export declare function googleAlloydbInstanceReadPoolConfigToHclTerraform(struct?: GoogleAlloydbInstanceReadPoolConfigOutputReference | GoogleAlloydbInstanceReadPoolConfig): any;
export declare class GoogleAlloydbInstanceReadPoolConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbInstanceReadPoolConfig | undefined;
    set internalValue(value: GoogleAlloydbInstanceReadPoolConfig | undefined);
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
}
export interface GoogleAlloydbInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#create GoogleAlloydbInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#delete GoogleAlloydbInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#update GoogleAlloydbInstance#update}
    */
    readonly update?: string;
}
export declare function googleAlloydbInstanceTimeoutsToTerraform(struct?: GoogleAlloydbInstanceTimeouts | cdktf.IResolvable): any;
export declare function googleAlloydbInstanceTimeoutsToHclTerraform(struct?: GoogleAlloydbInstanceTimeouts | cdktf.IResolvable): any;
export declare class GoogleAlloydbInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAlloydbInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance google_alloydb_instance}
*/
export declare class GoogleAlloydbInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_alloydb_instance";
    /**
    * Generates CDKTF code for importing a GoogleAlloydbInstance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleAlloydbInstance to import
    * @param importFromId The id of the existing GoogleAlloydbInstance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleAlloydbInstance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_instance google_alloydb_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAlloydbInstanceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAlloydbInstanceConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _availabilityType?;
    get availabilityType(): string;
    set availabilityType(value: string);
    resetAvailabilityType(): void;
    get availabilityTypeInput(): string | undefined;
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    get createTime(): string;
    private _databaseFlags?;
    get databaseFlags(): {
        [key: string]: string;
    };
    set databaseFlags(value: {
        [key: string]: string;
    });
    resetDatabaseFlags(): void;
    get databaseFlagsInput(): {
        [key: string]: string;
    } | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _gceZone?;
    get gceZone(): string;
    set gceZone(value: string);
    resetGceZone(): void;
    get gceZoneInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    private _instanceType?;
    get instanceType(): string;
    set instanceType(value: string);
    get instanceTypeInput(): string | undefined;
    get ipAddress(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get uid(): string;
    get updateTime(): string;
    private _clientConnectionConfig;
    get clientConnectionConfig(): GoogleAlloydbInstanceClientConnectionConfigOutputReference;
    putClientConnectionConfig(value: GoogleAlloydbInstanceClientConnectionConfig): void;
    resetClientConnectionConfig(): void;
    get clientConnectionConfigInput(): GoogleAlloydbInstanceClientConnectionConfig | undefined;
    private _machineConfig;
    get machineConfig(): GoogleAlloydbInstanceMachineConfigOutputReference;
    putMachineConfig(value: GoogleAlloydbInstanceMachineConfig): void;
    resetMachineConfig(): void;
    get machineConfigInput(): GoogleAlloydbInstanceMachineConfig | undefined;
    private _queryInsightsConfig;
    get queryInsightsConfig(): GoogleAlloydbInstanceQueryInsightsConfigOutputReference;
    putQueryInsightsConfig(value: GoogleAlloydbInstanceQueryInsightsConfig): void;
    resetQueryInsightsConfig(): void;
    get queryInsightsConfigInput(): GoogleAlloydbInstanceQueryInsightsConfig | undefined;
    private _readPoolConfig;
    get readPoolConfig(): GoogleAlloydbInstanceReadPoolConfigOutputReference;
    putReadPoolConfig(value: GoogleAlloydbInstanceReadPoolConfig): void;
    resetReadPoolConfig(): void;
    get readPoolConfigInput(): GoogleAlloydbInstanceReadPoolConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleAlloydbInstanceTimeoutsOutputReference;
    putTimeouts(value: GoogleAlloydbInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAlloydbInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
