/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAlloydbUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Identifies the alloydb cluster. Must be in the format
    * 'projects/{project}/locations/{location}/clusters/{cluster_id}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_user#cluster GoogleAlloydbUser#cluster}
    */
    readonly cluster: string;
    /**
    * List of database roles this database user has.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_user#database_roles GoogleAlloydbUser#database_roles}
    */
    readonly databaseRoles?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_user#id GoogleAlloydbUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Password for this database user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_user#password GoogleAlloydbUser#password}
    */
    readonly password?: string;
    /**
    * The database role name of the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_user#user_id GoogleAlloydbUser#user_id}
    */
    readonly userId: string;
    /**
    * The type of this user. Possible values: ["ALLOYDB_BUILT_IN", "ALLOYDB_IAM_USER"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_user#user_type GoogleAlloydbUser#user_type}
    */
    readonly userType: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_user#timeouts GoogleAlloydbUser#timeouts}
    */
    readonly timeouts?: GoogleAlloydbUserTimeouts;
}
export interface GoogleAlloydbUserTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_user#create GoogleAlloydbUser#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_user#delete GoogleAlloydbUser#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_user#update GoogleAlloydbUser#update}
    */
    readonly update?: string;
}
export declare function googleAlloydbUserTimeoutsToTerraform(struct?: GoogleAlloydbUserTimeouts | cdktf.IResolvable): any;
export declare function googleAlloydbUserTimeoutsToHclTerraform(struct?: GoogleAlloydbUserTimeouts | cdktf.IResolvable): any;
export declare class GoogleAlloydbUserTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbUserTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAlloydbUserTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_user google_alloydb_user}
*/
export declare class GoogleAlloydbUser extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_alloydb_user";
    /**
    * Generates CDKTF code for importing a GoogleAlloydbUser resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleAlloydbUser to import
    * @param importFromId The id of the existing GoogleAlloydbUser that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_user#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleAlloydbUser to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_alloydb_user google_alloydb_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAlloydbUserConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAlloydbUserConfig);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    private _databaseRoles?;
    get databaseRoles(): string[];
    set databaseRoles(value: string[]);
    resetDatabaseRoles(): void;
    get databaseRolesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    get userIdInput(): string | undefined;
    private _userType?;
    get userType(): string;
    set userType(value: string);
    get userTypeInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleAlloydbUserTimeoutsOutputReference;
    putTimeouts(value: GoogleAlloydbUserTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAlloydbUserTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
