/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApiGatewayApiConfig extends cdktf.TerraformMetaArguments {
    /**
    * Identifier to assign to the API. Must be unique within scope of the parent resource(project)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_api_gateway_api#api_id GoogleApiGatewayApi#api_id}
    */
    readonly apiId: string;
    /**
    * A user-visible name for the API.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_api_gateway_api#display_name GoogleApiGatewayApi#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_api_gateway_api#id GoogleApiGatewayApi#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource labels to represent user-provided metadata.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_api_gateway_api#labels GoogleApiGatewayApi#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Immutable. The name of a Google Managed Service ( https://cloud.google.com/service-infrastructure/docs/glossary#managed).
    * If not specified, a new Service will automatically be created in the same project as this API.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_api_gateway_api#managed_service GoogleApiGatewayApi#managed_service}
    */
    readonly managedService?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_api_gateway_api#project GoogleApiGatewayApi#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_api_gateway_api#timeouts GoogleApiGatewayApi#timeouts}
    */
    readonly timeouts?: GoogleApiGatewayApiTimeouts;
}
export interface GoogleApiGatewayApiTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_api_gateway_api#create GoogleApiGatewayApi#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_api_gateway_api#delete GoogleApiGatewayApi#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_api_gateway_api#update GoogleApiGatewayApi#update}
    */
    readonly update?: string;
}
export declare function googleApiGatewayApiTimeoutsToTerraform(struct?: GoogleApiGatewayApiTimeouts | cdktf.IResolvable): any;
export declare function googleApiGatewayApiTimeoutsToHclTerraform(struct?: GoogleApiGatewayApiTimeouts | cdktf.IResolvable): any;
export declare class GoogleApiGatewayApiTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApiGatewayApiTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApiGatewayApiTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_api_gateway_api google_api_gateway_api}
*/
export declare class GoogleApiGatewayApi extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_api_gateway_api";
    /**
    * Generates CDKTF code for importing a GoogleApiGatewayApi resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleApiGatewayApi to import
    * @param importFromId The id of the existing GoogleApiGatewayApi that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_api_gateway_api#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleApiGatewayApi to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_api_gateway_api google_api_gateway_api} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApiGatewayApiConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApiGatewayApiConfig);
    private _apiId?;
    get apiId(): string;
    set apiId(value: string);
    get apiIdInput(): string | undefined;
    get createTime(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _managedService?;
    get managedService(): string;
    set managedService(value: string);
    resetManagedService(): void;
    get managedServiceInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): GoogleApiGatewayApiTimeoutsOutputReference;
    putTimeouts(value: GoogleApiGatewayApiTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApiGatewayApiTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
