/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApigeeAddonsConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#id GoogleApigeeAddonsConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the Apigee organization.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#org GoogleApigeeAddonsConfig#org}
    */
    readonly org: string;
    /**
    * addons_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#addons_config GoogleApigeeAddonsConfig#addons_config}
    */
    readonly addonsConfig?: GoogleApigeeAddonsConfigAddonsConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#timeouts GoogleApigeeAddonsConfig#timeouts}
    */
    readonly timeouts?: GoogleApigeeAddonsConfigTimeouts;
}
export interface GoogleApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfig {
    /**
    * Flag that specifies whether the Advanced API Ops add-on is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#enabled GoogleApigeeAddonsConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfigToTerraform(struct?: GoogleApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfigOutputReference | GoogleApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfig): any;
export declare function googleApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfigToHclTerraform(struct?: GoogleApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfigOutputReference | GoogleApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfig): any;
export declare class GoogleApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfig | undefined;
    set internalValue(value: GoogleApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleApigeeAddonsConfigAddonsConfigApiSecurityConfig {
    /**
    * Flag that specifies whether the Advanced API Ops add-on is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#enabled GoogleApigeeAddonsConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleApigeeAddonsConfigAddonsConfigApiSecurityConfigToTerraform(struct?: GoogleApigeeAddonsConfigAddonsConfigApiSecurityConfigOutputReference | GoogleApigeeAddonsConfigAddonsConfigApiSecurityConfig): any;
export declare function googleApigeeAddonsConfigAddonsConfigApiSecurityConfigToHclTerraform(struct?: GoogleApigeeAddonsConfigAddonsConfigApiSecurityConfigOutputReference | GoogleApigeeAddonsConfigAddonsConfigApiSecurityConfig): any;
export declare class GoogleApigeeAddonsConfigAddonsConfigApiSecurityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeAddonsConfigAddonsConfigApiSecurityConfig | undefined;
    set internalValue(value: GoogleApigeeAddonsConfigAddonsConfigApiSecurityConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get expiresAt(): string;
}
export interface GoogleApigeeAddonsConfigAddonsConfigConnectorsPlatformConfig {
    /**
    * Flag that specifies whether the Advanced API Ops add-on is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#enabled GoogleApigeeAddonsConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleApigeeAddonsConfigAddonsConfigConnectorsPlatformConfigToTerraform(struct?: GoogleApigeeAddonsConfigAddonsConfigConnectorsPlatformConfigOutputReference | GoogleApigeeAddonsConfigAddonsConfigConnectorsPlatformConfig): any;
export declare function googleApigeeAddonsConfigAddonsConfigConnectorsPlatformConfigToHclTerraform(struct?: GoogleApigeeAddonsConfigAddonsConfigConnectorsPlatformConfigOutputReference | GoogleApigeeAddonsConfigAddonsConfigConnectorsPlatformConfig): any;
export declare class GoogleApigeeAddonsConfigAddonsConfigConnectorsPlatformConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeAddonsConfigAddonsConfigConnectorsPlatformConfig | undefined;
    set internalValue(value: GoogleApigeeAddonsConfigAddonsConfigConnectorsPlatformConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get expiresAt(): string;
}
export interface GoogleApigeeAddonsConfigAddonsConfigIntegrationConfig {
    /**
    * Flag that specifies whether the Advanced API Ops add-on is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#enabled GoogleApigeeAddonsConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleApigeeAddonsConfigAddonsConfigIntegrationConfigToTerraform(struct?: GoogleApigeeAddonsConfigAddonsConfigIntegrationConfigOutputReference | GoogleApigeeAddonsConfigAddonsConfigIntegrationConfig): any;
export declare function googleApigeeAddonsConfigAddonsConfigIntegrationConfigToHclTerraform(struct?: GoogleApigeeAddonsConfigAddonsConfigIntegrationConfigOutputReference | GoogleApigeeAddonsConfigAddonsConfigIntegrationConfig): any;
export declare class GoogleApigeeAddonsConfigAddonsConfigIntegrationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeAddonsConfigAddonsConfigIntegrationConfig | undefined;
    set internalValue(value: GoogleApigeeAddonsConfigAddonsConfigIntegrationConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleApigeeAddonsConfigAddonsConfigMonetizationConfig {
    /**
    * Flag that specifies whether the Advanced API Ops add-on is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#enabled GoogleApigeeAddonsConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleApigeeAddonsConfigAddonsConfigMonetizationConfigToTerraform(struct?: GoogleApigeeAddonsConfigAddonsConfigMonetizationConfigOutputReference | GoogleApigeeAddonsConfigAddonsConfigMonetizationConfig): any;
export declare function googleApigeeAddonsConfigAddonsConfigMonetizationConfigToHclTerraform(struct?: GoogleApigeeAddonsConfigAddonsConfigMonetizationConfigOutputReference | GoogleApigeeAddonsConfigAddonsConfigMonetizationConfig): any;
export declare class GoogleApigeeAddonsConfigAddonsConfigMonetizationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeAddonsConfigAddonsConfigMonetizationConfig | undefined;
    set internalValue(value: GoogleApigeeAddonsConfigAddonsConfigMonetizationConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleApigeeAddonsConfigAddonsConfig {
    /**
    * advanced_api_ops_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#advanced_api_ops_config GoogleApigeeAddonsConfig#advanced_api_ops_config}
    */
    readonly advancedApiOpsConfig?: GoogleApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfig;
    /**
    * api_security_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#api_security_config GoogleApigeeAddonsConfig#api_security_config}
    */
    readonly apiSecurityConfig?: GoogleApigeeAddonsConfigAddonsConfigApiSecurityConfig;
    /**
    * connectors_platform_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#connectors_platform_config GoogleApigeeAddonsConfig#connectors_platform_config}
    */
    readonly connectorsPlatformConfig?: GoogleApigeeAddonsConfigAddonsConfigConnectorsPlatformConfig;
    /**
    * integration_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#integration_config GoogleApigeeAddonsConfig#integration_config}
    */
    readonly integrationConfig?: GoogleApigeeAddonsConfigAddonsConfigIntegrationConfig;
    /**
    * monetization_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#monetization_config GoogleApigeeAddonsConfig#monetization_config}
    */
    readonly monetizationConfig?: GoogleApigeeAddonsConfigAddonsConfigMonetizationConfig;
}
export declare function googleApigeeAddonsConfigAddonsConfigToTerraform(struct?: GoogleApigeeAddonsConfigAddonsConfigOutputReference | GoogleApigeeAddonsConfigAddonsConfig): any;
export declare function googleApigeeAddonsConfigAddonsConfigToHclTerraform(struct?: GoogleApigeeAddonsConfigAddonsConfigOutputReference | GoogleApigeeAddonsConfigAddonsConfig): any;
export declare class GoogleApigeeAddonsConfigAddonsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeAddonsConfigAddonsConfig | undefined;
    set internalValue(value: GoogleApigeeAddonsConfigAddonsConfig | undefined);
    private _advancedApiOpsConfig;
    get advancedApiOpsConfig(): GoogleApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfigOutputReference;
    putAdvancedApiOpsConfig(value: GoogleApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfig): void;
    resetAdvancedApiOpsConfig(): void;
    get advancedApiOpsConfigInput(): GoogleApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfig | undefined;
    private _apiSecurityConfig;
    get apiSecurityConfig(): GoogleApigeeAddonsConfigAddonsConfigApiSecurityConfigOutputReference;
    putApiSecurityConfig(value: GoogleApigeeAddonsConfigAddonsConfigApiSecurityConfig): void;
    resetApiSecurityConfig(): void;
    get apiSecurityConfigInput(): GoogleApigeeAddonsConfigAddonsConfigApiSecurityConfig | undefined;
    private _connectorsPlatformConfig;
    get connectorsPlatformConfig(): GoogleApigeeAddonsConfigAddonsConfigConnectorsPlatformConfigOutputReference;
    putConnectorsPlatformConfig(value: GoogleApigeeAddonsConfigAddonsConfigConnectorsPlatformConfig): void;
    resetConnectorsPlatformConfig(): void;
    get connectorsPlatformConfigInput(): GoogleApigeeAddonsConfigAddonsConfigConnectorsPlatformConfig | undefined;
    private _integrationConfig;
    get integrationConfig(): GoogleApigeeAddonsConfigAddonsConfigIntegrationConfigOutputReference;
    putIntegrationConfig(value: GoogleApigeeAddonsConfigAddonsConfigIntegrationConfig): void;
    resetIntegrationConfig(): void;
    get integrationConfigInput(): GoogleApigeeAddonsConfigAddonsConfigIntegrationConfig | undefined;
    private _monetizationConfig;
    get monetizationConfig(): GoogleApigeeAddonsConfigAddonsConfigMonetizationConfigOutputReference;
    putMonetizationConfig(value: GoogleApigeeAddonsConfigAddonsConfigMonetizationConfig): void;
    resetMonetizationConfig(): void;
    get monetizationConfigInput(): GoogleApigeeAddonsConfigAddonsConfigMonetizationConfig | undefined;
}
export interface GoogleApigeeAddonsConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#create GoogleApigeeAddonsConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#delete GoogleApigeeAddonsConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#update GoogleApigeeAddonsConfig#update}
    */
    readonly update?: string;
}
export declare function googleApigeeAddonsConfigTimeoutsToTerraform(struct?: GoogleApigeeAddonsConfigTimeouts | cdktf.IResolvable): any;
export declare function googleApigeeAddonsConfigTimeoutsToHclTerraform(struct?: GoogleApigeeAddonsConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleApigeeAddonsConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeAddonsConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApigeeAddonsConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config google_apigee_addons_config}
*/
export declare class GoogleApigeeAddonsConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_addons_config";
    /**
    * Generates CDKTF code for importing a GoogleApigeeAddonsConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleApigeeAddonsConfig to import
    * @param importFromId The id of the existing GoogleApigeeAddonsConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleApigeeAddonsConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_addons_config google_apigee_addons_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApigeeAddonsConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApigeeAddonsConfigConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _org?;
    get org(): string;
    set org(value: string);
    get orgInput(): string | undefined;
    private _addonsConfig;
    get addonsConfig(): GoogleApigeeAddonsConfigAddonsConfigOutputReference;
    putAddonsConfig(value: GoogleApigeeAddonsConfigAddonsConfig): void;
    resetAddonsConfig(): void;
    get addonsConfigInput(): GoogleApigeeAddonsConfigAddonsConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleApigeeAddonsConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleApigeeAddonsConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApigeeAddonsConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
