/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApigeeEndpointAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the endpoint attachment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_endpoint_attachment#endpoint_attachment_id GoogleApigeeEndpointAttachment#endpoint_attachment_id}
    */
    readonly endpointAttachmentId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_endpoint_attachment#id GoogleApigeeEndpointAttachment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Location of the endpoint attachment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_endpoint_attachment#location GoogleApigeeEndpointAttachment#location}
    */
    readonly location: string;
    /**
    * The Apigee Organization associated with the Apigee instance,
    * in the format 'organizations/{{org_name}}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_endpoint_attachment#org_id GoogleApigeeEndpointAttachment#org_id}
    */
    readonly orgId: string;
    /**
    * Format: projects/* /regions/* /serviceAttachments/*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_endpoint_attachment#service_attachment GoogleApigeeEndpointAttachment#service_attachment}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly serviceAttachment: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_endpoint_attachment#timeouts GoogleApigeeEndpointAttachment#timeouts}
    */
    readonly timeouts?: GoogleApigeeEndpointAttachmentTimeouts;
}
export interface GoogleApigeeEndpointAttachmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_endpoint_attachment#create GoogleApigeeEndpointAttachment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_endpoint_attachment#delete GoogleApigeeEndpointAttachment#delete}
    */
    readonly delete?: string;
}
export declare function googleApigeeEndpointAttachmentTimeoutsToTerraform(struct?: GoogleApigeeEndpointAttachmentTimeouts | cdktf.IResolvable): any;
export declare function googleApigeeEndpointAttachmentTimeoutsToHclTerraform(struct?: GoogleApigeeEndpointAttachmentTimeouts | cdktf.IResolvable): any;
export declare class GoogleApigeeEndpointAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeEndpointAttachmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApigeeEndpointAttachmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_endpoint_attachment google_apigee_endpoint_attachment}
*/
export declare class GoogleApigeeEndpointAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_endpoint_attachment";
    /**
    * Generates CDKTF code for importing a GoogleApigeeEndpointAttachment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleApigeeEndpointAttachment to import
    * @param importFromId The id of the existing GoogleApigeeEndpointAttachment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_endpoint_attachment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleApigeeEndpointAttachment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_endpoint_attachment google_apigee_endpoint_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApigeeEndpointAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApigeeEndpointAttachmentConfig);
    get connectionState(): string;
    private _endpointAttachmentId?;
    get endpointAttachmentId(): string;
    set endpointAttachmentId(value: string);
    get endpointAttachmentIdInput(): string | undefined;
    get host(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _serviceAttachment?;
    get serviceAttachment(): string;
    set serviceAttachment(value: string);
    get serviceAttachmentInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleApigeeEndpointAttachmentTimeoutsOutputReference;
    putTimeouts(value: GoogleApigeeEndpointAttachmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApigeeEndpointAttachmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
