/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApigeeEnvKeystoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Apigee environment group associated with the Apigee environment,
    * in the format 'organizations/{{org_name}}/environments/{{env_name}}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_env_keystore#env_id GoogleApigeeEnvKeystore#env_id}
    */
    readonly envId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_env_keystore#id GoogleApigeeEnvKeystore#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the newly created keystore.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_env_keystore#name GoogleApigeeEnvKeystore#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_env_keystore#timeouts GoogleApigeeEnvKeystore#timeouts}
    */
    readonly timeouts?: GoogleApigeeEnvKeystoreTimeouts;
}
export interface GoogleApigeeEnvKeystoreTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_env_keystore#create GoogleApigeeEnvKeystore#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_env_keystore#delete GoogleApigeeEnvKeystore#delete}
    */
    readonly delete?: string;
}
export declare function googleApigeeEnvKeystoreTimeoutsToTerraform(struct?: GoogleApigeeEnvKeystoreTimeouts | cdktf.IResolvable): any;
export declare function googleApigeeEnvKeystoreTimeoutsToHclTerraform(struct?: GoogleApigeeEnvKeystoreTimeouts | cdktf.IResolvable): any;
export declare class GoogleApigeeEnvKeystoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeEnvKeystoreTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApigeeEnvKeystoreTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_env_keystore google_apigee_env_keystore}
*/
export declare class GoogleApigeeEnvKeystore extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_env_keystore";
    /**
    * Generates CDKTF code for importing a GoogleApigeeEnvKeystore resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleApigeeEnvKeystore to import
    * @param importFromId The id of the existing GoogleApigeeEnvKeystore that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_env_keystore#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleApigeeEnvKeystore to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_env_keystore google_apigee_env_keystore} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApigeeEnvKeystoreConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApigeeEnvKeystoreConfig);
    get aliases(): string[];
    private _envId?;
    get envId(): string;
    set envId(value: string);
    get envIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleApigeeEnvKeystoreTimeoutsOutputReference;
    putTimeouts(value: GoogleApigeeEnvKeystoreTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApigeeEnvKeystoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
