/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApigeeInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Customer accept list represents the list of projects (id/number) on customer
    * side that can privately connect to the service attachment. It is an optional field
    * which the customers can provide during the instance creation. By default, the customer
    * project associated with the Apigee organization will be included to the list.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_instance#consumer_accept_list GoogleApigeeInstance#consumer_accept_list}
    */
    readonly consumerAcceptList?: string[];
    /**
    * Description of the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_instance#description GoogleApigeeInstance#description}
    */
    readonly description?: string;
    /**
    * Customer Managed Encryption Key (CMEK) used for disk and volume encryption. Required for Apigee paid subscriptions only.
    * Use the following format: 'projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_instance#disk_encryption_key_name GoogleApigeeInstance#disk_encryption_key_name}
    */
    readonly diskEncryptionKeyName?: string;
    /**
    * Display name of the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_instance#display_name GoogleApigeeInstance#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_instance#id GoogleApigeeInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * IP range represents the customer-provided CIDR block of length 22 that will be used for
    * the Apigee instance creation. This optional range, if provided, should be freely
    * available as part of larger named range the customer has allocated to the Service
    * Networking peering. If this is not provided, Apigee will automatically request for any
    * available /22 CIDR block from Service Networking. The customer should use this CIDR block
    * for configuring their firewall needs to allow traffic from Apigee.
    * Input format: "a.b.c.d/22"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_instance#ip_range GoogleApigeeInstance#ip_range}
    */
    readonly ipRange?: string;
    /**
    * Required. Compute Engine location where the instance resides.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_instance#location GoogleApigeeInstance#location}
    */
    readonly location: string;
    /**
    * Resource ID of the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_instance#name GoogleApigeeInstance#name}
    */
    readonly name: string;
    /**
    * The Apigee Organization associated with the Apigee instance,
    * in the format 'organizations/{{org_name}}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_instance#org_id GoogleApigeeInstance#org_id}
    */
    readonly orgId: string;
    /**
    * The size of the CIDR block range that will be reserved by the instance. For valid values,
    * see [CidrRange](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.instances#CidrRange) on the documentation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_instance#peering_cidr_range GoogleApigeeInstance#peering_cidr_range}
    */
    readonly peeringCidrRange?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_instance#timeouts GoogleApigeeInstance#timeouts}
    */
    readonly timeouts?: GoogleApigeeInstanceTimeouts;
}
export interface GoogleApigeeInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_instance#create GoogleApigeeInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_instance#delete GoogleApigeeInstance#delete}
    */
    readonly delete?: string;
}
export declare function googleApigeeInstanceTimeoutsToTerraform(struct?: GoogleApigeeInstanceTimeouts | cdktf.IResolvable): any;
export declare function googleApigeeInstanceTimeoutsToHclTerraform(struct?: GoogleApigeeInstanceTimeouts | cdktf.IResolvable): any;
export declare class GoogleApigeeInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApigeeInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_instance google_apigee_instance}
*/
export declare class GoogleApigeeInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_instance";
    /**
    * Generates CDKTF code for importing a GoogleApigeeInstance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleApigeeInstance to import
    * @param importFromId The id of the existing GoogleApigeeInstance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_instance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleApigeeInstance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_instance google_apigee_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApigeeInstanceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApigeeInstanceConfig);
    private _consumerAcceptList?;
    get consumerAcceptList(): string[];
    set consumerAcceptList(value: string[]);
    resetConsumerAcceptList(): void;
    get consumerAcceptListInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _diskEncryptionKeyName?;
    get diskEncryptionKeyName(): string;
    set diskEncryptionKeyName(value: string);
    resetDiskEncryptionKeyName(): void;
    get diskEncryptionKeyNameInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get host(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipRange?;
    get ipRange(): string;
    set ipRange(value: string);
    resetIpRange(): void;
    get ipRangeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _peeringCidrRange?;
    get peeringCidrRange(): string;
    set peeringCidrRange(value: string);
    resetPeeringCidrRange(): void;
    get peeringCidrRangeInput(): string | undefined;
    get port(): string;
    get serviceAttachment(): string;
    private _timeouts;
    get timeouts(): GoogleApigeeInstanceTimeoutsOutputReference;
    putTimeouts(value: GoogleApigeeInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApigeeInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
