/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApigeeKeystoresAliasesPkcs12Config extends cdktf.TerraformMetaArguments {
    /**
    * Alias Name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_keystores_aliases_pkcs12#alias GoogleApigeeKeystoresAliasesPkcs12#alias}
    */
    readonly alias: string;
    /**
    * Environment associated with the alias
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_keystores_aliases_pkcs12#environment GoogleApigeeKeystoresAliasesPkcs12#environment}
    */
    readonly environment: string;
    /**
    * Cert content
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_keystores_aliases_pkcs12#file GoogleApigeeKeystoresAliasesPkcs12#file}
    */
    readonly file: string;
    /**
    * Hash of the pkcs file
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_keystores_aliases_pkcs12#filehash GoogleApigeeKeystoresAliasesPkcs12#filehash}
    */
    readonly filehash: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_keystores_aliases_pkcs12#id GoogleApigeeKeystoresAliasesPkcs12#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Keystore Name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_keystores_aliases_pkcs12#keystore GoogleApigeeKeystoresAliasesPkcs12#keystore}
    */
    readonly keystore: string;
    /**
    * Organization ID associated with the alias
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_keystores_aliases_pkcs12#org_id GoogleApigeeKeystoresAliasesPkcs12#org_id}
    */
    readonly orgId: string;
    /**
    * Password for the Private Key if it's encrypted
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_keystores_aliases_pkcs12#password GoogleApigeeKeystoresAliasesPkcs12#password}
    */
    readonly password?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_keystores_aliases_pkcs12#timeouts GoogleApigeeKeystoresAliasesPkcs12#timeouts}
    */
    readonly timeouts?: GoogleApigeeKeystoresAliasesPkcs12Timeouts;
}
export interface GoogleApigeeKeystoresAliasesPkcs12CertsInfoCertInfo {
}
export declare function googleApigeeKeystoresAliasesPkcs12CertsInfoCertInfoToTerraform(struct?: GoogleApigeeKeystoresAliasesPkcs12CertsInfoCertInfo): any;
export declare function googleApigeeKeystoresAliasesPkcs12CertsInfoCertInfoToHclTerraform(struct?: GoogleApigeeKeystoresAliasesPkcs12CertsInfoCertInfo): any;
export declare class GoogleApigeeKeystoresAliasesPkcs12CertsInfoCertInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApigeeKeystoresAliasesPkcs12CertsInfoCertInfo | undefined;
    set internalValue(value: GoogleApigeeKeystoresAliasesPkcs12CertsInfoCertInfo | undefined);
    get basicConstraints(): string;
    get expiryDate(): string;
    get isValid(): string;
    get issuer(): string;
    get publicKey(): string;
    get serialNumber(): string;
    get sigAlgName(): string;
    get subject(): string;
    get subjectAlternativeNames(): string[];
    get validFrom(): string;
    get version(): number;
}
export declare class GoogleApigeeKeystoresAliasesPkcs12CertsInfoCertInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApigeeKeystoresAliasesPkcs12CertsInfoCertInfoOutputReference;
}
export interface GoogleApigeeKeystoresAliasesPkcs12CertsInfo {
}
export declare function googleApigeeKeystoresAliasesPkcs12CertsInfoToTerraform(struct?: GoogleApigeeKeystoresAliasesPkcs12CertsInfo): any;
export declare function googleApigeeKeystoresAliasesPkcs12CertsInfoToHclTerraform(struct?: GoogleApigeeKeystoresAliasesPkcs12CertsInfo): any;
export declare class GoogleApigeeKeystoresAliasesPkcs12CertsInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApigeeKeystoresAliasesPkcs12CertsInfo | undefined;
    set internalValue(value: GoogleApigeeKeystoresAliasesPkcs12CertsInfo | undefined);
    private _certInfo;
    get certInfo(): GoogleApigeeKeystoresAliasesPkcs12CertsInfoCertInfoList;
}
export declare class GoogleApigeeKeystoresAliasesPkcs12CertsInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApigeeKeystoresAliasesPkcs12CertsInfoOutputReference;
}
export interface GoogleApigeeKeystoresAliasesPkcs12Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_keystores_aliases_pkcs12#create GoogleApigeeKeystoresAliasesPkcs12#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_keystores_aliases_pkcs12#delete GoogleApigeeKeystoresAliasesPkcs12#delete}
    */
    readonly delete?: string;
}
export declare function googleApigeeKeystoresAliasesPkcs12TimeoutsToTerraform(struct?: GoogleApigeeKeystoresAliasesPkcs12Timeouts | cdktf.IResolvable): any;
export declare function googleApigeeKeystoresAliasesPkcs12TimeoutsToHclTerraform(struct?: GoogleApigeeKeystoresAliasesPkcs12Timeouts | cdktf.IResolvable): any;
export declare class GoogleApigeeKeystoresAliasesPkcs12TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeKeystoresAliasesPkcs12Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApigeeKeystoresAliasesPkcs12Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_keystores_aliases_pkcs12 google_apigee_keystores_aliases_pkcs12}
*/
export declare class GoogleApigeeKeystoresAliasesPkcs12 extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_keystores_aliases_pkcs12";
    /**
    * Generates CDKTF code for importing a GoogleApigeeKeystoresAliasesPkcs12 resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleApigeeKeystoresAliasesPkcs12 to import
    * @param importFromId The id of the existing GoogleApigeeKeystoresAliasesPkcs12 that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_keystores_aliases_pkcs12#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleApigeeKeystoresAliasesPkcs12 to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_keystores_aliases_pkcs12 google_apigee_keystores_aliases_pkcs12} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApigeeKeystoresAliasesPkcs12Config
    */
    constructor(scope: Construct, id: string, config: GoogleApigeeKeystoresAliasesPkcs12Config);
    private _alias?;
    get alias(): string;
    set alias(value: string);
    get aliasInput(): string | undefined;
    private _certsInfo;
    get certsInfo(): GoogleApigeeKeystoresAliasesPkcs12CertsInfoList;
    private _environment?;
    get environment(): string;
    set environment(value: string);
    get environmentInput(): string | undefined;
    private _file?;
    get file(): string;
    set file(value: string);
    get fileInput(): string | undefined;
    private _filehash?;
    get filehash(): string;
    set filehash(value: string);
    get filehashInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keystore?;
    get keystore(): string;
    set keystore(value: string);
    get keystoreInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    get type(): string;
    private _timeouts;
    get timeouts(): GoogleApigeeKeystoresAliasesPkcs12TimeoutsOutputReference;
    putTimeouts(value: GoogleApigeeKeystoresAliasesPkcs12Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApigeeKeystoresAliasesPkcs12Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
