/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApigeeNatAddressConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_nat_address#id GoogleApigeeNatAddress#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The Apigee instance associated with the Apigee environment,
    * in the format 'organizations/{{org_name}}/instances/{{instance_name}}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_nat_address#instance_id GoogleApigeeNatAddress#instance_id}
    */
    readonly instanceId: string;
    /**
    * Resource ID of the NAT address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_nat_address#name GoogleApigeeNatAddress#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_nat_address#timeouts GoogleApigeeNatAddress#timeouts}
    */
    readonly timeouts?: GoogleApigeeNatAddressTimeouts;
}
export interface GoogleApigeeNatAddressTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_nat_address#create GoogleApigeeNatAddress#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_nat_address#delete GoogleApigeeNatAddress#delete}
    */
    readonly delete?: string;
}
export declare function googleApigeeNatAddressTimeoutsToTerraform(struct?: GoogleApigeeNatAddressTimeouts | cdktf.IResolvable): any;
export declare function googleApigeeNatAddressTimeoutsToHclTerraform(struct?: GoogleApigeeNatAddressTimeouts | cdktf.IResolvable): any;
export declare class GoogleApigeeNatAddressTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeNatAddressTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApigeeNatAddressTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_nat_address google_apigee_nat_address}
*/
export declare class GoogleApigeeNatAddress extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_nat_address";
    /**
    * Generates CDKTF code for importing a GoogleApigeeNatAddress resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleApigeeNatAddress to import
    * @param importFromId The id of the existing GoogleApigeeNatAddress that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_nat_address#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleApigeeNatAddress to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_nat_address google_apigee_nat_address} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApigeeNatAddressConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApigeeNatAddressConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    get ipAddress(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get state(): string;
    private _timeouts;
    get timeouts(): GoogleApigeeNatAddressTimeoutsOutputReference;
    putTimeouts(value: GoogleApigeeNatAddressTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApigeeNatAddressTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
