/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApigeeOrganizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#analytics_region GoogleApigeeOrganization#analytics_region}
    */
    readonly analyticsRegion?: string;
    /**
    * Compute Engine network used for Service Networking to be peered with Apigee runtime instances.
    * See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started).
    * Valid only when 'RuntimeType' is set to CLOUD. The value can be updated only when there are no runtime instances. For example: "default".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#authorized_network GoogleApigeeOrganization#authorized_network}
    */
    readonly authorizedNetwork?: string;
    /**
    * Billing type of the Apigee organization. See [Apigee pricing](https://cloud.google.com/apigee/pricing).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#billing_type GoogleApigeeOrganization#billing_type}
    */
    readonly billingType?: string;
    /**
    * Description of the Apigee organization.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#description GoogleApigeeOrganization#description}
    */
    readonly description?: string;
    /**
    * Flag that specifies whether the VPC Peering through Private Google Access should be
    * disabled between the consumer network and Apigee. Required if an 'authorizedNetwork'
    * on the consumer project is not provided, in which case the flag should be set to 'true'.
    * Valid only when 'RuntimeType' is set to CLOUD. The value must be set before the creation
    * of any Apigee runtime instance and can be updated only when there are no runtime instances.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#disable_vpc_peering GoogleApigeeOrganization#disable_vpc_peering}
    */
    readonly disableVpcPeering?: boolean | cdktf.IResolvable;
    /**
    * The display name of the Apigee organization.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#display_name GoogleApigeeOrganization#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#id GoogleApigeeOrganization#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The project ID associated with the Apigee organization.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#project_id GoogleApigeeOrganization#project_id}
    */
    readonly projectId: string;
    /**
    * Optional. This setting is applicable only for organizations that are soft-deleted (i.e., BillingType
    * is not EVALUATION). It controls how long Organization data will be retained after the initial delete
    * operation completes. During this period, the Organization may be restored to its last known state.
    * After this period, the Organization will no longer be able to be restored. Default value: "DELETION_RETENTION_UNSPECIFIED" Possible values: ["DELETION_RETENTION_UNSPECIFIED", "MINIMUM"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#retention GoogleApigeeOrganization#retention}
    */
    readonly retention?: string;
    /**
    * Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances.
    * Update is not allowed after the organization is created.
    * If not specified, a Google-Managed encryption key will be used.
    * Valid only when 'RuntimeType' is CLOUD. For example: 'projects/foo/locations/us/keyRings/bar/cryptoKeys/baz'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#runtime_database_encryption_key_name GoogleApigeeOrganization#runtime_database_encryption_key_name}
    */
    readonly runtimeDatabaseEncryptionKeyName?: string;
    /**
    * Runtime type of the Apigee organization based on the Apigee subscription purchased. Default value: "CLOUD" Possible values: ["CLOUD", "HYBRID"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#runtime_type GoogleApigeeOrganization#runtime_type}
    */
    readonly runtimeType?: string;
    /**
    * properties block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#properties GoogleApigeeOrganization#properties}
    */
    readonly properties?: GoogleApigeeOrganizationProperties;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#timeouts GoogleApigeeOrganization#timeouts}
    */
    readonly timeouts?: GoogleApigeeOrganizationTimeouts;
}
export interface GoogleApigeeOrganizationPropertiesProperty {
    /**
    * Name of the property.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#name GoogleApigeeOrganization#name}
    */
    readonly name?: string;
    /**
    * Value of the property.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#value GoogleApigeeOrganization#value}
    */
    readonly value?: string;
}
export declare function googleApigeeOrganizationPropertiesPropertyToTerraform(struct?: GoogleApigeeOrganizationPropertiesProperty | cdktf.IResolvable): any;
export declare function googleApigeeOrganizationPropertiesPropertyToHclTerraform(struct?: GoogleApigeeOrganizationPropertiesProperty | cdktf.IResolvable): any;
export declare class GoogleApigeeOrganizationPropertiesPropertyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApigeeOrganizationPropertiesProperty | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApigeeOrganizationPropertiesProperty | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleApigeeOrganizationPropertiesPropertyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleApigeeOrganizationPropertiesProperty[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApigeeOrganizationPropertiesPropertyOutputReference;
}
export interface GoogleApigeeOrganizationProperties {
    /**
    * property block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#property GoogleApigeeOrganization#property}
    */
    readonly property?: GoogleApigeeOrganizationPropertiesProperty[] | cdktf.IResolvable;
}
export declare function googleApigeeOrganizationPropertiesToTerraform(struct?: GoogleApigeeOrganizationPropertiesOutputReference | GoogleApigeeOrganizationProperties): any;
export declare function googleApigeeOrganizationPropertiesToHclTerraform(struct?: GoogleApigeeOrganizationPropertiesOutputReference | GoogleApigeeOrganizationProperties): any;
export declare class GoogleApigeeOrganizationPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeOrganizationProperties | undefined;
    set internalValue(value: GoogleApigeeOrganizationProperties | undefined);
    private _property;
    get property(): GoogleApigeeOrganizationPropertiesPropertyList;
    putProperty(value: GoogleApigeeOrganizationPropertiesProperty[] | cdktf.IResolvable): void;
    resetProperty(): void;
    get propertyInput(): cdktf.IResolvable | GoogleApigeeOrganizationPropertiesProperty[] | undefined;
}
export interface GoogleApigeeOrganizationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#create GoogleApigeeOrganization#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#delete GoogleApigeeOrganization#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#update GoogleApigeeOrganization#update}
    */
    readonly update?: string;
}
export declare function googleApigeeOrganizationTimeoutsToTerraform(struct?: GoogleApigeeOrganizationTimeouts | cdktf.IResolvable): any;
export declare function googleApigeeOrganizationTimeoutsToHclTerraform(struct?: GoogleApigeeOrganizationTimeouts | cdktf.IResolvable): any;
export declare class GoogleApigeeOrganizationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeOrganizationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApigeeOrganizationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization google_apigee_organization}
*/
export declare class GoogleApigeeOrganization extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_organization";
    /**
    * Generates CDKTF code for importing a GoogleApigeeOrganization resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleApigeeOrganization to import
    * @param importFromId The id of the existing GoogleApigeeOrganization that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleApigeeOrganization to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_organization google_apigee_organization} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApigeeOrganizationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApigeeOrganizationConfig);
    private _analyticsRegion?;
    get analyticsRegion(): string;
    set analyticsRegion(value: string);
    resetAnalyticsRegion(): void;
    get analyticsRegionInput(): string | undefined;
    get apigeeProjectId(): string;
    private _authorizedNetwork?;
    get authorizedNetwork(): string;
    set authorizedNetwork(value: string);
    resetAuthorizedNetwork(): void;
    get authorizedNetworkInput(): string | undefined;
    private _billingType?;
    get billingType(): string;
    set billingType(value: string);
    resetBillingType(): void;
    get billingTypeInput(): string | undefined;
    get caCertificate(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disableVpcPeering?;
    get disableVpcPeering(): boolean | cdktf.IResolvable;
    set disableVpcPeering(value: boolean | cdktf.IResolvable);
    resetDisableVpcPeering(): void;
    get disableVpcPeeringInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _retention?;
    get retention(): string;
    set retention(value: string);
    resetRetention(): void;
    get retentionInput(): string | undefined;
    private _runtimeDatabaseEncryptionKeyName?;
    get runtimeDatabaseEncryptionKeyName(): string;
    set runtimeDatabaseEncryptionKeyName(value: string);
    resetRuntimeDatabaseEncryptionKeyName(): void;
    get runtimeDatabaseEncryptionKeyNameInput(): string | undefined;
    private _runtimeType?;
    get runtimeType(): string;
    set runtimeType(value: string);
    resetRuntimeType(): void;
    get runtimeTypeInput(): string | undefined;
    get subscriptionType(): string;
    private _properties;
    get properties(): GoogleApigeeOrganizationPropertiesOutputReference;
    putProperties(value: GoogleApigeeOrganizationProperties): void;
    resetProperties(): void;
    get propertiesInput(): GoogleApigeeOrganizationProperties | undefined;
    private _timeouts;
    get timeouts(): GoogleApigeeOrganizationTimeoutsOutputReference;
    putTimeouts(value: GoogleApigeeOrganizationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApigeeOrganizationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
