/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApigeeTargetServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * A human-readable description of this TargetServer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#description GoogleApigeeTargetServer#description}
    */
    readonly description?: string;
    /**
    * The Apigee environment group associated with the Apigee environment,
    * in the format 'organizations/{{org_name}}/environments/{{env_name}}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#env_id GoogleApigeeTargetServer#env_id}
    */
    readonly envId: string;
    /**
    * The host name this target connects to. Value must be a valid hostname as described by RFC-1123.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#host GoogleApigeeTargetServer#host}
    */
    readonly host: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#id GoogleApigeeTargetServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Enabling/disabling a TargetServer is useful when TargetServers are used in load balancing configurations, and one or more TargetServers need to taken out of rotation periodically. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#is_enabled GoogleApigeeTargetServer#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * The resource id of this reference. Values must match the regular expression [\w\s-.]+.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#name GoogleApigeeTargetServer#name}
    */
    readonly name: string;
    /**
    * The port number this target connects to on the given host. Value must be between 1 and 65535, inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#port GoogleApigeeTargetServer#port}
    */
    readonly port: number;
    /**
    * Immutable. The protocol used by this TargetServer. Possible values: ["HTTP", "HTTP2", "GRPC_TARGET", "GRPC", "EXTERNAL_CALLOUT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#protocol GoogleApigeeTargetServer#protocol}
    */
    readonly protocol?: string;
    /**
    * s_sl_info block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#s_sl_info GoogleApigeeTargetServer#s_sl_info}
    */
    readonly sSlInfo?: GoogleApigeeTargetServerSSlInfo;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#timeouts GoogleApigeeTargetServer#timeouts}
    */
    readonly timeouts?: GoogleApigeeTargetServerTimeouts;
}
export interface GoogleApigeeTargetServerSSlInfoCommonName {
    /**
    * The TLS Common Name string of the certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#value GoogleApigeeTargetServer#value}
    */
    readonly value?: string;
    /**
    * Indicates whether the cert should be matched against as a wildcard cert.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#wildcard_match GoogleApigeeTargetServer#wildcard_match}
    */
    readonly wildcardMatch?: boolean | cdktf.IResolvable;
}
export declare function googleApigeeTargetServerSSlInfoCommonNameToTerraform(struct?: GoogleApigeeTargetServerSSlInfoCommonNameOutputReference | GoogleApigeeTargetServerSSlInfoCommonName): any;
export declare function googleApigeeTargetServerSSlInfoCommonNameToHclTerraform(struct?: GoogleApigeeTargetServerSSlInfoCommonNameOutputReference | GoogleApigeeTargetServerSSlInfoCommonName): any;
export declare class GoogleApigeeTargetServerSSlInfoCommonNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeTargetServerSSlInfoCommonName | undefined;
    set internalValue(value: GoogleApigeeTargetServerSSlInfoCommonName | undefined);
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _wildcardMatch?;
    get wildcardMatch(): boolean | cdktf.IResolvable;
    set wildcardMatch(value: boolean | cdktf.IResolvable);
    resetWildcardMatch(): void;
    get wildcardMatchInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleApigeeTargetServerSSlInfo {
    /**
    * The SSL/TLS cipher suites to be used. For programmable proxies, it must be one of the cipher suite names listed in: http://docs.oracle.com/javase/8/docs/technotes/guides/security/StandardNames.html#ciphersuites. For configurable proxies, it must follow the configuration specified in: https://commondatastorage.googleapis.com/chromium-boringssl-docs/ssl.h.html#Cipher-suite-configuration. This setting has no effect for configurable proxies when negotiating TLS 1.3.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#ciphers GoogleApigeeTargetServer#ciphers}
    */
    readonly ciphers?: string[];
    /**
    * Enables two-way TLS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#client_auth_enabled GoogleApigeeTargetServer#client_auth_enabled}
    */
    readonly clientAuthEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enables TLS. If false, neither one-way nor two-way TLS will be enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#enabled GoogleApigeeTargetServer#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * If true, Edge ignores TLS certificate errors. Valid when configuring TLS for target servers and target endpoints, and when configuring virtual hosts that use 2-way TLS. When used with a target endpoint/target server, if the backend system uses SNI and returns a cert with a subject Distinguished Name (DN) that does not match the hostname, there is no way to ignore the error and the connection fails.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#ignore_validation_errors GoogleApigeeTargetServer#ignore_validation_errors}
    */
    readonly ignoreValidationErrors?: boolean | cdktf.IResolvable;
    /**
    * Required if clientAuthEnabled is true. The resource ID for the alias containing the private key and cert.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#key_alias GoogleApigeeTargetServer#key_alias}
    */
    readonly keyAlias?: string;
    /**
    * Required if clientAuthEnabled is true. The resource ID of the keystore.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#key_store GoogleApigeeTargetServer#key_store}
    */
    readonly keyStore?: string;
    /**
    * The TLS versioins to be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#protocols GoogleApigeeTargetServer#protocols}
    */
    readonly protocols?: string[];
    /**
    * The resource ID of the truststore.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#trust_store GoogleApigeeTargetServer#trust_store}
    */
    readonly trustStore?: string;
    /**
    * common_name block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#common_name GoogleApigeeTargetServer#common_name}
    */
    readonly commonName?: GoogleApigeeTargetServerSSlInfoCommonName;
}
export declare function googleApigeeTargetServerSSlInfoToTerraform(struct?: GoogleApigeeTargetServerSSlInfoOutputReference | GoogleApigeeTargetServerSSlInfo): any;
export declare function googleApigeeTargetServerSSlInfoToHclTerraform(struct?: GoogleApigeeTargetServerSSlInfoOutputReference | GoogleApigeeTargetServerSSlInfo): any;
export declare class GoogleApigeeTargetServerSSlInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeTargetServerSSlInfo | undefined;
    set internalValue(value: GoogleApigeeTargetServerSSlInfo | undefined);
    private _ciphers?;
    get ciphers(): string[];
    set ciphers(value: string[]);
    resetCiphers(): void;
    get ciphersInput(): string[] | undefined;
    private _clientAuthEnabled?;
    get clientAuthEnabled(): boolean | cdktf.IResolvable;
    set clientAuthEnabled(value: boolean | cdktf.IResolvable);
    resetClientAuthEnabled(): void;
    get clientAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ignoreValidationErrors?;
    get ignoreValidationErrors(): boolean | cdktf.IResolvable;
    set ignoreValidationErrors(value: boolean | cdktf.IResolvable);
    resetIgnoreValidationErrors(): void;
    get ignoreValidationErrorsInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAlias?;
    get keyAlias(): string;
    set keyAlias(value: string);
    resetKeyAlias(): void;
    get keyAliasInput(): string | undefined;
    private _keyStore?;
    get keyStore(): string;
    set keyStore(value: string);
    resetKeyStore(): void;
    get keyStoreInput(): string | undefined;
    private _protocols?;
    get protocols(): string[];
    set protocols(value: string[]);
    resetProtocols(): void;
    get protocolsInput(): string[] | undefined;
    private _trustStore?;
    get trustStore(): string;
    set trustStore(value: string);
    resetTrustStore(): void;
    get trustStoreInput(): string | undefined;
    private _commonName;
    get commonName(): GoogleApigeeTargetServerSSlInfoCommonNameOutputReference;
    putCommonName(value: GoogleApigeeTargetServerSSlInfoCommonName): void;
    resetCommonName(): void;
    get commonNameInput(): GoogleApigeeTargetServerSSlInfoCommonName | undefined;
}
export interface GoogleApigeeTargetServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#create GoogleApigeeTargetServer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#delete GoogleApigeeTargetServer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#update GoogleApigeeTargetServer#update}
    */
    readonly update?: string;
}
export declare function googleApigeeTargetServerTimeoutsToTerraform(struct?: GoogleApigeeTargetServerTimeouts | cdktf.IResolvable): any;
export declare function googleApigeeTargetServerTimeoutsToHclTerraform(struct?: GoogleApigeeTargetServerTimeouts | cdktf.IResolvable): any;
export declare class GoogleApigeeTargetServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeTargetServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApigeeTargetServerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server google_apigee_target_server}
*/
export declare class GoogleApigeeTargetServer extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_target_server";
    /**
    * Generates CDKTF code for importing a GoogleApigeeTargetServer resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleApigeeTargetServer to import
    * @param importFromId The id of the existing GoogleApigeeTargetServer that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleApigeeTargetServer to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apigee_target_server google_apigee_target_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApigeeTargetServerConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApigeeTargetServerConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _envId?;
    get envId(): string;
    set envId(value: string);
    get envIdInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _sSlInfo;
    get sSlInfo(): GoogleApigeeTargetServerSSlInfoOutputReference;
    putSSlInfo(value: GoogleApigeeTargetServerSSlInfo): void;
    resetSSlInfo(): void;
    get sSlInfoInput(): GoogleApigeeTargetServerSSlInfo | undefined;
    private _timeouts;
    get timeouts(): GoogleApigeeTargetServerTimeoutsOutputReference;
    putTimeouts(value: GoogleApigeeTargetServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApigeeTargetServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
