/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAppEngineApplicationUrlDispatchRulesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_application_url_dispatch_rules#id GoogleAppEngineApplicationUrlDispatchRules#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_application_url_dispatch_rules#project GoogleAppEngineApplicationUrlDispatchRules#project}
    */
    readonly project?: string;
    /**
    * dispatch_rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_application_url_dispatch_rules#dispatch_rules GoogleAppEngineApplicationUrlDispatchRules#dispatch_rules}
    */
    readonly dispatchRules: GoogleAppEngineApplicationUrlDispatchRulesDispatchRules[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_application_url_dispatch_rules#timeouts GoogleAppEngineApplicationUrlDispatchRules#timeouts}
    */
    readonly timeouts?: GoogleAppEngineApplicationUrlDispatchRulesTimeouts;
}
export interface GoogleAppEngineApplicationUrlDispatchRulesDispatchRules {
    /**
    * Domain name to match against. The wildcard "*" is supported if specified before a period: "*.".
    * Defaults to matching all domains: "*".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_application_url_dispatch_rules#domain GoogleAppEngineApplicationUrlDispatchRules#domain}
    */
    readonly domain?: string;
    /**
    * Pathname within the host. Must start with a "/". A single "*" can be included at the end of the path.
    * The sum of the lengths of the domain and path may not exceed 100 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_application_url_dispatch_rules#path GoogleAppEngineApplicationUrlDispatchRules#path}
    */
    readonly path: string;
    /**
    * Pathname within the host. Must start with a "/". A single "*" can be included at the end of the path.
    * The sum of the lengths of the domain and path may not exceed 100 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_application_url_dispatch_rules#service GoogleAppEngineApplicationUrlDispatchRules#service}
    */
    readonly service: string;
}
export declare function googleAppEngineApplicationUrlDispatchRulesDispatchRulesToTerraform(struct?: GoogleAppEngineApplicationUrlDispatchRulesDispatchRules | cdktf.IResolvable): any;
export declare function googleAppEngineApplicationUrlDispatchRulesDispatchRulesToHclTerraform(struct?: GoogleAppEngineApplicationUrlDispatchRulesDispatchRules | cdktf.IResolvable): any;
export declare class GoogleAppEngineApplicationUrlDispatchRulesDispatchRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAppEngineApplicationUrlDispatchRulesDispatchRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAppEngineApplicationUrlDispatchRulesDispatchRules | cdktf.IResolvable | undefined);
    private _domain?;
    get domain(): string;
    set domain(value: string);
    resetDomain(): void;
    get domainInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
}
export declare class GoogleAppEngineApplicationUrlDispatchRulesDispatchRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAppEngineApplicationUrlDispatchRulesDispatchRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAppEngineApplicationUrlDispatchRulesDispatchRulesOutputReference;
}
export interface GoogleAppEngineApplicationUrlDispatchRulesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_application_url_dispatch_rules#create GoogleAppEngineApplicationUrlDispatchRules#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_application_url_dispatch_rules#delete GoogleAppEngineApplicationUrlDispatchRules#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_application_url_dispatch_rules#update GoogleAppEngineApplicationUrlDispatchRules#update}
    */
    readonly update?: string;
}
export declare function googleAppEngineApplicationUrlDispatchRulesTimeoutsToTerraform(struct?: GoogleAppEngineApplicationUrlDispatchRulesTimeouts | cdktf.IResolvable): any;
export declare function googleAppEngineApplicationUrlDispatchRulesTimeoutsToHclTerraform(struct?: GoogleAppEngineApplicationUrlDispatchRulesTimeouts | cdktf.IResolvable): any;
export declare class GoogleAppEngineApplicationUrlDispatchRulesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineApplicationUrlDispatchRulesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAppEngineApplicationUrlDispatchRulesTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_application_url_dispatch_rules google_app_engine_application_url_dispatch_rules}
*/
export declare class GoogleAppEngineApplicationUrlDispatchRules extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_app_engine_application_url_dispatch_rules";
    /**
    * Generates CDKTF code for importing a GoogleAppEngineApplicationUrlDispatchRules resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleAppEngineApplicationUrlDispatchRules to import
    * @param importFromId The id of the existing GoogleAppEngineApplicationUrlDispatchRules that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_application_url_dispatch_rules#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleAppEngineApplicationUrlDispatchRules to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_application_url_dispatch_rules google_app_engine_application_url_dispatch_rules} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAppEngineApplicationUrlDispatchRulesConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAppEngineApplicationUrlDispatchRulesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _dispatchRules;
    get dispatchRules(): GoogleAppEngineApplicationUrlDispatchRulesDispatchRulesList;
    putDispatchRules(value: GoogleAppEngineApplicationUrlDispatchRulesDispatchRules[] | cdktf.IResolvable): void;
    get dispatchRulesInput(): cdktf.IResolvable | GoogleAppEngineApplicationUrlDispatchRulesDispatchRules[] | undefined;
    private _timeouts;
    get timeouts(): GoogleAppEngineApplicationUrlDispatchRulesTimeoutsOutputReference;
    putTimeouts(value: GoogleAppEngineApplicationUrlDispatchRulesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAppEngineApplicationUrlDispatchRulesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
