/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAppEngineDomainMappingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Relative name of the domain serving the application. Example: example.com.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_domain_mapping#domain_name GoogleAppEngineDomainMapping#domain_name}
    */
    readonly domainName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_domain_mapping#id GoogleAppEngineDomainMapping#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether the domain creation should override any existing mappings for this domain.
    * By default, overrides are rejected. Default value: "STRICT" Possible values: ["STRICT", "OVERRIDE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_domain_mapping#override_strategy GoogleAppEngineDomainMapping#override_strategy}
    */
    readonly overrideStrategy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_domain_mapping#project GoogleAppEngineDomainMapping#project}
    */
    readonly project?: string;
    /**
    * ssl_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_domain_mapping#ssl_settings GoogleAppEngineDomainMapping#ssl_settings}
    */
    readonly sslSettings?: GoogleAppEngineDomainMappingSslSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_domain_mapping#timeouts GoogleAppEngineDomainMapping#timeouts}
    */
    readonly timeouts?: GoogleAppEngineDomainMappingTimeouts;
}
export interface GoogleAppEngineDomainMappingResourceRecords {
}
export declare function googleAppEngineDomainMappingResourceRecordsToTerraform(struct?: GoogleAppEngineDomainMappingResourceRecords): any;
export declare function googleAppEngineDomainMappingResourceRecordsToHclTerraform(struct?: GoogleAppEngineDomainMappingResourceRecords): any;
export declare class GoogleAppEngineDomainMappingResourceRecordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAppEngineDomainMappingResourceRecords | undefined;
    set internalValue(value: GoogleAppEngineDomainMappingResourceRecords | undefined);
    get name(): string;
    get rrdata(): string;
    get type(): string;
}
export declare class GoogleAppEngineDomainMappingResourceRecordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAppEngineDomainMappingResourceRecordsOutputReference;
}
export interface GoogleAppEngineDomainMappingSslSettings {
    /**
    * ID of the AuthorizedCertificate resource configuring SSL for the application. Clearing this field will
    * remove SSL support.
    * By default, a managed certificate is automatically created for every domain mapping. To omit SSL support
    * or to configure SSL manually, specify 'SslManagementType.MANUAL' on a 'CREATE' or 'UPDATE' request. You must be
    * authorized to administer the 'AuthorizedCertificate' resource to manually map it to a DomainMapping resource.
    * Example: 12345.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_domain_mapping#certificate_id GoogleAppEngineDomainMapping#certificate_id}
    */
    readonly certificateId?: string;
    /**
    * SSL management type for this domain. If 'AUTOMATIC', a managed certificate is automatically provisioned.
    * If 'MANUAL', 'certificateId' must be manually specified in order to configure SSL for this domain. Possible values: ["AUTOMATIC", "MANUAL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_domain_mapping#ssl_management_type GoogleAppEngineDomainMapping#ssl_management_type}
    */
    readonly sslManagementType: string;
}
export declare function googleAppEngineDomainMappingSslSettingsToTerraform(struct?: GoogleAppEngineDomainMappingSslSettingsOutputReference | GoogleAppEngineDomainMappingSslSettings): any;
export declare function googleAppEngineDomainMappingSslSettingsToHclTerraform(struct?: GoogleAppEngineDomainMappingSslSettingsOutputReference | GoogleAppEngineDomainMappingSslSettings): any;
export declare class GoogleAppEngineDomainMappingSslSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineDomainMappingSslSettings | undefined;
    set internalValue(value: GoogleAppEngineDomainMappingSslSettings | undefined);
    private _certificateId?;
    get certificateId(): string;
    set certificateId(value: string);
    resetCertificateId(): void;
    get certificateIdInput(): string | undefined;
    get pendingManagedCertificateId(): string;
    private _sslManagementType?;
    get sslManagementType(): string;
    set sslManagementType(value: string);
    get sslManagementTypeInput(): string | undefined;
}
export interface GoogleAppEngineDomainMappingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_domain_mapping#create GoogleAppEngineDomainMapping#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_domain_mapping#delete GoogleAppEngineDomainMapping#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_domain_mapping#update GoogleAppEngineDomainMapping#update}
    */
    readonly update?: string;
}
export declare function googleAppEngineDomainMappingTimeoutsToTerraform(struct?: GoogleAppEngineDomainMappingTimeouts | cdktf.IResolvable): any;
export declare function googleAppEngineDomainMappingTimeoutsToHclTerraform(struct?: GoogleAppEngineDomainMappingTimeouts | cdktf.IResolvable): any;
export declare class GoogleAppEngineDomainMappingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineDomainMappingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAppEngineDomainMappingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_domain_mapping google_app_engine_domain_mapping}
*/
export declare class GoogleAppEngineDomainMapping extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_app_engine_domain_mapping";
    /**
    * Generates CDKTF code for importing a GoogleAppEngineDomainMapping resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleAppEngineDomainMapping to import
    * @param importFromId The id of the existing GoogleAppEngineDomainMapping that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_domain_mapping#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleAppEngineDomainMapping to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_domain_mapping google_app_engine_domain_mapping} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAppEngineDomainMappingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAppEngineDomainMappingConfig);
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _overrideStrategy?;
    get overrideStrategy(): string;
    set overrideStrategy(value: string);
    resetOverrideStrategy(): void;
    get overrideStrategyInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _resourceRecords;
    get resourceRecords(): GoogleAppEngineDomainMappingResourceRecordsList;
    private _sslSettings;
    get sslSettings(): GoogleAppEngineDomainMappingSslSettingsOutputReference;
    putSslSettings(value: GoogleAppEngineDomainMappingSslSettings): void;
    resetSslSettings(): void;
    get sslSettingsInput(): GoogleAppEngineDomainMappingSslSettings | undefined;
    private _timeouts;
    get timeouts(): GoogleAppEngineDomainMappingTimeoutsOutputReference;
    putTimeouts(value: GoogleAppEngineDomainMappingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAppEngineDomainMappingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
