/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAppEngineFirewallRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The action to take if this rule matches. Possible values: ["UNSPECIFIED_ACTION", "ALLOW", "DENY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_firewall_rule#action GoogleAppEngineFirewallRule#action}
    */
    readonly action: string;
    /**
    * An optional string description of this rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_firewall_rule#description GoogleAppEngineFirewallRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_firewall_rule#id GoogleAppEngineFirewallRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A positive integer that defines the order of rule evaluation.
    * Rules with the lowest priority are evaluated first.
    *
    * A default rule at priority Int32.MaxValue matches all IPv4 and
    * IPv6 traffic when no previous rule matches. Only the action of
    * this rule can be modified by the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_firewall_rule#priority GoogleAppEngineFirewallRule#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_firewall_rule#project GoogleAppEngineFirewallRule#project}
    */
    readonly project?: string;
    /**
    * IP address or range, defined using CIDR notation, of requests that this rule applies to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_firewall_rule#source_range GoogleAppEngineFirewallRule#source_range}
    */
    readonly sourceRange: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_firewall_rule#timeouts GoogleAppEngineFirewallRule#timeouts}
    */
    readonly timeouts?: GoogleAppEngineFirewallRuleTimeouts;
}
export interface GoogleAppEngineFirewallRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_firewall_rule#create GoogleAppEngineFirewallRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_firewall_rule#delete GoogleAppEngineFirewallRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_firewall_rule#update GoogleAppEngineFirewallRule#update}
    */
    readonly update?: string;
}
export declare function googleAppEngineFirewallRuleTimeoutsToTerraform(struct?: GoogleAppEngineFirewallRuleTimeouts | cdktf.IResolvable): any;
export declare function googleAppEngineFirewallRuleTimeoutsToHclTerraform(struct?: GoogleAppEngineFirewallRuleTimeouts | cdktf.IResolvable): any;
export declare class GoogleAppEngineFirewallRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFirewallRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAppEngineFirewallRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_firewall_rule google_app_engine_firewall_rule}
*/
export declare class GoogleAppEngineFirewallRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_app_engine_firewall_rule";
    /**
    * Generates CDKTF code for importing a GoogleAppEngineFirewallRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleAppEngineFirewallRule to import
    * @param importFromId The id of the existing GoogleAppEngineFirewallRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_firewall_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleAppEngineFirewallRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_firewall_rule google_app_engine_firewall_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAppEngineFirewallRuleConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAppEngineFirewallRuleConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _sourceRange?;
    get sourceRange(): string;
    set sourceRange(value: string);
    get sourceRangeInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleAppEngineFirewallRuleTimeoutsOutputReference;
    putTimeouts(value: GoogleAppEngineFirewallRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAppEngineFirewallRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
