/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAppEngineServiceNetworkSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_service_network_settings#id GoogleAppEngineServiceNetworkSettings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_service_network_settings#project GoogleAppEngineServiceNetworkSettings#project}
    */
    readonly project?: string;
    /**
    * The name of the service these settings apply to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_service_network_settings#service GoogleAppEngineServiceNetworkSettings#service}
    */
    readonly service: string;
    /**
    * network_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_service_network_settings#network_settings GoogleAppEngineServiceNetworkSettings#network_settings}
    */
    readonly networkSettings: GoogleAppEngineServiceNetworkSettingsNetworkSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_service_network_settings#timeouts GoogleAppEngineServiceNetworkSettings#timeouts}
    */
    readonly timeouts?: GoogleAppEngineServiceNetworkSettingsTimeouts;
}
export interface GoogleAppEngineServiceNetworkSettingsNetworkSettings {
    /**
    * The ingress settings for version or service. Default value: "INGRESS_TRAFFIC_ALLOWED_UNSPECIFIED" Possible values: ["INGRESS_TRAFFIC_ALLOWED_UNSPECIFIED", "INGRESS_TRAFFIC_ALLOWED_ALL", "INGRESS_TRAFFIC_ALLOWED_INTERNAL_ONLY", "INGRESS_TRAFFIC_ALLOWED_INTERNAL_AND_LB"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_service_network_settings#ingress_traffic_allowed GoogleAppEngineServiceNetworkSettings#ingress_traffic_allowed}
    */
    readonly ingressTrafficAllowed?: string;
}
export declare function googleAppEngineServiceNetworkSettingsNetworkSettingsToTerraform(struct?: GoogleAppEngineServiceNetworkSettingsNetworkSettingsOutputReference | GoogleAppEngineServiceNetworkSettingsNetworkSettings): any;
export declare function googleAppEngineServiceNetworkSettingsNetworkSettingsToHclTerraform(struct?: GoogleAppEngineServiceNetworkSettingsNetworkSettingsOutputReference | GoogleAppEngineServiceNetworkSettingsNetworkSettings): any;
export declare class GoogleAppEngineServiceNetworkSettingsNetworkSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineServiceNetworkSettingsNetworkSettings | undefined;
    set internalValue(value: GoogleAppEngineServiceNetworkSettingsNetworkSettings | undefined);
    private _ingressTrafficAllowed?;
    get ingressTrafficAllowed(): string;
    set ingressTrafficAllowed(value: string);
    resetIngressTrafficAllowed(): void;
    get ingressTrafficAllowedInput(): string | undefined;
}
export interface GoogleAppEngineServiceNetworkSettingsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_service_network_settings#create GoogleAppEngineServiceNetworkSettings#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_service_network_settings#delete GoogleAppEngineServiceNetworkSettings#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_service_network_settings#update GoogleAppEngineServiceNetworkSettings#update}
    */
    readonly update?: string;
}
export declare function googleAppEngineServiceNetworkSettingsTimeoutsToTerraform(struct?: GoogleAppEngineServiceNetworkSettingsTimeouts | cdktf.IResolvable): any;
export declare function googleAppEngineServiceNetworkSettingsTimeoutsToHclTerraform(struct?: GoogleAppEngineServiceNetworkSettingsTimeouts | cdktf.IResolvable): any;
export declare class GoogleAppEngineServiceNetworkSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineServiceNetworkSettingsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAppEngineServiceNetworkSettingsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_service_network_settings google_app_engine_service_network_settings}
*/
export declare class GoogleAppEngineServiceNetworkSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_app_engine_service_network_settings";
    /**
    * Generates CDKTF code for importing a GoogleAppEngineServiceNetworkSettings resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleAppEngineServiceNetworkSettings to import
    * @param importFromId The id of the existing GoogleAppEngineServiceNetworkSettings that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_service_network_settings#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleAppEngineServiceNetworkSettings to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_app_engine_service_network_settings google_app_engine_service_network_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAppEngineServiceNetworkSettingsConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAppEngineServiceNetworkSettingsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _networkSettings;
    get networkSettings(): GoogleAppEngineServiceNetworkSettingsNetworkSettingsOutputReference;
    putNetworkSettings(value: GoogleAppEngineServiceNetworkSettingsNetworkSettings): void;
    get networkSettingsInput(): GoogleAppEngineServiceNetworkSettingsNetworkSettings | undefined;
    private _timeouts;
    get timeouts(): GoogleAppEngineServiceNetworkSettingsTimeoutsOutputReference;
    putTimeouts(value: GoogleAppEngineServiceNetworkSettingsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAppEngineServiceNetworkSettingsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
