/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApphubApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Required. The Application identifier.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#application_id GoogleApphubApplication#application_id}
    */
    readonly applicationId: string;
    /**
    * Optional. User-defined description of an Application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#description GoogleApphubApplication#description}
    */
    readonly description?: string;
    /**
    * Optional. User-defined name for the Application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#display_name GoogleApphubApplication#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#id GoogleApphubApplication#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Part of 'parent'. See documentation of 'projectsId'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#location GoogleApphubApplication#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#project GoogleApphubApplication#project}
    */
    readonly project?: string;
    /**
    * attributes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#attributes GoogleApphubApplication#attributes}
    */
    readonly attributes?: GoogleApphubApplicationAttributes;
    /**
    * scope block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#scope GoogleApphubApplication#scope}
    */
    readonly scope: GoogleApphubApplicationScope;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#timeouts GoogleApphubApplication#timeouts}
    */
    readonly timeouts?: GoogleApphubApplicationTimeouts;
}
export interface GoogleApphubApplicationAttributesBusinessOwners {
    /**
    * Optional. Contact's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#display_name GoogleApphubApplication#display_name}
    */
    readonly displayName?: string;
    /**
    * Required. Email address of the contacts.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#email GoogleApphubApplication#email}
    */
    readonly email: string;
}
export declare function googleApphubApplicationAttributesBusinessOwnersToTerraform(struct?: GoogleApphubApplicationAttributesBusinessOwners | cdktf.IResolvable): any;
export declare function googleApphubApplicationAttributesBusinessOwnersToHclTerraform(struct?: GoogleApphubApplicationAttributesBusinessOwners | cdktf.IResolvable): any;
export declare class GoogleApphubApplicationAttributesBusinessOwnersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApphubApplicationAttributesBusinessOwners | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApphubApplicationAttributesBusinessOwners | cdktf.IResolvable | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
}
export declare class GoogleApphubApplicationAttributesBusinessOwnersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleApphubApplicationAttributesBusinessOwners[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApphubApplicationAttributesBusinessOwnersOutputReference;
}
export interface GoogleApphubApplicationAttributesCriticality {
    /**
    * Criticality type. Possible values: ["MISSION_CRITICAL", "HIGH", "MEDIUM", "LOW"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#type GoogleApphubApplication#type}
    */
    readonly type: string;
}
export declare function googleApphubApplicationAttributesCriticalityToTerraform(struct?: GoogleApphubApplicationAttributesCriticalityOutputReference | GoogleApphubApplicationAttributesCriticality): any;
export declare function googleApphubApplicationAttributesCriticalityToHclTerraform(struct?: GoogleApphubApplicationAttributesCriticalityOutputReference | GoogleApphubApplicationAttributesCriticality): any;
export declare class GoogleApphubApplicationAttributesCriticalityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApphubApplicationAttributesCriticality | undefined;
    set internalValue(value: GoogleApphubApplicationAttributesCriticality | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleApphubApplicationAttributesDeveloperOwners {
    /**
    * Optional. Contact's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#display_name GoogleApphubApplication#display_name}
    */
    readonly displayName?: string;
    /**
    * Required. Email address of the contacts.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#email GoogleApphubApplication#email}
    */
    readonly email: string;
}
export declare function googleApphubApplicationAttributesDeveloperOwnersToTerraform(struct?: GoogleApphubApplicationAttributesDeveloperOwners | cdktf.IResolvable): any;
export declare function googleApphubApplicationAttributesDeveloperOwnersToHclTerraform(struct?: GoogleApphubApplicationAttributesDeveloperOwners | cdktf.IResolvable): any;
export declare class GoogleApphubApplicationAttributesDeveloperOwnersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApphubApplicationAttributesDeveloperOwners | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApphubApplicationAttributesDeveloperOwners | cdktf.IResolvable | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
}
export declare class GoogleApphubApplicationAttributesDeveloperOwnersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleApphubApplicationAttributesDeveloperOwners[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApphubApplicationAttributesDeveloperOwnersOutputReference;
}
export interface GoogleApphubApplicationAttributesEnvironment {
    /**
    * Environment type. Possible values: ["PRODUCTION", "STAGING", "TEST", "DEVELOPMENT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#type GoogleApphubApplication#type}
    */
    readonly type: string;
}
export declare function googleApphubApplicationAttributesEnvironmentToTerraform(struct?: GoogleApphubApplicationAttributesEnvironmentOutputReference | GoogleApphubApplicationAttributesEnvironment): any;
export declare function googleApphubApplicationAttributesEnvironmentToHclTerraform(struct?: GoogleApphubApplicationAttributesEnvironmentOutputReference | GoogleApphubApplicationAttributesEnvironment): any;
export declare class GoogleApphubApplicationAttributesEnvironmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApphubApplicationAttributesEnvironment | undefined;
    set internalValue(value: GoogleApphubApplicationAttributesEnvironment | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleApphubApplicationAttributesOperatorOwners {
    /**
    * Optional. Contact's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#display_name GoogleApphubApplication#display_name}
    */
    readonly displayName?: string;
    /**
    * Required. Email address of the contacts.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#email GoogleApphubApplication#email}
    */
    readonly email: string;
}
export declare function googleApphubApplicationAttributesOperatorOwnersToTerraform(struct?: GoogleApphubApplicationAttributesOperatorOwners | cdktf.IResolvable): any;
export declare function googleApphubApplicationAttributesOperatorOwnersToHclTerraform(struct?: GoogleApphubApplicationAttributesOperatorOwners | cdktf.IResolvable): any;
export declare class GoogleApphubApplicationAttributesOperatorOwnersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApphubApplicationAttributesOperatorOwners | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApphubApplicationAttributesOperatorOwners | cdktf.IResolvable | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
}
export declare class GoogleApphubApplicationAttributesOperatorOwnersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleApphubApplicationAttributesOperatorOwners[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApphubApplicationAttributesOperatorOwnersOutputReference;
}
export interface GoogleApphubApplicationAttributes {
    /**
    * business_owners block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#business_owners GoogleApphubApplication#business_owners}
    */
    readonly businessOwners?: GoogleApphubApplicationAttributesBusinessOwners[] | cdktf.IResolvable;
    /**
    * criticality block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#criticality GoogleApphubApplication#criticality}
    */
    readonly criticality?: GoogleApphubApplicationAttributesCriticality;
    /**
    * developer_owners block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#developer_owners GoogleApphubApplication#developer_owners}
    */
    readonly developerOwners?: GoogleApphubApplicationAttributesDeveloperOwners[] | cdktf.IResolvable;
    /**
    * environment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#environment GoogleApphubApplication#environment}
    */
    readonly environment?: GoogleApphubApplicationAttributesEnvironment;
    /**
    * operator_owners block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#operator_owners GoogleApphubApplication#operator_owners}
    */
    readonly operatorOwners?: GoogleApphubApplicationAttributesOperatorOwners[] | cdktf.IResolvable;
}
export declare function googleApphubApplicationAttributesToTerraform(struct?: GoogleApphubApplicationAttributesOutputReference | GoogleApphubApplicationAttributes): any;
export declare function googleApphubApplicationAttributesToHclTerraform(struct?: GoogleApphubApplicationAttributesOutputReference | GoogleApphubApplicationAttributes): any;
export declare class GoogleApphubApplicationAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApphubApplicationAttributes | undefined;
    set internalValue(value: GoogleApphubApplicationAttributes | undefined);
    private _businessOwners;
    get businessOwners(): GoogleApphubApplicationAttributesBusinessOwnersList;
    putBusinessOwners(value: GoogleApphubApplicationAttributesBusinessOwners[] | cdktf.IResolvable): void;
    resetBusinessOwners(): void;
    get businessOwnersInput(): cdktf.IResolvable | GoogleApphubApplicationAttributesBusinessOwners[] | undefined;
    private _criticality;
    get criticality(): GoogleApphubApplicationAttributesCriticalityOutputReference;
    putCriticality(value: GoogleApphubApplicationAttributesCriticality): void;
    resetCriticality(): void;
    get criticalityInput(): GoogleApphubApplicationAttributesCriticality | undefined;
    private _developerOwners;
    get developerOwners(): GoogleApphubApplicationAttributesDeveloperOwnersList;
    putDeveloperOwners(value: GoogleApphubApplicationAttributesDeveloperOwners[] | cdktf.IResolvable): void;
    resetDeveloperOwners(): void;
    get developerOwnersInput(): cdktf.IResolvable | GoogleApphubApplicationAttributesDeveloperOwners[] | undefined;
    private _environment;
    get environment(): GoogleApphubApplicationAttributesEnvironmentOutputReference;
    putEnvironment(value: GoogleApphubApplicationAttributesEnvironment): void;
    resetEnvironment(): void;
    get environmentInput(): GoogleApphubApplicationAttributesEnvironment | undefined;
    private _operatorOwners;
    get operatorOwners(): GoogleApphubApplicationAttributesOperatorOwnersList;
    putOperatorOwners(value: GoogleApphubApplicationAttributesOperatorOwners[] | cdktf.IResolvable): void;
    resetOperatorOwners(): void;
    get operatorOwnersInput(): cdktf.IResolvable | GoogleApphubApplicationAttributesOperatorOwners[] | undefined;
}
export interface GoogleApphubApplicationScope {
    /**
    * Required. Scope Type.
    *  Possible values:
    * REGIONAL Possible values: ["REGIONAL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#type GoogleApphubApplication#type}
    */
    readonly type: string;
}
export declare function googleApphubApplicationScopeToTerraform(struct?: GoogleApphubApplicationScopeOutputReference | GoogleApphubApplicationScope): any;
export declare function googleApphubApplicationScopeToHclTerraform(struct?: GoogleApphubApplicationScopeOutputReference | GoogleApphubApplicationScope): any;
export declare class GoogleApphubApplicationScopeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApphubApplicationScope | undefined;
    set internalValue(value: GoogleApphubApplicationScope | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleApphubApplicationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#create GoogleApphubApplication#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#delete GoogleApphubApplication#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#update GoogleApphubApplication#update}
    */
    readonly update?: string;
}
export declare function googleApphubApplicationTimeoutsToTerraform(struct?: GoogleApphubApplicationTimeouts | cdktf.IResolvable): any;
export declare function googleApphubApplicationTimeoutsToHclTerraform(struct?: GoogleApphubApplicationTimeouts | cdktf.IResolvable): any;
export declare class GoogleApphubApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApphubApplicationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApphubApplicationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application google_apphub_application}
*/
export declare class GoogleApphubApplication extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apphub_application";
    /**
    * Generates CDKTF code for importing a GoogleApphubApplication resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleApphubApplication to import
    * @param importFromId The id of the existing GoogleApphubApplication that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleApphubApplication to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_application google_apphub_application} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApphubApplicationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApphubApplicationConfig);
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    get applicationIdInput(): string | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _attributes;
    get attributes(): GoogleApphubApplicationAttributesOutputReference;
    putAttributes(value: GoogleApphubApplicationAttributes): void;
    resetAttributes(): void;
    get attributesInput(): GoogleApphubApplicationAttributes | undefined;
    private _scope;
    get scope(): GoogleApphubApplicationScopeOutputReference;
    putScope(value: GoogleApphubApplicationScope): void;
    get scopeInput(): GoogleApphubApplicationScope | undefined;
    private _timeouts;
    get timeouts(): GoogleApphubApplicationTimeoutsOutputReference;
    putTimeouts(value: GoogleApphubApplicationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApphubApplicationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
