/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApphubServiceProjectAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service_project_attachment#id GoogleApphubServiceProjectAttachment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service_project_attachment#project GoogleApphubServiceProjectAttachment#project}
    */
    readonly project?: string;
    /**
    * "Immutable. Service project name in the format: \"projects/abc\"
    * or \"projects/123\". As input, project name with either project id or number
    * are accepted. As output, this field will contain project number. "
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service_project_attachment#service_project GoogleApphubServiceProjectAttachment#service_project}
    */
    readonly serviceProject?: string;
    /**
    * Required. The service project attachment identifier must contain the project_id of the service project specified in the service_project_attachment.service_project field. Hint: "projects/{project_id}"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service_project_attachment#service_project_attachment_id GoogleApphubServiceProjectAttachment#service_project_attachment_id}
    */
    readonly serviceProjectAttachmentId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service_project_attachment#timeouts GoogleApphubServiceProjectAttachment#timeouts}
    */
    readonly timeouts?: GoogleApphubServiceProjectAttachmentTimeouts;
}
export interface GoogleApphubServiceProjectAttachmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service_project_attachment#create GoogleApphubServiceProjectAttachment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service_project_attachment#delete GoogleApphubServiceProjectAttachment#delete}
    */
    readonly delete?: string;
}
export declare function googleApphubServiceProjectAttachmentTimeoutsToTerraform(struct?: GoogleApphubServiceProjectAttachmentTimeouts | cdktf.IResolvable): any;
export declare function googleApphubServiceProjectAttachmentTimeoutsToHclTerraform(struct?: GoogleApphubServiceProjectAttachmentTimeouts | cdktf.IResolvable): any;
export declare class GoogleApphubServiceProjectAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApphubServiceProjectAttachmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApphubServiceProjectAttachmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service_project_attachment google_apphub_service_project_attachment}
*/
export declare class GoogleApphubServiceProjectAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apphub_service_project_attachment";
    /**
    * Generates CDKTF code for importing a GoogleApphubServiceProjectAttachment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleApphubServiceProjectAttachment to import
    * @param importFromId The id of the existing GoogleApphubServiceProjectAttachment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service_project_attachment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleApphubServiceProjectAttachment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service_project_attachment google_apphub_service_project_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApphubServiceProjectAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApphubServiceProjectAttachmentConfig);
    get createTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceProject?;
    get serviceProject(): string;
    set serviceProject(value: string);
    resetServiceProject(): void;
    get serviceProjectInput(): string | undefined;
    private _serviceProjectAttachmentId?;
    get serviceProjectAttachmentId(): string;
    set serviceProjectAttachmentId(value: string);
    get serviceProjectAttachmentIdInput(): string | undefined;
    get state(): string;
    get uid(): string;
    private _timeouts;
    get timeouts(): GoogleApphubServiceProjectAttachmentTimeoutsOutputReference;
    putTimeouts(value: GoogleApphubServiceProjectAttachmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApphubServiceProjectAttachmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
