/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApphubServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Part of 'parent'.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#application_id GoogleApphubService#application_id}
    */
    readonly applicationId: string;
    /**
    * User-defined description of a Service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#description GoogleApphubService#description}
    */
    readonly description?: string;
    /**
    * Immutable. The resource name of the original discovered service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#discovered_service GoogleApphubService#discovered_service}
    */
    readonly discoveredService: string;
    /**
    * User-defined name for the Service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#display_name GoogleApphubService#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#id GoogleApphubService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Part of 'parent'.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#location GoogleApphubService#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#project GoogleApphubService#project}
    */
    readonly project?: string;
    /**
    * The Service identifier.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#service_id GoogleApphubService#service_id}
    */
    readonly serviceId: string;
    /**
    * attributes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#attributes GoogleApphubService#attributes}
    */
    readonly attributes?: GoogleApphubServiceAttributes;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#timeouts GoogleApphubService#timeouts}
    */
    readonly timeouts?: GoogleApphubServiceTimeouts;
}
export interface GoogleApphubServiceServiceProperties {
}
export declare function googleApphubServiceServicePropertiesToTerraform(struct?: GoogleApphubServiceServiceProperties): any;
export declare function googleApphubServiceServicePropertiesToHclTerraform(struct?: GoogleApphubServiceServiceProperties): any;
export declare class GoogleApphubServiceServicePropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApphubServiceServiceProperties | undefined;
    set internalValue(value: GoogleApphubServiceServiceProperties | undefined);
    get gcpProject(): string;
    get location(): string;
    get zone(): string;
}
export declare class GoogleApphubServiceServicePropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApphubServiceServicePropertiesOutputReference;
}
export interface GoogleApphubServiceServiceReference {
}
export declare function googleApphubServiceServiceReferenceToTerraform(struct?: GoogleApphubServiceServiceReference): any;
export declare function googleApphubServiceServiceReferenceToHclTerraform(struct?: GoogleApphubServiceServiceReference): any;
export declare class GoogleApphubServiceServiceReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApphubServiceServiceReference | undefined;
    set internalValue(value: GoogleApphubServiceServiceReference | undefined);
    get uri(): string;
}
export declare class GoogleApphubServiceServiceReferenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApphubServiceServiceReferenceOutputReference;
}
export interface GoogleApphubServiceAttributesBusinessOwners {
    /**
    * Contact's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#display_name GoogleApphubService#display_name}
    */
    readonly displayName?: string;
    /**
    * Required. Email address of the contacts.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#email GoogleApphubService#email}
    */
    readonly email: string;
}
export declare function googleApphubServiceAttributesBusinessOwnersToTerraform(struct?: GoogleApphubServiceAttributesBusinessOwners | cdktf.IResolvable): any;
export declare function googleApphubServiceAttributesBusinessOwnersToHclTerraform(struct?: GoogleApphubServiceAttributesBusinessOwners | cdktf.IResolvable): any;
export declare class GoogleApphubServiceAttributesBusinessOwnersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApphubServiceAttributesBusinessOwners | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApphubServiceAttributesBusinessOwners | cdktf.IResolvable | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
}
export declare class GoogleApphubServiceAttributesBusinessOwnersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleApphubServiceAttributesBusinessOwners[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApphubServiceAttributesBusinessOwnersOutputReference;
}
export interface GoogleApphubServiceAttributesCriticality {
    /**
    * Criticality type. Possible values: ["MISSION_CRITICAL", "HIGH", "MEDIUM", "LOW"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#type GoogleApphubService#type}
    */
    readonly type: string;
}
export declare function googleApphubServiceAttributesCriticalityToTerraform(struct?: GoogleApphubServiceAttributesCriticalityOutputReference | GoogleApphubServiceAttributesCriticality): any;
export declare function googleApphubServiceAttributesCriticalityToHclTerraform(struct?: GoogleApphubServiceAttributesCriticalityOutputReference | GoogleApphubServiceAttributesCriticality): any;
export declare class GoogleApphubServiceAttributesCriticalityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApphubServiceAttributesCriticality | undefined;
    set internalValue(value: GoogleApphubServiceAttributesCriticality | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleApphubServiceAttributesDeveloperOwners {
    /**
    * Contact's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#display_name GoogleApphubService#display_name}
    */
    readonly displayName?: string;
    /**
    * Required. Email address of the contacts.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#email GoogleApphubService#email}
    */
    readonly email: string;
}
export declare function googleApphubServiceAttributesDeveloperOwnersToTerraform(struct?: GoogleApphubServiceAttributesDeveloperOwners | cdktf.IResolvable): any;
export declare function googleApphubServiceAttributesDeveloperOwnersToHclTerraform(struct?: GoogleApphubServiceAttributesDeveloperOwners | cdktf.IResolvable): any;
export declare class GoogleApphubServiceAttributesDeveloperOwnersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApphubServiceAttributesDeveloperOwners | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApphubServiceAttributesDeveloperOwners | cdktf.IResolvable | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
}
export declare class GoogleApphubServiceAttributesDeveloperOwnersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleApphubServiceAttributesDeveloperOwners[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApphubServiceAttributesDeveloperOwnersOutputReference;
}
export interface GoogleApphubServiceAttributesEnvironment {
    /**
    * Environment type. Possible values: ["PRODUCTION", "STAGING", "TEST", "DEVELOPMENT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#type GoogleApphubService#type}
    */
    readonly type: string;
}
export declare function googleApphubServiceAttributesEnvironmentToTerraform(struct?: GoogleApphubServiceAttributesEnvironmentOutputReference | GoogleApphubServiceAttributesEnvironment): any;
export declare function googleApphubServiceAttributesEnvironmentToHclTerraform(struct?: GoogleApphubServiceAttributesEnvironmentOutputReference | GoogleApphubServiceAttributesEnvironment): any;
export declare class GoogleApphubServiceAttributesEnvironmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApphubServiceAttributesEnvironment | undefined;
    set internalValue(value: GoogleApphubServiceAttributesEnvironment | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleApphubServiceAttributesOperatorOwners {
    /**
    * Contact's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#display_name GoogleApphubService#display_name}
    */
    readonly displayName?: string;
    /**
    * Required. Email address of the contacts.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#email GoogleApphubService#email}
    */
    readonly email: string;
}
export declare function googleApphubServiceAttributesOperatorOwnersToTerraform(struct?: GoogleApphubServiceAttributesOperatorOwners | cdktf.IResolvable): any;
export declare function googleApphubServiceAttributesOperatorOwnersToHclTerraform(struct?: GoogleApphubServiceAttributesOperatorOwners | cdktf.IResolvable): any;
export declare class GoogleApphubServiceAttributesOperatorOwnersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApphubServiceAttributesOperatorOwners | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApphubServiceAttributesOperatorOwners | cdktf.IResolvable | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
}
export declare class GoogleApphubServiceAttributesOperatorOwnersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleApphubServiceAttributesOperatorOwners[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApphubServiceAttributesOperatorOwnersOutputReference;
}
export interface GoogleApphubServiceAttributes {
    /**
    * business_owners block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#business_owners GoogleApphubService#business_owners}
    */
    readonly businessOwners?: GoogleApphubServiceAttributesBusinessOwners[] | cdktf.IResolvable;
    /**
    * criticality block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#criticality GoogleApphubService#criticality}
    */
    readonly criticality?: GoogleApphubServiceAttributesCriticality;
    /**
    * developer_owners block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#developer_owners GoogleApphubService#developer_owners}
    */
    readonly developerOwners?: GoogleApphubServiceAttributesDeveloperOwners[] | cdktf.IResolvable;
    /**
    * environment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#environment GoogleApphubService#environment}
    */
    readonly environment?: GoogleApphubServiceAttributesEnvironment;
    /**
    * operator_owners block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#operator_owners GoogleApphubService#operator_owners}
    */
    readonly operatorOwners?: GoogleApphubServiceAttributesOperatorOwners[] | cdktf.IResolvable;
}
export declare function googleApphubServiceAttributesToTerraform(struct?: GoogleApphubServiceAttributesOutputReference | GoogleApphubServiceAttributes): any;
export declare function googleApphubServiceAttributesToHclTerraform(struct?: GoogleApphubServiceAttributesOutputReference | GoogleApphubServiceAttributes): any;
export declare class GoogleApphubServiceAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApphubServiceAttributes | undefined;
    set internalValue(value: GoogleApphubServiceAttributes | undefined);
    private _businessOwners;
    get businessOwners(): GoogleApphubServiceAttributesBusinessOwnersList;
    putBusinessOwners(value: GoogleApphubServiceAttributesBusinessOwners[] | cdktf.IResolvable): void;
    resetBusinessOwners(): void;
    get businessOwnersInput(): cdktf.IResolvable | GoogleApphubServiceAttributesBusinessOwners[] | undefined;
    private _criticality;
    get criticality(): GoogleApphubServiceAttributesCriticalityOutputReference;
    putCriticality(value: GoogleApphubServiceAttributesCriticality): void;
    resetCriticality(): void;
    get criticalityInput(): GoogleApphubServiceAttributesCriticality | undefined;
    private _developerOwners;
    get developerOwners(): GoogleApphubServiceAttributesDeveloperOwnersList;
    putDeveloperOwners(value: GoogleApphubServiceAttributesDeveloperOwners[] | cdktf.IResolvable): void;
    resetDeveloperOwners(): void;
    get developerOwnersInput(): cdktf.IResolvable | GoogleApphubServiceAttributesDeveloperOwners[] | undefined;
    private _environment;
    get environment(): GoogleApphubServiceAttributesEnvironmentOutputReference;
    putEnvironment(value: GoogleApphubServiceAttributesEnvironment): void;
    resetEnvironment(): void;
    get environmentInput(): GoogleApphubServiceAttributesEnvironment | undefined;
    private _operatorOwners;
    get operatorOwners(): GoogleApphubServiceAttributesOperatorOwnersList;
    putOperatorOwners(value: GoogleApphubServiceAttributesOperatorOwners[] | cdktf.IResolvable): void;
    resetOperatorOwners(): void;
    get operatorOwnersInput(): cdktf.IResolvable | GoogleApphubServiceAttributesOperatorOwners[] | undefined;
}
export interface GoogleApphubServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#create GoogleApphubService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#delete GoogleApphubService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#update GoogleApphubService#update}
    */
    readonly update?: string;
}
export declare function googleApphubServiceTimeoutsToTerraform(struct?: GoogleApphubServiceTimeouts | cdktf.IResolvable): any;
export declare function googleApphubServiceTimeoutsToHclTerraform(struct?: GoogleApphubServiceTimeouts | cdktf.IResolvable): any;
export declare class GoogleApphubServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApphubServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApphubServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service google_apphub_service}
*/
export declare class GoogleApphubService extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apphub_service";
    /**
    * Generates CDKTF code for importing a GoogleApphubService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleApphubService to import
    * @param importFromId The id of the existing GoogleApphubService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleApphubService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_service google_apphub_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApphubServiceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApphubServiceConfig);
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    get applicationIdInput(): string | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _discoveredService?;
    get discoveredService(): string;
    set discoveredService(value: string);
    get discoveredServiceInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    get serviceIdInput(): string | undefined;
    private _serviceProperties;
    get serviceProperties(): GoogleApphubServiceServicePropertiesList;
    private _serviceReference;
    get serviceReference(): GoogleApphubServiceServiceReferenceList;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _attributes;
    get attributes(): GoogleApphubServiceAttributesOutputReference;
    putAttributes(value: GoogleApphubServiceAttributes): void;
    resetAttributes(): void;
    get attributesInput(): GoogleApphubServiceAttributes | undefined;
    private _timeouts;
    get timeouts(): GoogleApphubServiceTimeoutsOutputReference;
    putTimeouts(value: GoogleApphubServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApphubServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
